	include	'tao.inc'
	include	'lib/globals.inc'

.macro	RSRESET
vars_cnt:=0
.endm

.macro	RSSET
vars_cnt:=(%1)/4
.endm

.macro	RS	;label,count
%1=vars_cnt*4
vars_cnt:=vars_cnt+(%2)
.endm

*CT_USER usage
*CT_USER1 My vars (r3)
*CT_USER2 Pointer to Array header template
*CT_USER3 Pointer to mem block of bitmap handles
*CT_USER4 Stack pointer

dim_max	=	20	;max mumber of array dimensions.
	RSRESET		;structure for arraytemplate
 RS	arh_memnode,1	;pointer to mem node
 RS	arh_headsize,1	;size of header (bytes)
 RS	arh_datasize,1	;size of each element (bytes)
 RS	arh_numbdims,1	;number of dimensions
 RS	arh_dimsizes,dim_max	;dim_0_size......dim_N_size
 RS	arh_headmax,1



.macro	basicstart
	include	'%1.var'

******************************************************************
.if	~?def	toolflag
	node	basproc,CONTROLTP,0,TEMPLATE|guiflag
 control	NULL,4096+__varsize,mb_mouse|mb_data|mb_key|mb_resize|mb_raw,NULL,1,NULL,NULL
basvars:	dc.i	basvarse-basvars	;offset to next component
	dc.i	NULL		;code vector
*** Template for array header
	blk.i	arh_headmax
*Stuff all thread specific variables here*
	dc.i	basvarse-basvars	 ;offset to last component
basvarse:
	component	bastd2-basproc
	compend

	tstring	bastd2,'%1''
	nodeend	basproc
.endif
******************************************************************

	node	tl_bwork,TOOLTP,VP,TEMPLATE
	tool	'%1''

******************************************************************
.if	~?def	toolflag
	openlib			;open hll lib
	cpy	r7,[r6+CT_USER4]	;save stack pointer

	cpy	10,r8		;10 windows
	cpy	4,r9		;4 bytes
	qcall	LIB/CALLOC
	tst	r0
	beq	tidyexit
	cpy	r0,[r6+CT_USER3]

;point r3 to arraytemplate
	cpy	r6,r3
	add	ND_SIZE,r3
	add	[r3+CP_VEC],r3
	add	CP_SIZE,r3		;r3 points to template
	cpy	r3,[r6+CT_USER2]
.else
	psh	[r6+CT_USER1]	;save calllers vars
.endif
******************************************************************

*point r3 to vars
	lea	[r7+(-__varsize)],r3
	while	r3<>r7
	 sub	4,r7
	 clr	[r7]
	endwhile
	cpy	r3,[r6+CT_USER1]
.endm

.macro	basicend
*Basic subroutines
**
*alloc an array and return or jump to aryallocerr if not enough mem
dimarray:	qcall	BASIC/ARRAY/DIMARRAY
	tst	r8
	beq	aryallocerr
	ret
**
*error stuff
gotoerror:	tracef	'0 passed as input to On N GOTO'
	got	tidyexit

aryallocerr:
	tracef	'Array alloc failed\n'
	got	tidyexit

.if	?def	__arraychecks	;only include this if array checks on.
array_ov:	tracef	'Attempted array access above allocated range\n'
	sub	MN_SIZE,r8
	got	getoffs
array_uf:	tracef	'Attempted array access below allocated range\n'

getoffs:	psh	r3
	add	ARRAYSTART,r3
	cpy	ARRAYSIZE,r2
	cpy	r3,r1
testarrays:	cmp	[r3],r10
	beq	gotary_

	add	4,r3
	sub	1,r2
	tst	r2
	bne	testarrays
	pop	r3

	got	tidyexit

gotary_:	sub	r1,r3
	asr	2,r3
	tracef	'Array entry %%i, mem offset %%i',r3,r8
	cpy	r2,r3
	pop	r3
	got	tidyexit
.endif
*

tidyexit:

********************************************************
.if	~?def	toolflag
;free arrays and strings
.if	ARRAYSIZE
	psh	r3
	add	ARRAYSTART,r3
	cpy	ARRAYSIZE,r2
freearrays:	cpy	r3,r8
	qcall BASIC/ARRAY/FREARRAY	;check if alloced and free
	add	4,r3
	sub	1,r2
	tst	r2
	bne	freearrays
	pop	r3
.endif

.if	STRINGSIZE
	add	STRINGSTART,r3
	cpy	STRINGSIZE,r15
f_strings:	cpy	[r3],r0
	tst	r0
	beq	nofree_str
	cpy	[r0+string_mem],r8
	add	string_len,r0
	freemem	r0,r8
nofree_str:	add	4,r3
	sub	1,r15
	tst	r15
	bne	f_strings
.endif

*******
*Close the windows
	cpy	[r6+CT_USER3],r1	;look for entry in
	cpy	[r1+(-4)],r8		;window table.
	sub	MN_SIZE,r8
moreclose:	cpy	[r1],r0
	tst	r0
	beq	noclose

	pshm	r1,r8
	lcall	r0,WN_CLOSE
	popm	r8,r1

noclose:	add	4,r1
	sub	4,r8
	tst	r8
	bne	moreclose

*******
	cpy	[r6+CT_USER4],r7
	closelib
.else
	add	__varsize,r7
	pop	[r6+CT_USER1]	;restore callers vars
.endif
********************************************************
	ret


	even
*null string
	dc.i	0,12		;len,mem
_nullstr:	dc.i	0		;null data

	include	'%1.dat'

;	endline	bwork
	toolend	tl_bwork
	nodeend	tl_bwork

*set up default mail bits for control object
.if	~?def	mb_mouse
mb_mouse	=MOUSETP
.endif
.if	~?def	mb_data
mb_data	=DATATP
.endif
.if	~?def	mb_key
mb_key	=KEYBOARDTP
.endif
.if	~?def	mb_resize
mb_resize	=0
.endif
.if	~?def	mb_raw
mb_raw	=0
.endif

*set up default gui flag for control object
.if	~?def	guiflag
guiflag	=0
.endif

.endm

********************
;inputs= ra,rb
;outputs rb=-1 if ra=rb
;else    rb=0

.macro	eq
	cmp%S	%1,%2
	bne	neq%L
	cpy%S	-1,%2
	got	doneeq%L
neq%L:	cpy%S	0,%2
doneeq%L:
.endm

;outputs rb=-1 if ra<rb
;else    rb=0
.macro	lt
	cmp%S	%1,%2
	bge	nlt%L
	cpy%S	-1,%2
	got	donelt%L
nlt%L:	cpy%S	0,%2
donelt%L:
.endm

;outputs rb=-1 if ra>rb
;else    rb=0
.macro	gt
	cmp%S	%1,%2
	ble	ngt%L
	cpy%S	-1,%2
	got	donegt%L
ngt%L:	cpy%S	0,%2
donegt%L:
.endm

;outputs rb=-1 if ra>=rb
;else    rb=0
.macro	ge
	cmp%S	%1,%2
	blt	nge%L
	cpy%S	-1,%2
	got	donege%L
nge%L:	cpy%S	0,%2
donege%L:
.endm

;outputs rb=-1 if ra<=rb
;else    rb=0
.macro	le
	cmp%S	%1,%2
	bgt	nle%L
	cpy%S	-1,%2
	got	donele%L
nle%L:	cpy%S	0,%2
donele%L:
.endm

;outputs rb=-1 if ra<>rb
.macro	ne
	cmp%S	%1,%2
	beq	nne%L
	cpy%S	-1,%2
	got	donene%L
nne%L:	cpy%S	0,%2
donene%L:
.endm

*******************************
*String code

string_len = -8
string_mem = -4
string_data = 0


*Code to get %2 pointing to actual string data
.macro	_stringaddr
_ssflag :=	0
.if	?REG(%1)
	copy	%1,%2
_ssflag :=	1
.endif

.if	'%1{1,1}' =	'['
	cpy	%1,%2
	tst	%2
	bne	_somestr%L
	lea	_nullstr,%2
_somestr%L:
_ssflag :=	1
.endif

.if	_ssflag=0
	lea	%1,%2	;must be absolute label so no indirection
.endif
.endm

*1st time around. String (effective) addr in %1
*eg stringstart [r0+a$] or stringstart dummystring
*uses r8,r9,r10

.macro	stringstart
	pshm	r0,r1

	_stringaddr	%1,r10

_getstrmem%L:
	cpy	[r10+string_mem],r8
	tao	allocmem
	tst	r8
	beq	_getstrmem%L

	add	8,r0
	cpy	r8,[r0+string_mem]
	cpy	[r10+string_len],r8
	cpy	r8,[r0+string_len]
	add	2,r8		;for null term
	cpb	r10,r0,r8		;copy string data
	cpy	r0,r8		;r8 points to string
	popm	r1,r0
.endm

*Subsequent cases of string addition
*effective addr in %1
*uses r8,r9,r11

.macro	stringadd
	pshm	r0,r1,r2,r3

	_stringaddr	%1,r11

	cpy	r8,r0		;point r0 at string
	cpy	[r0+string_len],r8
	add	10,r8		;4 for mem,4 for len,2 for null
	add	[r11+string_len],r8	;get total reqrd
	cmp	[r0+string_mem],r8
	ble	_justcopy%L

	cpy	r0,r3
	cpy	r8,r2
_moresmem%L:
	tao	allocmem
	tst	r8
	bne	_got_smem%L
	cpy	r2,r8
	got	_moresmem%L
_got_smem%L:
	add	8,r0
	cpy	r8,[r0+string_mem]
	cpy	[r3+string_len],r8
	cpy	r8,[r0+string_len]
	cpb	r3,r0,r8		;copy old string to start of new

	cpy	[r3+string_mem],r8
	exg	r0,r3

	psh	r2
	psh	r10
	sub	8,r0
	tao	freemem
	pop	r10
	pop	r8		;get total len back

	cpy	r3,r0

_justcopy%L:
	cpy	r0,r1
	add	[r0+string_len],r1	;point to end of string

	sub	10,r8		;mem,len & null
	cpy	r8,[r0+string_len]

	cpy	[r11+string_len],r8
	add	2,r8		;for null
	cpb	r11,r1,r8
	cpy	r0,r8		;r8 points to string
	popm	r3,r2,r1,r0
*r8 now has concatanated string
.endm

.macro	stringfree
*string in %1 (must be a register)
*checks if string is valid or not.
.check	%N=1
.check	?REG(%1)
	tst	%1
	beq	_nostfree%L
	pshm	r0,r1,r2,r8,r9,r10
	copy	%1,r8
	lea	[r8+string_len],r0
	cpy	[r8+string_mem],r8
;	tracef	'Freeing %%d %%d \n',r0,r8
	tao	freemem
	popm	r10,r9,r8,r2,r1,r0
_nostfree%L:
.endm

******************************
*Print code
.macro	PRINT_S	;handle,term chr 	;print a string
.check	%N=2
	copy	%1,r0
	copy	%2,r9
	qcall	basic/system/print_s
.endm
.macro	PRINT_B	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	b2i	r8
	qcall	basic/system/print_i
.endm
.macro	PRINT_U	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	qcall	basic/system/print_i
.endm
.macro	PRINT_I	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	qcall	basic/system/print_i
.endm
.macro	PRINT_L	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	qcall	basic/system/print_l
.endm
.macro	PRINT_F	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	qcall	basic/system/print_f
.endm
.macro	PRINT_D	;handle,term chr 	;print an int
.check	%N=2
	copy	%1,r1
	copy	%2,r11
	qcall	basic/system/print_d
.endm
