compiler ongui
compiler resize

'Polygon test code
include 'basic/include/pworld.def'
include 'basic/include/all.def'

defint win,worldhandle,geohandle,camtranshandle,camhandle,objtranshandle
defint xrot,yrot,zrot,objectz,fade
defint objecthandle,texturehandle
defint dum,button,masterbut,mx,my,x,y,closehandle
defint width,height,flength,iflags
defstr filename$

'Image variables
width=300
height=300
flength=65536
iflags=1+8

dim geometry(0) AS BYTE
dim texturemap(0) AS BYTE
dim localcamtrans(1) AS PWTRANSFORM
dim localobjtrans(1) AS PWTRANSFORM


win=openwindow(width,height):if win=0 then end
setpal(win,0,0,0)
gosub resizewin
goto getname

resizewin:
clrgob(win,0)
cuigadgets(win,7,"BASIC Polygon viewer",dum,dum,closehandle,dum,dum)
wninfo(win,dum,dum,dum,width,height,dum)
dim imagebuffer(width-9,height-9) AS BYTE
return

main:
'Load file
dum=loadarray(filename$,varptr(geometry()))
if dum<1 then goto quit

'Load texture map
dum=loadarray("bitmaps/marble.tbm",varptr(texturemap()))
if dum<1 then goto quit

'open polygon world
worldhandle=openworld(0)
if worldhandle=0 then goto quit

'open texture
texturehandle=opentexture(worldhandle,texturemap())
if texturehandle=0 then goto wquit

'open geometry
geohandle=opengeometry(worldhandle,geometry())
if geohandle=0 then goto wquit

'open camera transform
camtranshandle=opentransform(worldhandle)
if camtranshandle=0 then goto wquit

'open camera
camhandle=opencamera(worldhandle,camtranshandle)
if camhandle=0 then goto wquit

'init local camera transform
matinit(localcamtrans())
matscale(localcamtrans(),0)
matmove(localcamtrans(),0,0,0)

'set camera transform from local transform
set(worldhandle,camtranshandle,localcamtrans())

'open object transform
objtranshandle=opentransform(worldhandle)
if objtranshandle=0 then goto quit

'open object
objecthandle=openobject(worldhandle,geohandle,objtranshandle,varptr(texturehandle),1)
if objecthandle=0 then goto quit

'init local object transform
matscale(localobjtrans(),65536*275)
objectz=200*65536
fade=0

while objectz<300000000
'rotate object transform
 matinit(localobjtrans())
 matrotx(localobjtrans(),xrot)
 matroty(localobjtrans(),yrot)
 matrotz(localobjtrans(),zrot)
 matmove(localobjtrans(),0,0,objectz)
 set(worldhandle,objtranshandle,localobjtrans())
 objectz=objectz+fade

 xrot=xrot+164
 yrot=yrot+324
 zrot=zrot+388

'Do resizing
 if testresize()=win then
  resize(win,32,32,0,1024,1024,0)
  gosub resizewin
 endif

'generate frame
 image(worldhandle,camhandle,imagebuffer(),width-8,height-8-16,flength,iflags)
 blit(win,imagebuffer(),4,4+16)
 update(win)

 if inmouse(0,x,y,button)<>0 then fade=30000000:masterbut=button:mx=x:my=y
wend

wquit:
closeworld(worldhandle)

if masterbut=1 then
if hitgob(win,mx,my,1,1,dum,dum,dum,dum)<>closehandle then
getname:
 cls(win)
 update(win)
 if browser("basic/3dobject/*.img",filename$)<>0 then goto main
endif
endif

quit:
end
