' Cellular automata simulating the development of crystal latices
' Written in TaoBasic by Tim Moore, based on a Scientific American article.

include 'basic/include/all.def'

defint old,new,mincol,maxcol,sx,sy,win,closeg
defint x,y,z,flag,yt,yb,xt,xb,nc,z1,z2,tempvar,mx,my

old=0:new=1
mincol=18
maxcol=31

sx=149:rem 1 less than the x size
sy=149

win=openwindow(sx+9,sy+9+16):if win=0 then end
cuigadgets(win,7,"Cellular",x,x,closeg,x,x)

DIM Aworld(sx,sy,1) AS UBYTE

for x=0 to sx
for y=0 to sy
Aworld(x,y,old)=rnd(maxcol-mincol)+mincol
next:next

blit(win,Aworld(),4,4+16):update(win)

label:
let z=timer()
flag=0
for y=0 to sy
for x=0 to sx
 yt=y-1:if yt<0 then yt=yt+sy
 yb=y+1:if yb>sy then yb=yb-sy
 xt=x-1:if xt<0 then xt=xt+sx
 xb=x+1:if xb>sx then xb=xb-sx
 nc=Aworld(x,y,old)+1:if nc=maxcol then nc=mincol
 if Aworld(x,yt,old)=nc then Aworld(x,y,new)=nc:goto donescan
 if Aworld(x,yb,old)=nc then Aworld(x,y,new)=nc:goto donescan
 if Aworld(xt,y,old)=nc then Aworld(x,y,new)=nc:goto donescan
 if Aworld(xb,y,old)=nc then Aworld(x,y,new)=nc:goto donescan
 Aworld(x,y,new)=Aworld(x,y,old)
 donescan:
next:next

z1=timer()

blitspr(win,Aworld(),4,4+16,sy+1,new,0)
update(win)

z2=timer()
'print #twin,"calc ";z1-z;" plot ";z2-z1:update(twin)
tempvar=old:old=new:new=tempvar
if inmouse(0,mx,my,tempvar)=0 then goto label
if tempvar=2 then end
if hitgob(win,mx,my,1,1,tempvar,tempvar,tempvar,tempvar)<>closeg then goto label
end
