compiler ongui
compiler resize

include 'basic/include/pworld.def'
include 'basic/include/all.def'

defint win,worldhandle,geohandle,camtranshandle,camhandle,objtranshandle
defint objectz,fade
defint objecthandle,k,offset
defint dum,mx,my,x,y,closehandle,button,setup
defint width,height,flength,iflags
defint clipx1,clipx2,clipy1,clipy2,clipz1,clipz2
defint numberofletters,maxletters,currentx,currenty,gap,startx,initz
defstr k$

TYPE LETTERTYPE
transhandle AS INTEGER
xpos AS INTEGER
ypos AS INTEGER
zpos AS INTEGER
xrot AS INTEGER
yrot AS INTEGER
zrot AS INTEGER
dx AS INTEGER
dy AS INTEGER
dz AS INTEGER
dxrot AS INTEGER
dyrot AS INTEGER
dzrot AS INTEGER
END TYPE


'Image variables
width=300
height=300
flength=65536
iflags=1
gap=65536*600:currentx=0-gap*3/2:currenty=gap*3/2:startx=currentx
initz=1400*65536
setup=0-1

dim geometry(0) AS INTEGER: 'Integer for accessing offset words at start of geometry file.
dim localcamtrans(1) AS PWTRANSFORM
dim localobjtrans(1) AS PWTRANSFORM
dim imagebuffer(0,0) AS UBYTE:' Dimmed here so that compiler is aware.

maxletters=20
dim lettervars(maxletters) AS LETTERTYPE
numberofletters=0

win=openwindow(width,height):if win=0 then goto quit
setpal(win,0,0,0)
gosub resizewin
'Load file
dum=loadarray("basic/3dobject/font1/font1.img",varptr(geometry()))
if dum<1 then goto quit

main:
'open polygon world
worldhandle=openworld(0)
if worldhandle=0 then goto quit

'open camera transform
camtranshandle=opentransform(worldhandle)
if camtranshandle=0 then goto wquit

'open camera
camhandle=opencamera(worldhandle,camtranshandle)
if camhandle=0 then goto wquit

'init local camera transform
matinit(localcamtrans())
matscale(localcamtrans(),0)
matmove(localcamtrans(),0,0,0)

'set camera transform from local transform
set(worldhandle,camtranshandle,localcamtrans())

'init local object transform
matscale(localobjtrans(),65536*400)
objectz=500*65536
fade=0

moreplease:
DO

'Add a letter if a key is pressed
if inkey(win,k$)=win then gosub addletter

gosub animate

'Do resizing
 if testresize()=win then
  resize(win,32,32,0,1024,1024,0)
  gosub resizewin
 endif

'generate frame
 image(worldhandle,camhandle,imagebuffer(),width,height,flength,iflags)
 blit(win,imagebuffer(),clipx1,clipy1)
 update(win)

loop until inmouse(0,mx,my,button)<>0
if hitgob(win,mx,my,1,1,dum,dum,dum,dum)=closehandle then goto wquit
if numberofletters=0 then goto moreplease

'Wait for all letters to stop before they can fly
if lettervars(numberofletters-1).dz <> 0 then goto moreplease

for x=0 to numberofletters-1
 lettervars(x).dz=initz/100
next

setup=0
goto moreplease

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

wquit:
closeworld(worldhandle)
quit:
end

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
resizewin:
clrgob(win,0)
cuigadgets(win,7,"Flying Logo",dum,dum,closehandle,dum,dum)
getclip(win,clipx1,clipy1,clipz1,clipx2,clipy2,clipz2)
width=clipx2-clipx1:height=clipy2-clipy1
dim imagebuffer(width-1,height-1) AS BYTE
return

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Animate:

if numberofletters>0 then

 for x=0 to numberofletters-1

 'Stop letter if in setup and letter has reached initz
 if setup then
  if lettervars(x).zpos >=initz then
   lettervars(x).dz=0
   lettervars(x).xrot=0
   lettervars(x).yrot=0
   lettervars(x).zrot=0
   lettervars(x).dxrot=0
   lettervars(x).dyrot=0
   lettervars(x).dzrot=0
  endif

 else

 'Not setting up, flip dz & either create new drot or just flip the values
  if lettervars(x).dz >0 then
   if lettervars(x).zpos >initz then
    lettervars(x).dz=0-lettervars(x).dz
    lettervars(x).dxrot=rnd(2000)-1000
    lettervars(x).dyrot=rnd(2000)-1000
    lettervars(x).dzrot=rnd(2000)-1000
   endif
  else
   if lettervars(x).zpos <0-400 then
    lettervars(x).dz=0-lettervars(x).dz
    lettervars(x).dxrot=0-lettervars(x).dxrot
    lettervars(x).dyrot=0-lettervars(x).dyrot
    lettervars(x).dzrot=0-lettervars(x).dzrot
   endif
  endif


 endif

 'Move letter
 lettervars(x).xpos=lettervars(x).xpos+lettervars(x).dx
 lettervars(x).ypos=lettervars(x).ypos+lettervars(x).dy
 lettervars(x).zpos=lettervars(x).zpos+lettervars(x).dz

 lettervars(x).xrot=lettervars(x).xrot+lettervars(x).dxrot
 lettervars(x).yrot=lettervars(x).yrot+lettervars(x).dyrot
 lettervars(x).zrot=lettervars(x).zrot+lettervars(x).dzrot

 'rotate object transform
 matinit(localobjtrans())
 matrotx(localobjtrans(),lettervars(x).xrot)
 matroty(localobjtrans(),lettervars(x).yrot)
 matrotz(localobjtrans(),lettervars(x).zrot)
 matmove(localobjtrans(),lettervars(x).xpos,lettervars(x).ypos,lettervars(x).zpos)
 set(worldhandle,lettervars(x).transhandle,localobjtrans())

 next

endif
return

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Routine to add a letter to the scene
addletter:

 k=asc(k$)

 if k=10 then currentx=startx:currenty=currenty-gap:goto nodef
 if k<>32 then

 if k>96 then k=k-32
 k=k-65
 if k>25 then goto nodef
 if k<0 then goto nodef
 offset=geometry(k)

 if numberofletters>maxletters then goto nodef

 'open object transform
 x=opentransform(worldhandle)
 if x=0 then goto quit
 lettervars(numberofletters).transhandle =x

 'open geometry
 geohandle=opengeometry(worldhandle,geometry()+offset)
 if geohandle=0 then goto wquit

 'open object
 objecthandle=openobject(worldhandle,geohandle,x,0,0)
 if objecthandle=0 then goto quit

 'Init rest of vars
 lettervars(numberofletters).xpos=currentx
 lettervars(numberofletters).ypos=currenty
 lettervars(numberofletters).zpos=0

 lettervars(numberofletters).xrot=250*50
 lettervars(numberofletters).yrot=0-500*50
 lettervars(numberofletters).zrot=750*50
 lettervars(numberofletters).dxrot=0-250
 lettervars(numberofletters).dyrot=500
 lettervars(numberofletters).dzrot=0-750

 lettervars(numberofletters).dx=0
 lettervars(numberofletters).dy=0
 lettervars(numberofletters).dz=initz/50

 numberofletters=numberofletters+1
 endif
 currentx=currentx+gap
nodef:
return
