'compiler arraychecks

include 'basic/include/all.def'

defint optwin,win1,k,flag,dum
defint start,len,width8,height8,width24,height24
defint mode,data,index,x,y,datalo,datahi
defstr pic24$,pic8$,k$,filename$

TYPE rgb
r AS UBYTE
g AS UBYTE
b AS UBYTE
END TYPE

dim pixtga(1) AS UBYTE
dim palette(1) AS rgb
dim pixels8(1,1) AS UBYTE
dim pixels24(1,1) AS rgb

optwin=openwindow(300,100):if optwin=0 then goto quit
cuigadgets(optwin,3,"TBMutil V1.0 Text Window",dum,dum,dum,dum,dum)
cls(optwin)

mainmenu:
update(optwin)
k=menu("TBMutil Menu.|Load|Save|View|Convert|Quit")
if k>4 then goto quit
if k<1 then goto quit
on k gosub loadmenu,savemenu,viewmenu,convertmenu
goto mainmenu

loadmenu:
k=menu("Load Menu.|Load 8 bit TBM|Load 8 bit TGA|Load 24 bit TBM|Load 24 bit TGA")
if k>4 then return
if k<1 then return
on k gosub loadtbm8,loadtga8,loadtbm24,loadtga24
if flag=0 then
 print #optwin,"Error loading."
else
 print #optwin,"Loaded ";filename$
endif
return

savemenu:
k=menu("Save Menu.|Save 8 bit TBM|Save 8 bit TGA|Save 24 bit TBM|Save 24 bit TGA")
if k>4 then return
if k<1 then return
print #optwin,"Saving....":update(optwin)
on k gosub savetbm8,savetga8,savetbm24,savetga24
if flag=0 then
 print #optwin,"Error saving."
else
 print #optwin,"Saved ";filename$
endif
return

viewmenu:
k=menu("View Menu.|View 8 bit|View 24 bit")
if k<1 then k=5
if k>2 then
 if win1<>0 then closewindow(win1):win1=0
 return
else
 on k gosub view8,view24
 goto viewmenu
endif

convertmenu:
print #optwin,"No options for convert menu."
return


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
option:
update(optwin)
waitkey(0,k$)
k=asc(k$) AND 15
if k=0 then k=5
if k>5 then k=5
return

''''''''''''''' Graphics Subroutines '''''''''''''''''
'Load 8 bit tbm into pixels8 (2d array)
'also set set start, len, width8, height8
loadtbm8:
flag=0
if browser("bitmaps/*.tbm",filename$)<>0 then
 flag=loadtbm(filename$,varptr(pixels8()),varptr(palette()),start,len,width8,height8,mode)
 if flag<>0 then pic8$=filename$
endif

return

''''''''''''''''''''''''''''''''''''''''''''''''''''''
loadtbm24:

'Load 24 bit tbm into pixels24 (2d array)
'also set width24, height24
flag=0
if browser("rgbmaps/*.tbm",filename$)<>0 then
 flag=loadtbm(filename$,varptr(pixels24()),varptr(palette()),x,x,width24,height24,mode)
 if flag<>0 then pic24$=filename$
endif

return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
loadtga8:
'Load 8 bit tga into pixels8 (2d array)
'also set set start, len, width8, height8
flag=0
if browser("bitmaps/*.tga",filename$)<>0 then
 flag=loadarray(filename$,varptr(pixtga()))
 if flag<1 then goto error

 if pixtga(2)<>1 then goto badtga : rem not uncompressed 8 bit tga
 if pixtga(7)<>24 then goto badtga : rem not 24 bit palette
 if pixtga(16)<>8 then goto badtga : rem not 8 bit pixels

 start=pixtga(3)+pixtga(4)*256
 len=pixtga(5)+pixtga(6)*256
 width8=pixtga(12)+pixtga(13)*256
 height8=pixtga(14)+pixtga(15)*256
 index=18+pixtga(0)

 dim palette(len) AS rgb:rem copy palette
 for x=0 to len-1
  palette(x).r=pixtga(index+2)
  palette(x).g=pixtga(index+1)
  palette(x).b=pixtga(index)
 index=index+3
 next

 DIM pixels8(width8-1,height8-1) AS UBYTE

'copy data
 for y=0 to height8-1
 for x=0 to width8-1
 pixels8(x,y)=pixtga(index)
 index=index+1
 next:next

 erase(varptr(pixtga())):rem  ** free targa mem **
 pic8$=filename$

endif

return

badtga:
print #optwin,"Unsupported file type."
error:
flag=0
return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
loadtga24:
'Load 24 bit tga into pixels24 (2d array)
'also set width24, height24
flag=0
if browser("rgbmaps/*.tga",filename$)<>0 then
 flag=loadarray(filename$,varptr(pixtga()))
 if flag<1 then goto error

 if pixtga(2)<>2 then goto badtga :' not uncompressed 24 bit tga
 if pixtga(16)<>24 then goto badtga :' not 24 bit pixels

 width24=pixtga(12)+pixtga(13)*256
 height24=pixtga(14)+pixtga(15)*256
 index=18+pixtga(0)

 DIM pixels24(width24-1,height24-1) AS rgb

'copy data
 for y=0 to height24-1
 for x=0 to width24-1
 pixels24(x,y).b = pixtga(index)
 pixels24(x,y).g = pixtga(index+1)
 pixels24(x,y).r = pixtga(index+2)
 index=index+3
 next:next

 erase(varptr(pixtga())):rem  ** free targa mem **
 pic24$=filename$

endif
return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
savetbm8:
if width8=0 then
 print #optwin,"No 8 bit picture loaded."
 flag=0
 return
endif
filename$=pic8$
gosub maketbm
flag=savetbm(filename$,varptr(pixels8()),varptr(palette()),start,len)
return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
savetbm24:
if width24=0 then
 print #optwin,"No 24 bit picture loaded."
 flag=0
 return
endif
filename$=pic24$
gosub maketbm
flag=savetbm(filename$,varptr(pixels24()),0,0,0)
return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
savetga24:
if width24=0 then
 print #optwin,"No 24 bit picture loaded."
 flag=0
 return
endif

filename$=pic24$
gosub maketga

DIM pixtga(18+width24*height24*3) AS UBYTE

pixtga(0)=0:rem ID field len
pixtga(1)=0:rem Cmap type
pixtga(2)=2:rem Image type

pixtga(3)=0:pixtga(4)=0:rem Cmap origin
pixtga(5)=0:pixtga(6)=0:rem Cmap len
pixtga(7)=0:rem Bits in col field

pixtga(8)=0:pixtga(9)=0:rem X origin
data=height24:gosub lohi
pixtga(10)=datalo:pixtga(11)=datahi:rem Y origin
pixtga(14)=datalo:pixtga(15)=datahi:rem height
data=width24:gosub lohi
pixtga(12)=datalo:pixtga(13)=datahi:rem width
pixtga(16)=24:rem image pixel size
pixtga(17)=32:rem Image descriptor byte

'None of the progs I tried could read a pal not stored at zero so I'll pad.
index=18
'copy data
for y=0 to height24-1
for x=0 to width24-1
pixtga(index)=pixels24(x,y).b
pixtga(index+1)=pixels24(x,y).g
pixtga(index+2)=pixels24(x,y).r
index=index+3
next:next

flag=savearray(filename$,varptr(pixtga()))
erase(varptr(pixtga())):rem  ** free targa mem **
return
''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Save 8 bit targa (uncompresseed)
savetga8:
if width8=0 then
 print #optwin,"No 8 bit picture loaded."
 flag=0
 return
endif

filename$=pic8$
gosub maketga

DIM pixtga(18+(len+start)*3+width8*height8) AS BYTE

pixtga(0)=0:rem ID field len
pixtga(1)=1:rem Cmap type
pixtga(2)=1:rem Image type

pixtga(3)=0:pixtga(4)=0:rem Cmap origin
data=len+start:gosub lohi
pixtga(5)=datalo:pixtga(6)=datahi:rem Cmap len
pixtga(7)=24:rem Bits in col field

pixtga(8)=0:pixtga(9)=0:rem X origin
data=height8:gosub lohi
pixtga(10)=datalo:pixtga(11)=datahi:rem Y origin
pixtga(14)=datalo:pixtga(15)=datahi:rem height
data=width8:gosub lohi
pixtga(12)=datalo:pixtga(13)=datahi:rem width
pixtga(16)=8:rem image pixel size
pixtga(17)=32:rem Image descriptor byte

'copy pal
'None of the progs I tried could read a pal not stored at zero so I'll pad.
index=18
for x=0 to (start*3)-1
pixtga(index)=0
index=index+1
next
for x=0 to len-1
pixtga(index)=palette(x).b
pixtga(index+1)=palette(x).g
pixtga(index+2)=palette(x).r
index=index+3
next

'copy data
for y=0 to height8-1
for x=0 to width8-1
pixtga(index)=pixels8(x,y)
index=index+1
next:next

flag=savearray(filename$,varptr(pixtga()))
erase(varptr(pixtga())):rem  ** free targa mem **
return
''''''''''''''''''''''''''''''''''''''''''''''''''''
view8:
if width8=0 then
 print #optwin,"No 8 bit picture loaded."
 flag=0
 return
endif

if win1=0 then
 win1=openwindow(width8+8,height8+8):if win1=0 then return
 cuiborder(win1,0,0,width8+8,height8+8,4)
 if start>0-1 then setpal(win1,palette(),start,len)
 blit(win1,pixels8(),4,4):update(win1)
endif
return

'''''''''''''''''''''''''''''''''''''''''''''''''''''
view24:
if width24=0 then
 print #optwin,"No 24 bit picture loaded."
 flag=0
 return
endif

if win1=0 then
 win1=openwindow(width24+8,height24+8):if win1=0 then return
 cuiborder(win1,0,0,width24+8,height24+8,4)
 for y=0 to height24-1
  for x=0 to width24-1
   data=rgb666(pixels24(x,y).r,pixels24(x,y).g,pixels24(x,y).b)
   plot(win1,x+4,y+4,data)
  next
  update(win1)
 next
endif
return

''''''''''''''''''''''''''''''''''''''''''''''''''''
'Convert data to 16 bit datalo,datahi
lohi:
datalo=data and 255
datahi=(data/256) and 255
return

'''''''''''''''''''''''''''''''''''''''''''''''''''''

quit:
end

'''''''''''''''''''''''''''''''''''''''''''''''''''''
'Turn filename$ into .TBM
maketbm:
 asmon
 cpy [r3+filename$],r0
 l1:
 inc r0
 cpy.b [r0],r8
 cmp '.',r8
 bne l1
 cpy.b 'b',[r0+2]
 cpy.b 'm',[r0+3]
 asmoff
return
'''''''''''''''''''''''''''''''''''''''''''''''''''''
'Turn filename$ into .TGA
maketga:
 asmon
 cpy [r3+filename$],r0
 l2:
 inc r0
 cpy.b [r0],r8
 cmp '.',r8
 bne l2
 cpy.b 'g',[r0+2]
 cpy.b 'a',[r0+3]
 asmoff
return
