.include 'tao.inc'

CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2
CT_TITLE=CT_USER3
CT_BORDER=CT_USER4
CT_BORDERSIZE=CT_USER4+4
CT_BUTTONSIZE=CT_USER4+8

node alphaproc,CONTROLTP,0,TEMPLATE|GUI
	control 0,1024,MOUSETP|RESIZETP,0,0,0,0,0,0
	component almtd2-alphaproc
	compend
	tstring almtd2,'DEMO/ALPHA'
nodeend alphaproc

node tl_alphablat,TOOLTP,VP,TEMPLATE
	tool 'DEMO/ALPHA'
	;bounce letters in window
	;r6=control object pointer

	;get cui info
	qcall GOB/CUIINFO
	cpy [r1+CUI_BORDERSIZE],r8
	cpy [r1+CUI_BUTTONSIZE],r9
	cpy r8,[r6+CT_BORDERSIZE]
	cpy r9,[r6+CT_BUTTONSIZE]

	;open local window
	cpy CENTER,r10
	cpy 200,r11
	add r8,r8
	add r8,r11
	cpy 200,r12
	add r8,r12
	add r9,r12
	qcall CLASS/LWINDOW
	if r0=0
		ret
	endif
	cpy r0,[r6+CT_WINDOW]

	;set clip area, close button and title
	gos setclip

	;random number of letters
	cpy 50,r14
	qcall LIB/Q_RANDOM
	add 50,r15
	forsp r15
		;add letter gobs to gadget list
		cpy [r6+CT_WINDOW],r0
		lea letter,r1
		lcall r0,WN_ADDGOB
		breakif r1=0

		;set random x,y inside window
		qcall GOB/GB_RANDOM
		cpy r8,[r1+GB_X]
		cpy r9,[r1+GB_Y]

		;set random char
		cpy 64,r14
		qcall LIB/Q_RANDOM
		add 'A',r15
		cpy r15,[r1+ND_NUMBER]

		;set random colour
		cpy 15,r14
		qcall LIB/Q_RANDOM
		inc r15
		cpy r15,[r1+ND_REFS]
	nextsp

	loop
		;check for any mail
		testmymail MOUSETP|RESIZETP
		if r8=RESIZETP
			;resize window with limits on size
			cpy [r6+CT_WINDOW],r0
			cpy [r6+CT_BORDERSIZE],r8
			cpy [r6+CT_BUTTONSIZE],r9
			add r8,r8
			lea [r8+400],r11
			lea [r8+r9+400],r12
			lea [r8+r9+128],r9
			add 128,r8
			clr r10
			clr r13
			lcall r0,WN_RESIZE
			if r8!=0
				cpy [r6+CT_BORDER],r1
				lcall r0,WN_CLRGOB
				cpy [r6+CT_TITLE],r1
				lcall r0,WN_CLRGOB
				cpy [r6+CT_CBUTTON],r1
				lcall r0,WN_CLRGOB
				gos setclip
			endif
		elseif r8=MOUSETP
			;click from mouse
			readmymail r8
			cpy [r1+MO_RX],r13
			cpy [r1+MO_RY],r14
			cpy [r1+MO_BUTTON],r15
			freenode r0

			;quit if right hand button
			breakif r15=MB_RIGHT

			;quit if left click on close button
			if r15=MB_LEFT
				cpy r13,r8
				cpy r14,r9
				cpy 1,r11
				cpy 1,r12
				cpy [r6+CT_WINDOW],r0
				cpy r13,[r0+BM_XOFFSET]
				cpy r14,[r0+BM_YOFFSET]
				lcall r0,WN_HITGOB
				breakif r1=[r6+CT_CBUTTON]
			endif
		else
			;update window and letters
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_CLPCLR
			lcall r0,WN_UPDATE
		endif
	endloop

	;close window and exit
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_CLOSE
	ret   

;setup clip region, center of attraction, title and close button
setclip:
	lea title,r1
	cpy GA_TITLE|GA_CLOSE|GA_BORDER,r8
	qcall GOB/CUIGADGETS
	cpy r10,[r6+CT_CBUTTON]
	cpy r9,[r6+CT_TITLE]
	cpy r8,[r6+CT_BORDER]
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_GETCLIP
	sub r8,r11
	sub r9,r12
	lsr 1,r11
	lsr 1,r12
	add r11,r8
	add r12,r9
	cpy r8,[r0+BM_XOFFSET]
	cpy r9,[r0+BM_YOFFSET]
	ret

	string title,'Alpha'

	node letter,GOBTP,0,TEMPLATE
		gob	NULL,8,8,NULL,0,0,0,0
		vectors	ltmhd1-letter,0,0,0,0,14,14
		component	ltmhd2-letter
		component	ltmhd3-letter
		compend
		tstring	ltmhd1,'GOB/GB_VECTOR'
		tstring	ltmhd2,'DEMO/ATTRACT'
		tstring	ltmhd3,'DEMO/LETPLOT'
	nodeend letter

	toolend tl_alphablat
nodeend tl_alphablat

node tl_attract,TOOLTP,VP,TEMPLATE
	tool 'DEMO/ATTRACT'
	;attract graphic object to center of gravity
	;r6=graphic object pointer

	cpy [r6+GB_PARENT],r0
	cpy [r6+GB_X],r8
	cpy [r6+GB_Y],r9
	lea [r6+ND_SIZE],r1
	add [r1+CP_VEC],r1
	cpy 1,[r1+MV_XACC]
	if r8>[r0+BM_XOFFSET]
		cpy -1,[r1+MV_XACC]
	endif
	cpy 1,[r1+MV_YACC]
	if r9>[r0+BM_YOFFSET]
		cpy -1,[r1+MV_YACC]
	endif
	ret

	toolend tl_attract
nodeend tl_attract

node tl_letplot,TOOLTP,VP,TEMPLATE
	tool 'DEMO/LETPLOT'
	;plot letter in window
	;r6=graphic object pointer

	cpy [r6+GB_PARENT],r0
	cpy [r6+GB_X],r8
	cpy [r6+GB_Y],r9
	cpy [r6+ND_REFS],r10
	cpy [r6+ND_NUMBER],r11
	qcall GUI/BL_CHAR
	ret

	toolend tl_letplot
nodeend tl_letplot

.end
