.include 'tao.inc'

CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2
CT_TITLE=CT_USER3
CT_BORDER=CT_USER4
CT_BORDERSIZE=CT_USER4+4
CT_BUTTONSIZE=CT_USER4+8

node bongproc,CONTROLTP,0,TEMPLATE|GUI
	control 0,1024,RESIZETP|MOUSETP,0,0,0,0,0,0
	component lnmthd2-bongproc
	compend
	tstring lnmthd2,'DEMO/BOING'
nodeend bongproc

node tl_bongblat,TOOLTP,VP,TEMPLATE
	tool 'DEMO/BOING'
	;bounce balls in window
	;r6=control object pointer

	;get cui info
	qcall GOB/CUIINFO
	cpy [r1+CUI_BORDERSIZE],r8
	cpy [r1+CUI_BUTTONSIZE],r9
	cpy r8,[r6+CT_BORDERSIZE]
	cpy r9,[r6+CT_BUTTONSIZE]

	;open local window
	cpy CENTER,r10
	cpy 200,r11
	add r8,r8
	add r8,r11
	cpy 200,r12
	add r8,r12
	add r9,r12
	qcall CLASS/LWINDOW
	if r0=0
		ret
	endif
	cpy r0,[r6+CT_WINDOW]

	;set clip area, close button and title
	gos setclip

	;random number of points
	cpy 10,r14
	qcall LIB/Q_RANDOM
	add 40,r15
	forsp r15
		;add ball gobs to gadget list
		cpy [r6+CT_WINDOW],r0
		lea lpoint,r1
		lcall r0,WN_ADDGOB
		breakif r1=0

		;set random x,y inside window
		qcall GOB/GB_RANDOM
		cpy r8,[r1+GB_X]
		cpy r9,[r1+GB_Y]

		;set random colour
		cpy 14,r14
		qcall LIB/Q_RANDOM
		add 2,r15
		cpy r15,[r1+ND_NUMBER]

		;set random velocity, exclude non moveing balls
		add ND_SIZE,r1
		add [r1+CP_VEC],r1
		repeat
			cpy 9,r14
			qcall LIB/Q_RANDOM
			sub 4,r15
			cpy r15,r8
			cpy 9,r14
			qcall LIB/Q_RANDOM
			sub 4,r15
			cpy r15,r9
			lea [r8+r9],r15
		until r15!=0
		cpy r8,[r1+MV_XVEL]
		cpy r9,[r1+MV_YVEL]
	nextsp

	loop
		;check for any mail
		testmymail MOUSETP|RESIZETP
		if r8=RESIZETP
			;resize window with limits on size
			cpy [r6+CT_WINDOW],r0
			cpy [r6+CT_BORDERSIZE],r8
			cpy [r6+CT_BUTTONSIZE],r9
			add r8,r8
			lea [r8+400],r11
			lea [r8+r9+400],r12
			lea [r8+r9+128],r9
			add 128,r8
			clr r10
			clr r13
			lcall r0,WN_RESIZE
			if r8!=0
				cpy [r6+CT_BORDER],r1
				lcall r0,WN_CLRGOB
				cpy [r6+CT_TITLE],r1
				lcall r0,WN_CLRGOB
				cpy [r6+CT_CBUTTON],r1
				lcall r0,WN_CLRGOB
				gos setclip
			endif
		elseif r8=MOUSETP
			;click from mouse
			readmymail r8
			cpy [r1+MO_RX],r13
			cpy [r1+MO_RY],r14
			cpy [r1+MO_BUTTON],r15
			freenode r0

			;quit if right hand button
			breakif r15=MB_RIGHT

			;quit if left click on close button
			if r15=MB_LEFT
				cpy r13,r8
				cpy r14,r9
				cpy 1,r11
				cpy 1,r12
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_HITGOB
				breakif r1=[r6+CT_CBUTTON]
			endif
		else
			;update window and balls
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_CLPCLR
			lcall r0,WN_UPDATE
		endif
	endloop

	;close window and exit
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_CLOSE
	ret   

;setup clip region, title and close button
setclip:
	lea title,r1
	cpy GA_TITLE|GA_CLOSE|GA_BORDER,r8
	qcall GOB/CUIGADGETS
	cpy r10,[r6+CT_CBUTTON]
	cpy r9,[r6+CT_TITLE]
	cpy r8,[r6+CT_BORDER]
	ret

	string title,'Boing'

	node lpoint,GOBTP,0,TEMPLATE
		gob	NULL,1,1,NULL,0,0,0,0
		vectors	lpmthd1-lpoint,0,0,0,0,4,4
		component	lpmthd2-lpoint
		component	lpmthd3-lpoint
		compend
		tstring	lpmthd1,'GOB/GB_VECTOR'
		tstring	lpmthd2,'DEMO/BOUNCE'
		tstring	lpmthd3,'DEMO/DRAWBALL'
	nodeend lpoint

	toolend tl_bongblat
nodeend tl_bongblat

node tl_bounce,TOOLTP,VP,TEMPLATE
	tool 'DEMO/BOUNCE'
	;bounce point in clip area
	;r6=gob object pointer

	cpy [r6+GB_PARENT],r0
	lea [r6+ND_SIZE],r1
	add [r1+CP_VEC],r1
	cpy [r0+BM_CLIPX],r8
	if r8>[r6+GB_X]
		cpy r8,[r6+GB_X]
		neg [r1+MV_XVEL]
	endif
	cpy [r0+BM_CLIPX1],r8
	if r8<[r6+GB_X]
		dec r8
		cpy r8,[r6+GB_X]
		neg [r1+MV_XVEL]
	endif
	cpy [r0+BM_CLIPY],r8
	if r8>[r6+GB_Y]
		cpy r8,[r6+GB_Y]
		neg [r1+MV_YVEL]
	endif
	cpy [r0+BM_CLIPY1],r8
	if r8<[r6+GB_Y]
		dec r8
		cpy r8,[r6+GB_Y]
		neg [r1+MV_YVEL]
	endif
	ret

	toolend tl_bounce
nodeend tl_bounce

node tl_joinup,TOOLTP,VP,TEMPLATE
	tool 'DEMO/DRAWBALL'
	;r6=gob object pointer

	cpy [r6+GB_PARENT],r0
	cpy [r6+ND_NUMBER],r10
	cpy [r6+GB_X],r8
	cpy [r6+GB_Y],r9
	cpy 10,r11
	qcall GUI/BL_CIRCLE
	ret

	toolend tl_joinup
nodeend tl_joinup

.end
