.include 'tao.inc'

CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2
CT_BORDERSIZE=CT_USER3
CT_BUTTONSIZE=CT_USER4

node boxproc,CONTROLTP,0,TEMPLATE
	control 0,1024,RESIZETP|MOUSETP,0,0,0,0
	component bxmtd1-boxproc
	compend
	tstring bxmtd1,'DEMO/BOXES'
nodeend boxproc

node tl_boxblat,TOOLTP,VP,TEMPLATE
	tool 'DEMO/BOXES'
	;draw random filled boxes
	;r6=control object pointer

	;get cui info
	qcall GOB/CUIINFO
	cpy [r1+CUI_BORDERSIZE],r8
	cpy [r1+CUI_BUTTONSIZE],r9
	cpy r8,[r6+CT_BORDERSIZE]
	cpy r9,[r6+CT_BUTTONSIZE]

	;open remote window
	cpy CENTER,r10
	cpy 200,r11
	add r8,r8
	add r8,r11
	cpy 200,r12
	add r8,r12
	add r9,r12
	qcall CLASS/RWINDOW
	if r0=0
		ret
	endif
	cpy r0,[r6+CT_WINDOW]

	;set clip area, close button and title
	gos setclip
	lcall r0,WN_UPDATE

	loop
		;check for any mail
		testmymail MOUSETP|RESIZETP
		if r8=RESIZETP
			;resize window with limits on size
			cpy [r6+CT_WINDOW],r0
			cpy [r6+CT_BORDERSIZE],r8
			cpy [r6+CT_BUTTONSIZE],r9
			add r8,r8
			lea [r8+400],r11
			lea [r8+r9+400],r12
			lea [r8+r9+128],r9
			add 128,r8
			clr r10
			clr r13
			lcall r0,WN_RESIZE
			if r8!=0
				clr r1
				lcall r0,WN_CLRGOB
				gos setclip
				lcall r0,WN_UPDATE
			endif
		elseif r8=MOUSETP
			;click from mouse
			readmymail r8
			cpy [r1+MO_RX],r13
			cpy [r1+MO_RY],r14
			cpy [r1+MO_BUTTON],r15
			freenode r0

			;quit if right hand button
			breakif r15=MB_RIGHT

			;quit if left click on close button
			if r15=MB_LEFT
				cpy r13,r8
				cpy r14,r9
				cpy 1,r11
				cpy 1,r12
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_HITGOB
				breakif r1=[r6+CT_CBUTTON]
			endif
		else
			;draw random box, and update window area
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_GETCLIP
			pshm r9,r12
			sub r8,r11
			cpy r11,r14
			qcall LIB/Q_RANDOM
			add [r6+CT_BORDERSIZE],r15
			cpy r15,r8
			qcall LIB/Q_RANDOM
			add [r6+CT_BORDERSIZE],r15
			cpy r15,r11
			popm r12,r9
			sub r9,r12
			cpy r12,r14
			qcall LIB/Q_RANDOM
			add [r6+CT_BORDERSIZE],r15
			add [r6+CT_BUTTONSIZE],r15
			cpy r15,r9
			qcall LIB/Q_RANDOM
			add [r6+CT_BORDERSIZE],r15
			add [r6+CT_BUTTONSIZE],r15
			cpy r15,r12
			sub r8,r11
			if r11<0
				add r11,r8
				neg r11
			endif
			sub r9,r12
			if r12<0
				add r12,r9
				neg r12
			endif
			inc r11
			inc r12
			cpy 255,r14
			qcall LIB/Q_RANDOM
			inc r15
			cpy r15,r10
			pshm r8,r9,r11,r12
			lcall r0,WN_FBOX
			popm r12,r11,r9,r8
			lcall r0,WN_FUPDATE
		endif
	endloop

	;close window and exit
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_CLOSE
	ret

;setup clip region, title and close button
setclip:
	lea title,r1
	cpy GA_TITLE|GA_CLOSE|GA_BORDER,r8
	qcall GOB/CUIGADGETS
	cpy r10,[r6+CT_CBUTTON]
	ret

	string title,'Boxes'

	toolend tl_boxblat
nodeend tl_boxblat

end
