.include 'tao.inc'
.include 'lib/globals.inc'
.include 'lib/time.inc'

CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2
CT_BUTTONSIZE=CT_USER3
CT_BORDERSIZE=CT_USER4

node timeproc,CONTROLTP,0,TEMPLATE
	control 0,1024,MOUSETP,0,0,0,0
	component timeproc,'DESK/CLOCK'
	controlend timeproc
nodeend timeproc

node tl_time,TOOLTP,VP,TEMPLATE
	tool 'DESK/CLOCK'
	;inputs
	;r6=control object pointer

	;want to use LIB tools
	openlib

	;get cui info
	qcall GOB/CUIINFO
	cpy [r1+CUI_BORDERSIZE],r8
	cpy [r1+CUI_BUTTONSIZE],r9
	cpy r8,[r6+CT_BORDERSIZE]
	cpy r9,[r6+CT_BUTTONSIZE]

	;open remote window
	cpy CENTER,r10
	cpy 21*8,r11
	add r8,r8
	add r8,r11
	cpy r9,r12
	add r8,r12
	add 8,r12
	qcall CLASS/RWINDOW
	if r0!=0
		;save window handle
		cpy r0,[r6+CT_WINDOW]

		;set clip region, title and close button
		lea title,r1
		cpy GA_BORDER|GA_TITLE|GA_CLOSE,r8
		qcall GOB/CUIGADGETS
		cpy r10,[r6+CT_CBUTTON]
	
		;time & string on stack
		allocstruct 100,r0

		;read server time once
		qcall LIB/TIME

		;read local time & store
		tao GETTIME
		cpy r8,[r7+4]

		;loop every 1 second
		loop
			cpy r7,r0
			add 15625,[r7+4]
			inc [r0]
			qcall LIB/GMTIME

			;build up time string
			cpy r0,r2
			lea [r7+8],r0
			lea format,r1
			cpy 50,r8
			qcall LIB/STRFTIME

			;print to window
			cpy r0,r1
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_PRINT
			lcall r0,WN_UPDATE

			;read first mouse message got durring last second
			testmymail -1
			if r8=MOUSETP
				;click from mouse
				readmymail r8
				cpy [r1+MO_RX],r13
				cpy [r1+MO_RY],r14
				cpy [r1+MO_BUTTON],r15
				freenode r0

				;quit if right hand button
				breakif r15=MB_RIGHT

				;quit if left click on close button
				if r15=MB_LEFT
					cpy r13,r8
					cpy r14,r9
					cpy 1,r11
					cpy 1,r12
					cpy [r6+CT_WINDOW],r0
					lcall r0,WN_HITGOB
					breakif r1=[r6+CT_CBUTTON]
				endif
			endif

			;flush all other messages
			loop
				testmymail -1
				breakif r8=0
				readmymail r8
				freenode r0
			endloop

			;sleep for rest of second
			tao GETTIME
			sub [r7+4],r8
			neg r8
			tao DELAY
		endloop
 		;tidy string from stack
 		freestruct 100

 		;close window
		cpy [r6+CT_WINDOW],r0
		lcall r0,WN_CLOSE
	endif
	;clean up after using LIB tools
	closelib
	ret

format:	dc.b 27,'H%a %d/%m/%y %H:%M:%S',0

	string title,'Clock'

	toolend tl_time
nodeend tl_time

.end
