.include 'tao.inc'
.include 'lib/globals.inc'

CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2
CT_VARS=CT_USER3
CT_VARSSIZE=CT_USER4
CT_IOPS=CT_USER4+4
CT_LOPS=CT_USER4+8
CT_FOPS=CT_USER4+12
CT_DOPS=CT_USER4+16
CT_QUIT=CT_USER4+20
CT_CHIPS=CT_USER4+24
CT_BUTTONSIZE=CT_USER4+28
CT_BORDERSIZE=CT_USER4+32

node speed,CONTROLTP,0,TEMPLATE
	control	0,1024,DATATP|MOUSETP,0,0,0,0,0,0,0,0,0,0,0,0
	component speed,'DESK/NETSPEED'
	controlend speed
nodeend speed

node tl_speedit,TOOLTP,VP,TEMPLATE
	tool 'DESK/NETSPEED'
	;inputs
	;r6=control object pointer

	;alloc child ID array, save number of chips
	tao NETINFO
	cpy r10,[r6+CT_CHIPS]
	mul 8,r10
	allocmem r10
	if r8!=0
		;save vars details
		cpy r0,[r6+CT_VARS]
		cpy r8,[r6+CT_VARSSIZE]

		;get cui info
		qcall GOB/CUIINFO
		cpy [r1+CUI_BORDERSIZE],r8
		cpy [r1+CUI_BUTTONSIZE],r9
		cpy r8,[r6+CT_BORDERSIZE]
		cpy r9,[r6+CT_BUTTONSIZE]

		;open remote window
		cpy CENTER,r10
		cpy 152,r11
		add r8,r8
		add r8,r11
		cpy r9,r12
		add r8,r12
		add 32,r12
		qcall CLASS/RWINDOW
		if r0!=0
			;save window handle
			cpy r0,[r6+CT_WINDOW]

			;set clip region, title and close button
			lea title,r1
			cpy GA_BORDER|GA_TITLE|GA_CLOSE,r8
			qcall GOB/CUIGADGETS
			cpy r10,[r6+CT_CBUTTON]

			;print info text and update window
			lea mips,r1
			lcall r0,WN_PRINT
			lcall r0,WN_UPDATE

			;open child on each chip
			getmyid r6
			cpy [r6+CT_VARS],r1
			cpy [r6+CT_CHIPS],r10
			clr r11
			lea speedchld,r0
			openglobal r0,r1,r8,r9,r10,r11

			;repeat until quit flag set
			repeat
				;check for network change
				tao NETINFO
				if r10!=[r6+CT_CHIPS]
					cpy r10,r8
					mul 8,r8
					allocmem r8
					if r8!=0
						pshm r0,r8,r10
						;ask each open child to quit
						gos closechildren

						;free old vars
						cpy [r6+CT_VARS],r0
						cpy [r6+CT_VARSSIZE],r8
						freemem r0,r8

						popm r10,r8,r1
						;save new vars details
						cpy r10,[r6+CT_CHIPS]
						cpy r1,[r6+CT_VARS]
						cpy r8,[r6+CT_VARSSIZE]

						;open child on each chip
						getmyid r6
						clr r11
						lea speedchld,r0
						openglobal r0,r1,r8,r9,r10,r11
					endif
				endif

				;reset speed counters
				clr.l [r6+CT_IOPS]
				clr.l [r6+CT_FOPS]

				;ask each active child for speed results
				cpy [r6+CT_VARS],r3
				clr r14
				forsp [r6+CT_CHIPS]
					if [r3]!=0
						;child was opened
						loop
							lea speedmsg,r0
							copynode r0
							breakif r8!=0
							delay 100000/64
						endloop
						cpy.l [r3],r8
						cpy.l r8,[r0+(MG_DTM+8)]
						getmyid r6
						cpy.l r8,[r0+(MG_DTM+0)]
						cpy.l r8,[r0+(MG_DTM+16)]
						sendmail r0
						inc r14
					endif
					add	8,r3
				nextsp

				;wait for results to come back
				forsp r14
					readmymail -1
					if r8=MOUSETP
						;set flag if user quits
						cpy [r1+MO_RX],r13
						cpy [r1+MO_RY],r14
						cpy [r1+MO_BUTTON],r15
						freenode r0

						if r15=MB_RIGHT
							;right hand button
							cpy 1,[r6+CT_QUIT]
						elseif r15=MB_LEFT
							;left click
							cpy r13,r8
							cpy r14,r9
							cpy 1,r11
							cpy 1,r12
							cpy [r6+CT_WINDOW],r0
							lcall r0,WN_HITGOB
							if r1=[r6+CT_CBUTTON]
								cpy 1,[r6+CT_QUIT]
							endif
						endif
						continue
					elseif r8=DATATP
						;returning speed result
						cpy [r1],r8
						cpy [r1+4],r9
						cpy [r1+8],r10
						cpy [r1+12],r11

						;add to totals
						add r8,[r6+CT_IOPS]
						add r9,[r6+CT_LOPS]
						add r10,[r6+CT_FOPS]
						add r11,[r6+CT_DOPS]
						freenode r0
					else
						;alien mail type
						freenode r0
						continue
					endif
				nextsp

				;ascii buffer
				allocstruct 20,r7

				;clear area for numbers
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				cpy 9*8,r11
				cpy 4*8,r12
				cpy [r6+CT_WINDOW],r0
				cpy BLACK,r10
				lcall r0,WN_FBOX

				;print VP IOPS
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				lcall r0,WN_SETCUR
				cpy DGREEN,r8
				cpy -1,r9
				lcall r0,WN_SETATTR
				cpy r7,r0
				cpy [r6+CT_IOPS],r8
				i2l r8
				l2d r8
				div.d 1000000,r8
				cpy 5,r10
				qcall LIB/DTOA
				cpy r0,r1
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_PRINT

				;print VP LOPS
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				add 1*8,r9
				lcall r0,WN_SETCUR
				cpy GREEN,r8
				cpy -1,r9
				lcall r0,WN_SETATTR
				cpy r7,r0
				cpy [r6+CT_LOPS],r8
				i2l r8
				l2d r8
				div.d 1000000,r8
				cpy 5,r10
				qcall LIB/DTOA
				cpy r0,r1
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_PRINT

				;print VP FOPS
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				add 2*8,r9
				lcall r0,WN_SETCUR
				cpy DRED,r8
				cpy -1,r9
				lcall r0,WN_SETATTR
				cpy r7,r0
				cpy [r6+CT_FOPS],r8
				i2l r8
				l2d r8
				div.d 1000000,r8
				cpy 5,r10
				qcall LIB/DTOA
				cpy r0,r1
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_PRINT

				;print VP DOPS
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				add 3*8,r9
				lcall r0,WN_SETCUR
				cpy RED,r8
				cpy -1,r9
				lcall r0,WN_SETATTR
				cpy r7,r0
				cpy [r6+CT_DOPS],r8
				i2l r8
				l2d r8
				div.d 1000000,r8
				cpy 5,r10
				qcall LIB/DTOA
				cpy r0,r1
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_PRINT

				;free ascii buffer
				freestruct 20

				;update numeric region
				cpy [r6+CT_BORDERSIZE],r8
				cpy [r6+CT_BUTTONSIZE],r9
				add r8,r9
				add 10*8,r8
				cpy 9*8,r11
				cpy 4*8,r12
				lcall r0,WN_FUPDATE
			until [r6+CT_QUIT]!=0

			;ask each open child to quit
			gos closechildren

			;close window
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_CLOSE
		endif

		;free child ID vars
		cpy [r6+CT_VARS],r0
		cpy [r6+CT_VARSSIZE],r8
		freemem r0,r8
	endif
	ret

;close all open children
closechildren:
	cpy [r6+CT_VARS],r3
	forsp [r6+CT_CHIPS]
		if [r3]!=0
			loop
				lea quitmsg,r0
				copynode r0
				breakif r8!=0
				delay 100000/64
			endloop
			cpy.l [r3],r8
			cpy.l r8,[r0+(MG_DTM+8)]
			sendmail r0
		endif
		add 8,r3
	nextsp
	ret

	even
mips:
	dc.b 27,'H',27,'b',MAGENTA
	dc.b 'VP MIPS =',10
	dc.b 'VP MLPS =',10
	dc.b 'VP MFPS =',10
	dc.b 'VP MDPS =',0

	string title,'Netspeed'

	msg speedmsg,DATATP
	dc.l 0
	dc.l 0
	dc.l 0
	dtmend speedmsg
	dc.i 0 ;space for VP IOPS
	dc.i 0 ;space for VP LOPS
	dc.i 0 ;space for VP FOPS
	dc.i 0 ;space for VP DOPS
	msgend speedmsg

	msg quitmsg,SYSTEMTP
	dc.l 0
	dc.l 0
	dtmend quitmsg
	msgend quitmsg

	node speedchld,CONTROLTP,0,TEMPLATE
		control 0,1024,DATATP|SYSTEMTP,0,0,0,0
		component speedchld,'DESK/VPSPEED'
		controlend speedchld
	nodeend speedchld

	toolend tl_speedit
nodeend tl_speedit

.end
