.include 'tao.inc'

.ctlprefix 'desk/'

buttonsize=16
CT_WINDOW=CT_USER1
CT_CBUTTON=CT_USER2

node debugproc,CONTROLTP,0,TEMPLATE|GUI
	control 0,1024,REFRESHTP|FUNCTP|MOUSETP,0,0,0,0
	component debugproc,'DESK/TRACE'
	controlend debugproc
nodeend debugproc

node tl_debug,TOOLTP,VP,TEMPLATE
	tool 'DESK/TRACE'
	;inputs
	;r6=control object pointer

	loop
		;read mailbox
		readmymail -1
		if r8=MOUSETP
			cpy [r1+MO_RX],r13
			cpy [r1+MO_RY],r14
			cpy [r1+MO_BUTTON],r15
			freenode r0

			if r15=MB_RIGHT
				;right button click
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_CLOSE
				clr [r6+CT_WINDOW]
			elseif r15=MB_LEFT
				;left click on close button ?
				cpy r13,r8
				cpy r14,r9
				cpy 1,r11
				cpy 1,r12
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_HITGOB
				if r1=[r6+CT_CBUTTON]
					lcall r0,WN_CLOSE
					clr [r6+CT_WINDOW]
				endif
			endif
		elseif r8=FUNCTP
			;is this close device function
			if [r1]=DV_QUIT
				;send back ACK and quit
				sendhead r0
				break
			elseif [r1]=DV_INFO
				cpy r0,r3
				cpy [r0+MG_OFFSET],r10
				lea devinfo,r2
				cpy devinfoe-devinfo,r11
				loop
					lea [r10+r11],r8
					allocmem r8
					breakif r8!=0
					delay 100000/64
				endloop
				cpb r3,r0,r10
				cpy r8,[r0+MG_LENGTH]
				add r0,r10
				cpb r2,r10,r11
				cpy DATATP,[r0+MG_TYPE]
				sendmail r0
				freenode r3
				continue
			elseif [r6+CT_WINDOW]=0
				;must open window
				pshm r0,r1

				cpy 0,r8
				cpy 0,r9
				cpy 0,r10
				cpy 320+8,r11
				cpy 200+8+buttonsize,r12
				qcall CLASS/LWINDOW,VIRTUAL+FIXUP
				if r0=0
					;send back ACK and loop again
					freestruct 4
					pop r0
					sendhead r0
					continue
				endif
				cpy r0,[r6+CT_WINDOW]

				;set clip region, title and close button
				lea title,r1
				cpy GA_BORDER|GA_TITLE|GA_CLOSE,r8
				qcall GOB/CUIGADGETS
				cpy r10,[r6+CT_CBUTTON]

				popm r1,r0
			endif
			psh r0

			;print the message to tty
			cpy [r6+CT_WINDOW],r0
			add 4,r1

			;guarantee that update happens before ack msg
			lcall r0,WN_PRINT
			lcall r0,WN_UPDATE

			;chose colour for next trace line
			cpy [r0+BM_INK],r8
			repeat
				inc r8
				if r8=GREY
					cpy WHITE,r8
				endif
			until r8!=BLUE
			cpy r8,[r0+BM_INK]

			;send head back as ACK
			pop r0
			sendhead r0
		else
			;alien mail or REFRESHTP
			freenode r0

			;update window if present
			cpy [r6+CT_WINDOW],r0
			if r0!=0
				lcall r0,WN_UPDATE
			endif
		endif
	endloop
	;close window if open
	cpy [r6+CT_WINDOW],r0
	if r0!=0
		lcall r0,WN_CLOSE
	endif
	ret

devinfo:
	dc.b 'GUI Trace Device Version 1.0',0
devinfoe:

	string title,'Trace'

	toolend tl_debug
nodeend tl_debug

.end
