.include 'tao'

;5oct93 ARH:
;Added scaling for fast processors - now always gets at least 500 ticks
;(ie 30ms) before believing the result.  If fewer than this, it doubles t
;number of loops being done and tries again.  Because this may lead to
;large numbers (if more than 20000 loops, ie 9 Mips) .L are used for calc.
;5oct93 ARH - Added LEA floats,r2 which appeared to be missing.
;17oct93 ARH - increased to 60ms for test since 6ms still lumpy,
;  ""        - set only 1 cla for integer loop.
;14apr94 ARH - scaled floats for emulation use
;15aug94 ARH - enhanced main mipsloop to more reasonable code
;17aug94 ARH - general tidy & enhanced lopsloop into line with mipsloop
;  "      "    added instruction 15 which appeared missing !

TICKS	=	500

node tl_speedit,TOOLTP,VP,TEMPLATE
	tool 'DESK/VPSPEED'
	;network speed tool
	;inputs
	;r6=control object pointer

waitnxt:
	lea	[r6+CT_MAILBOX],r0
	readmail	r0,DATATP
	tst	r8
	beq	quit	;have got a systemtp so quit

*integers
	lea	ints,r2
	cpy	1000,r15	;starting pt
try_i:	add	r15,r15	;number of loops
	cpy	r15,r14
	gettime
	cpy	r8,r9	;save start timer value

	clr.l r12
mipsloop:
	cpy	r14,r11		;20
	add	r12,r11		;19
	and	r14,r12		;18
	xor	r11,r12		;17
	sub	r14,r12		;16
	cpy	r14,r13		;15
	add	r11,r13		;14
	and	r14,r13		;13
	xor	r11,r13		;12
	or	r14,r12		;11
	sub	r11,r12		;10
	cpy	[r2+0],r11		;9
	add	[r2+4],r12		;8
	sub	[r2+8],r11		;7
	and	[r2+12],r12		;6
	or	[r2+16],r11		;5
	xor	[r2+20],r11		;4
	dec	r14			;3
	tst	r14			;2
	bne	mipsloop		;1

	zap	r11

	gettime
	sub	r9,r8	;time in 64us units
	bool	r8 < TICKS,try_i
	cpy	r15,r10		;number of loops
	clr	r11
	mul.l	15625*20,r10
	clr	r9
	div.l	r8,r10
	cpy	r10,[r1]

*longs
	lea	longs,r2
	cpy	1000,r15	;starting pt
try_l:	add	r15,r15	;number of loops
	cpy	r15,r14
	gettime
	cpy	r8,r9	;save start timer value

lopsloop:
	cpy.l	r12,r10		;20
	add.l	r10,r12		;19
	sub.l	r10,r12		;18
	add.l	r10,r12		;17
	sub.l	r10,r12		;16
	cpy.l	r12,r10		;15
	add.l	r10,r12		;14
	sub.l	r10,r12		;13
	mul.l	r10,r12		;12
	cpy.l	r10,r12		;11
	add.l	[r2],r10		;10
	add.l	[r2+8],r10		;9
	mul.l	[r2+16],r10		;8
	sub.l	[r2+24],r12		;7
	add.l	[r2+32],r10		;6
	cpy.l	[r2+40],r10		;5
	add.l	[r2+48],r12		;4
	dec	r14		;3
	tst	r14		;2
	bne	lopsloop		;1

	gettime
	sub	r9,r8	;time in 64us units
	bool	r8 < TICKS,try_l
	cpy	r15,r10		;number of loops
	clr	r11
	mul.l	15625*20,r10
	clr	r9
	div.l	r8,r10
	cpy	r10,[r1+4]

*float
	lea	floats,r2
	cpy	50,r15	;starting pt
try_f:	add	r15,r15	;number of loops
	cpy	r15,r14
	cpy.f	1.0,r10
	cpy.f	1.5,r11
	gettime
	cpy	r8,r9	;save start timer value

flopsloop:
	add.f	r10,r11		;20
	add.f	r10,r10		;19
	sub.f	r11,r10		;18
	mul.f	r10,r11		;17
	sub.f	r11,r10		;16
	add.f	r10,r11		;15
	sub.f	r11,r10		;14
	mul.f	r11,r10		;13
	add.f	r10,r11		;12
	add.f	r10,r11		;11
	sub.f	[r2+0],r11		;10
	add.f	[r2+4],r10		;9
	sub.f	[r2+8],r10		;8
	mul.f	[r2+12],r11		;7
	sub.f	[r2+16],r10		;6
	add.f	[r2+20],r11		;5
	sub.f	[r2+24],r10		;4
	mul.f	[r2+28],r10		;3
	add.f	[r2+32],r11		;2
	dec	r14
	tst	r14
	bne	flopsloop		;1

	gettime
	sub	r9,r8	;time in 64us units
	bool	r8 < TICKS,try_f
	cpy	r15,r10		;number of loops
	clr	r11
	mul.l	15625*20,r10
	clr	r9
	div.l	r8,r10
	cpy	r10,[r1+8]

*doubles
	lea	doubles,r2
	cpy.d	1.0,r10
	cpy.d	1.5,r12
	cpy	50,r15	;starting pt
try_d:	add	r15,r15	;number of loops
	cpy	r15,r14
	gettime
	cpy	r8,r9	;save start timer value

dfloploop:
	add.d	r10,r12		;20
	add.d	r10,r10		;19
	sub.d	r12,r10		;18
	mul.d	r10,r12		;17
	sub.d	r12,r10		;16
	add.d	r10,r12		;15
	sub.d	r12,r10		;14
	mul.d	r12,r10		;13
	add.d	r10,r12		;12
	add.d	r10,r12		;11
	sub.d	[r2+0],r12		;10
	add.d	[r2+8],r10		;9
	sub.d	[r2+16],r10		;8
	mul.d	[r2+24],r12		;7
	sub.d	[r2+32],r10		;6
	add.d	[r2+40],r12		;5
	sub.d	[r2+48],r10		;4
	mul.d	[r2+56],r10		;3
	add.d	[r2+64],r12		;2
	dec	r14
	tst	r14
	bne	dfloploop		;1

	gettime
	sub	r9,r8	;time in 64us units
	bool	r8 < TICKS,try_d
	cpy	r15,r10		;number of loops
	clr	r11
	mul.l	15625*20,r10
	clr	r9
	div.l	r8,r10
	cpy	r10,[r1+12]

*send result back to sender
	sendmail	r0	;send on to next
	got	waitnxt

quit:	ret

	.align
ints:
	dc.i	1,2,3,4,5,6,7,8,9,10
longs:
	dc.l	1,2,3,4,5,6,7,8,9,10
floats:
	dc.f	1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0
doubles:
	dc.d	1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0

	toolend tl_speedit
nodeend tl_speedit

.end
