; null device - just outputs to trace

; 16jan95 ARH created
; 26jan95 ARH added read

.include 'tao'
.ctlprefix 'DEVICE/'

; CT_USER2 = open status, contains 0,1
; CT_USER3 = flag for read

node ctl,CONTROLTP,0,TEMPLATE
	control NULL,1024,FUNCTP|DATATP,0,0,0,0
	component ctl,'DEVICE/NULLINIT'				;dv_init
	component ctl,'TAO/LIBRARY'
	component ctl,'DEVICE/GENQUIT'				;dv_quit
	component ctl,'DEVICE/NULLINFO'				;dv_info
	component ctl,'DEVICE/NULLRD'		;dv_read
	component ctl,'DEVICE/NULLWR'					;dv_write
	component ctl,'DEVICE/GENOPEN'				;dv_open
	component ctl,'DEVICE/GENCLOSE'			;dv_close
	component ctl,'DEVICE/NOTSUPPORTED'		;dv_private
	component ctl,'DEVICE/NOERROR'			;Status
	controlend ctl
nodeend ctl

node prn_tool1,TOOLTP,VP,TEMPLATE
	tool 'DEVICE/NULLINIT'

;tracef "device/null: INIT called\n"
	ret

	toolend prn_tool1
nodeend prn_tool1


node prn_tool4,TOOLTP,VP,TEMPLATE
	tool 'DEVICE/NULLWR'

;tracef "device/null: WRITE called:"

	cpy [r1],r8
	add 4,r1
	psh r1
	forsp r8
		cpy.b [r1],r8
		inc r1
		if r8<32
			;tracef "<%X>",r8
		else
			;tracef "<%X,%c>",r8,r8
		endif
	nextsp
;tracef "done\n"
	pop r1
	cpy DATATP,[r0+MG_TYPE]		;Change message type to DATATP
	sub r0,r1
	sendpart r0,r1						;just send the header
	ret

	toolend prn_tool4
nodeend prn_tool4

node unsup_func,TOOLTP,VP,TEMPLATE
	tool 'DEVICE/NULLRD'
	;Read tool
	;r6=control object pointer
	;r0=FUNCTP message pointer
	;r1=message data pointer

	cpy -1,[r1-4]				;Return error
	if [r6+CT_USER3]<10
;tracef "device/null: READ called (<10):"
		cpy 1,[r1-4]
		cpy [r6+CT_USER3],r8
		add '0',r8
		cpy.b r8,[r1]
;tracef "data r8=%X\n",r8
		inc [r6+CT_USER3]
	endif
	cpy DATATP,[r0+MG_TYPE]	;Change message type to DATATP
	sendmail r0
	ret

	toolend unsup_func
nodeend unsup_func

node mouse_tli,TOOLTP,VP,TEMPLATE
	tool 'DEVICE/NULLINFO'
	;device driver info tool
	;r6=control object pointer
	;r0=FUNCTP message pointer
	;r1=message data pointer

	cpy r0,r3
	cpy [r0+MG_OFFSET],r10
	lea devinfo,r2
	cpy devinfoe-devinfo,r11
	loop
		lea [r10+r11],r8
		allocmem r8
		breakif r8!=0
		delay 100000/64
	endloop
	cpb r3,r0,r10
	cpy r8,[r0+MG_LENGTH]
	add r0,r10
	cpb r2,r10,r11
	cpy DATATP,[r0+MG_TYPE]
	sendmail r0
	freenode r3
	ret

devinfo:
	dc.b 'Null device Version 1.0',0
devinfoe:

	toolend mouse_tli
nodeend mouse_tli

.end
