;US IBM 102 key keyboard key position mapping file

;Keycodes (IBMPC):
;
;The lines marked as natural mean that the keynumber is simply the make code
;generated by the keyboard when the specified key is pressed. The lines marked
;as translated mean that the make code was a multi-byte sequence, and that it
;has been translated by the keyboard interrupt handler into a keycode in the 
;following table.
;
;The following are the standard raw key codes generated after position mapping
;has taken place. These are then translated using the country codes into
;ISO10646 characters. The table in this file determines the mapping:
;
;				make/break code -> raw keycode
;
;The interrupt handler puts into the raw key buffer the make code of the key, 
;and a byte saying whether the key was pressed or released.
;
;The index into the make->raw translation table is generated by using the
;make code. The corresponding raw code is the value in the table. Thus to
;alter the position of a key on the keyboard, simply change the value in
;the table below to what you want.
;
;This file contains the reference keyboard mapping in which the raw codes
;correspond directly to the make codes. The table below therefore describes
;both sets.
;
;	Esc			01	(Natural)
;	1			02	(Natural)
;	2			03	(Natural)
;	3			04	(Natural)
;	4			05	(Natural)
;	5			06	(Natural)
;	6			07	(Natural)
;	7			08	(Natural)
;	8			09	(Natural)
;	9			0A	(Natural)
;	0			0B	(Natural)
;	-			0C	(Natural)
;	=			0D	(Natural)
;	Backspace	0E	(Natural)
;	Tab			0F	(Natural)
;	Q			10	(Natural)
;	W			11	(Natural)
;	E			12	(Natural)
;	R			13	(Natural)
;	T			14	(Natural)
;	Y			15	(Natural)
;	U			16	(Natural)
;	I			17	(Natural)
;	O			18	(Natural)
;	P			19	(Natural)
;	[			1A	(Natural)
;	]			1B	(Natural)
;	Enter		1C	(Natural) & (Translated) from E01C
;	Left Ctrl	1D	(Natural)
;	A			1E	(Natural)
;	S			1F	(Natural)
;	D			20	(Natural)
;	F			21	(Natural)
;	G			22	(Natural)
;	H			23	(Natural)
;	J			24	(Natural)
;	K			25	(Natural)
;	L			26	(Natural)
;	;			27	(Natural)
;	'			28	(Natural)
;	`			29	(Natural)
;	Left Shift	2A	(Natural)
;	#			2B	(Natural)
;	Z			2C	(Natural)
;	X			2D	(Natural)
;	C			2E	(Natural)
;	V			2F	(Natural)
;	B			30	(Natural)
;	N			31	(Natural)
;	M			32	(Natural)
;	,			33	(Natural)
;	.			34	(Natural)
;	/			35	(Natural) & (Translated) from E035
;	Right Shift	36	(Natural)
;	KEY*		37	(Natural)
;	Left Alt	38	(Natural)
;	Space		39	(Natural)
;	Caps Lock	3A	(Natural)
;	F1			3B	(Natural)
;	F2			3C	(Natural)
;	F3			3D	(Natural)
;	F4			3E	(Natural)
;	F5			3F	(Natural)
;	F6			40	(Natural)
;	F7			41	(Natural)
;	F8			42	(Natural)
;	F9			43	(Natural)
;	F10			44	(Natural)
;	Num Lock	45	(Natural)
;	Scroll Lock	46	(Natural)
;	KEY7		47	(Natural)
;	KEY8		48	(Natural)
;	KEY9		49	(Natural)
;	KEY-		4A	(Natural)
;	KEY4		4B	(Natural)
;	KEY5		4C	(Natural)
;	KEY6		4D	(Natural)
;	KEY+		4E	(Natural)
;	KEY1		4F	(Natural)
;	KEY2		50	(Natural)
;	KEY3		51	(Natural)
;	KEY0		52	(Natural)
;	KEY.		53	(Natural)
;	SysReq		54	(Natural) & (Translated) from E037, E02AE037
;	Right Alt	55	(Translated) from E038
;	\			56	(Natural)
;	F11			57	(Natural)
;	F12			58	(Natural)
;	Pause		59	(Translated) from E11D45E19DC5
;	Ctrl-Pause	5A	(Translated) from E046E0C6 (Ctrl-Break)
;	Del			5B	(Translated) from E053, E02AE053, E0AAE053, E0B6E053
;	Down arrow	5C	(Translated) from E050, E02AE050, E0AAE050, E0B6E050
;	End			5D	(Translated) from E04F, E02AE04F, E0AAE04F, E0B6E04F
;	Home		5E	(Translated) from E047, E02AE047, E0AAE047, E0B6E047
;	Insert		5F	(Translated) from E052, E02AE052, E0AAE052, E0B6E052
;	Left arrow	60	(Translated) from E04B, E02AE04B, E0AAE04B, E0B6E04B
;	PgDn		61	(Translated) from E051, E02AE051, E0AAE051, E0B6E051
;	PgUp		62	(Translated) from E049, E02AE049, E0AAE049, E0B6E049
;	Right arrow	63	(Translated) from E04D, E02AE04D, E0AAE04D, E0B6E04D
;	Up arrow	64	(Translated) from E048, E02AE048, E0AAE048, E0B6E048
;	Right Ctrl	65	(Translated) from E01D
;
;This file specifies the raw key translation for the keyboard described at the
;top of this file. The translations performed are as follows:
;
;	Make code:						Translates to:
;
;

.include 'tao'
.image

dc.b	$00, $01, $02, $03, $04, $05, $06, $07
dc.b	$08, $09, $0a, $0b, $0c, $0d, $0e, $0f
dc.b	$10, $11, $12, $13, $14, $15, $16, $17
dc.b	$18, $19, $1a, $1b, $1c, $1d, $1e, $1f
dc.b	$20, $21, $22, $23, $24, $25, $26, $27
dc.b	$28, $29, $2a, $2b, $2c, $2d, $2e, $2f
dc.b	$30, $31, $32, $33, $34, $35, $36, $37
dc.b	$38, $39, $3a, $3b, $3c, $3d, $3e, $3f
dc.b	$40, $41, $42, $43, $44, $45, $46, $47
dc.b	$48, $49, $4a, $4b, $4c, $4d, $4e, $4f
dc.b	$50, $51, $52, $53, $54, $55, $56, $57
dc.b	$58, $59, $5a, $5b, $5c, $5d, $5e, $5f
dc.b	$60, $61, $62, $63, $64, $65, $66, $67
dc.b	$68, $69, $6a, $6b, $6c, $6d, $6e, $6f
dc.b	$70, $71, $72, $73, $74, $75, $76, $77
dc.b	$78, $79, $7a, $7b, $7c, $7d, $7e, $7f

.end