.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/DK'

	;inputs
	;r0=ptr to command string
	;r8=character (ignored)
	;outputs
	;r0=NULL

	;defines a key.  Command string consists of keys and a
	;textual string to define it to.

	;keys are specified as a number (the inskn function is provided
	;to insert a key number into the text) in hex with the prefix
	;encoded as <<16 (where one exists).

	;eg:
	;	dk 1B     prefix
	;	dk 1B0041 up
	;or
	;	dk ^[     prefix
	;	dk ^['A   up

	qcall	LIB/STRSKIPW
	cpy.b	[r0],r8
	clr	r14
loop:	asl	16,r14
	if	r8='^'
		cpy.b	[r0+1],r8
		and	31,r8		;ctrl char
		or	r8,r14
		add	2,r0
	elseif	r8="'"
		cpy.b	[r0+1],r8	;character itself
		or	r8,r14
		add	2,r0
	else
		clr	r1
		cpy	16,r8
		qcall	LIB/STRTOUL	;get hex number
		cpy r8,r14
	endif
	cpy.b [r0],r8
	bool r8>' ',loop	;get a second character

	qcall	LIB/STRSKIPW	;get next macro posn

	cpy r0,r3

	cpy r0,r1
	cps r0,r1,r8		;get size of macro string

	add	DK_MACRO+2,r8
	allocmem	r8
	bool	r8=0,errmem
	cpy	r8,[r0+MN_BYTES]
	cpy	r14,[r0+DK_KEY]
	cpy	r0,r1
	add	DK_MACRO,r1

	cps  r3,r1,r8		;copy string in

	cpy	[r6+CT_EDDATA],r1
	add	ED_DKLIST,r1
	addhead	r1,r0,r8		;place on list
	
	clr	r0
	ret


errmem:		;here if cannot find mem to allocate it
		;just beep and exit
	clr	r0
	qcall	ED/BEEP,VIRTUAL
	ret

	toolend toolb
nodeend toolb

.end

