* ed/ed.inc
* equates for ED version 2.1

CT_EDDATA =   CT_USER1 ;ED_ structure, object for LCALL and other data area
CT_EDFLAGS =  CT_USER2 ;flags, see EF_
CT_EDPREFIX = CT_USER3 ;prefix characters
CT_EDAREAIO = CT_USER4 ;private for STDIO and DESK


********************************************
* call numbers for LCALLs to parent stuff
********************************************

	structure
	byte	EL_CLOSE
	byte	EL_KEYSTAT
	byte	EL_KEY	;raw keystrokes
	byte	EL_DISP	;display all windows
	byte	EL_MENU
	byte	EL_CHWIN	;f2
	byte	EL_MKWIN	;f3
	byte	EL_RMWIN	;f4
	byte	EL_BEEP

********************************************
* equates structure
********************************************

TOK_SZ	=	32
CMD_SZ	=	512
LINE_SZ	=	128
NAME_SZ	=	256
MAC_SZ	=	512
TEXT_SZ	=	4080

	structure
	struct	ED_OBJ,OO_DATA
	struct	ED_STATUS,LINE_SZ	;status buffer
	struct	ED_TOKSTR,TOK_SZ	;no probs in ovf since into CMDSTR
	struct	ED_DOSTR,TOK_SZ		;private to ED/DO (ditto on ovf!)
	struct	ED_CMDSTR,CMD_SZ	;general command area
	int32	ED_MAXUNDO		;max undo blks per buffer (4)
	;windows/buffers
	pointer	ED_CURWIN		;ptr to current window (WH)
	struct	ED_WINLIST,LH_SIZE	;list of windows (WH)
	struct	ED_BUFLIST,LH_SIZE	;list of buffer heads (BH)
	struct	ED_DKLIST,LH_SIZE	;list of keys defined (DK)
	struct	ED_XRLIST,LH_SIZE	;list of extensions defined (XR)
	struct	ED_COLORS,8		;colour bytes (FG,BG,hilitFG,BG,statusFG,BG)
	;keymacros
	pointer	ED_MACSTRR	;record MACSTR ptr (NULL=no rec)
	pointer	ED_MACSTRP	;mac playback ptr (NULL=not)
	struct	ED_MACSTR,MAC_SZ	;keymacro string area
	size	ED_MACEND
	;saved status - private to DESK:
	int32	ED_SPOSX
	int32	ED_SPOSY
	pointer	ED_PASTEP	;paste buffer (ptr to Undo buf)
	struct	ED_FINDSTR,CMD_SZ ;string to find (for findnext)
	int32	ED_XMAX
	int32	ED_YMAX		;screen size (tui only)
	struct	ED_REPLSTR,CMD_SZ ;string to find (for findnext)
	int32	ED_BACKTIME
	size	ED_SIZE

* ED_WINLIST points "window" headers, common to both TUI and
* GUI modes, these describe the buffers pointed to by each window:
	structure
	struct	WH_NODE,MN_SIZE
	int32	WH_BUFH		;buffer ptr (BH_)
	int32	WH_SAVEBI	;start of save area (Buf index when saved)
	int32	WH_XCHARS	;size in chars of window (savable)
	int32	WH_YCHARS
	int32	WH_POSX		;private to STDIO/DESK (savable)
	int32	WH_POSY		;(window posn)
	int32	WH_CURSOR	;cursor offset
	int32	WH_RSCROLL	;offset of righthand side
	int32	WH_TOPCUR	;top window offset
	size	WH_SAVEEND	;end of saved area
	struct	WH_LINCUR,50*16	;DISP: up to 50 lines of cursor posns
	int32	WH_CURX		;set by DISP
	int32	WH_CURY
	int32	WH_TURN		;DISP: (which line to display next)
	int32	WH_XCOL		;used by RIGHT and LEFT for posn (-1=unset)
	pointer	WH_WOB		;DISP(desk): window object ptr
	int32	WH_CHANGEF	;DISP: set if "*" on title display
	size	WH_SIZE

;LINCUR stuff : starts at TOPCUR, one for each line
	structure
	int32	WHL_CUR	;cursor
	int32	WHL_CKS	;checksum
	int32	WHL_OLDCKS	;old CKS
	int32	WHL_FLG		;1=selected at SOLN
	size	WHL_SIZE

* ED_BUFLIST points to list of buffer heads
	structure
	struct	BH_NODE,MN_SIZE
	struct	BH_BUFB,LH_SIZE		;list of buffer blocks
	struct	BH_UNDO,LH_SIZE		;list of undo blocks
	int32	BH_EXTP			;extension record ptr (XR_)
	int32	BH_LOGGED		;non-zero if log mark written
	int32	BH_MARKB		;mark cursor (for block ops)
	int32	BH_MARKE		;mark(end) cursor (WS block ops)
	int32	BH_MMODE		;mark mode:0=none,1=ch,2=line,3=WS
	int32	BH_CHANGEF		;see below
	int32	BH_CURSOR		;cursor offset (*)
	int32	BH_RSCROLL		;offset of righthand side (*)
	int32	BH_TOPCUR		;top window offset (*)
	struct	BH_NAME,NAME_SZ		;filename (if named buffer)
	struct	BH_NAM2,NAME_SZ		;temp filename for backup etc
	int32	BH_FILE1		;handle for NAME (0 if none)
	int32	BH_FILE2		;handle for NAM2 (0 if none)
	size	BH_SIZE

;CHANGEF = 1 if changed recently, 2 if backedup, 4 if readonly
;ie: 1/3=needs backup/save; 2=just rename backup file; 0/4=no change

;MMODE is the mark mode: 0=not marked, 1=character based marks - from
;MARKB to cursor or from cursor to MARKB, 2=line based marks (whole 
;lines),  3=wordstar line marks from MARKB to MARKE.

;(*)-duplicate of WH_ field: these fields are for DESK or STDIO to 
;manage, typically WH field superseeds BH; BH is for when no WH.

* BUFB points to buffer blocks or surrogate nodes
	structure
	struct	BB_NODE,MN_SIZE
	int32	BB_NTEXT	;number of bytes in text blk
	int32	BB_FLAG		;
	;int32	BB_FILEOFF	;offset in file if no data
	size	BB_SIZE1	;size of truncated BB
	struct	BB_DATA,TEXT_SZ	;data (unchanged if 1, changed if 2)
	size	BB_SIZE

* DK structure for defined keys
	structure
	struct	DK_NODE,MN_SIZE
	int32	DK_KEY
	size	DK_MACRO		;macro fills rest of buffer


* XR structure for extensions

	structure
	struct	XR_NODE,MN_SIZE
	int32	XR_EXT			;0=default, else 3 chars string
	int32	XR_WRAP			;wrap col, 0=off
	struct	XR_TABS,8		;7 1-byte col tab stops (last=0)
	size	XR_SIZE


********************************************
* flags in EDFLAGS
********************************************

	dbitstart
	dbit EF_QUIT,BEF_QUIT	;must quit from main loop
	;modes
	dbit EF_REGX,BEF_REGX	;regular expressions on
	dbit EF_ICAS,BEF_ICAS	;case insensitive searches
	dbit EF_GCAS,BEF_GCAS	;general case searches (alt to ICAS)
	dbit EF_VIMO,BEF_VIMO	;"vi" mode, treat text as lookup too
	dbit EF_WRCR,BEF_WRCR	;write CRs on save (before LFs)
	dbit EF_FWD, BEF_FWD 	;search 1:forward 0:backward
	;display modes
	dbit EF_TIME,BEF_TIME	;time on status line.
	dbit EF_BORD,BEF_BORD	;border (text mode display only)
	dbit EF_HSLI,BEF_HSLI	;horiz slider (gui mode display only)
	dbit EF_VSLI,BEF_VSLI	;vert slider (gui mode display only)
	;display ctrl
	dbit EF_STAT,BEF_STAT	;status line needs redisplay
	dbit EF_SCUR,BEF_SCUR	;cursor needed in status window
	dbit EF_REDI,BEF_REDI	;all display needs redisplay


********************************
** ED macros - buffer handling
********************************

.macro GETCUR	;reg
	cpy [r6+CT_EDDATA],%1
	cpy [%1+ED_CURWIN],%1
	cpy [%1+WH_CURSOR],%1
.endm

.macro GETR	;offset
	;gets block at offset n for reading
	.check %N=1
	copy %1,r8
	cpy [r6+CT_EDDATA],r0
	cpy [r0+ED_CURWIN],r0
	cpy [r0+WH_BUFH],r0
	cpy r8,r10
	cpy [r0+BH_BUFB],r1
	;here r1->first BB_ or end
	loop
		;here r1->BB_ or end
		cpy [r1+LN_SUCC],r2	;next but one
		breakif r2=0
		;here r1->valid BB_, r2->next BB_ or end
		cpy [r1+BB_NTEXT],r13
		bool r13>r8,%Lok
		cpy r2,r1
		sub r13,r8
	endloop
	;here if terminated on out of buffer, set r2=r13 & r10
	sub r8,r10
	cpy r13,r8 ;dummy to point at end
	cpy [r1+LN_PRED],r1
%Lok:	;here r1-> valid BB_ where r8 offset is in [0..r13)
	if [r1+BB_FLAG]>2
		qcall ED/B/GETBLK
	endif
	lea [r1+BB_DATA],r12
	add r12,r13
	lea [r12+r8],r2
	;r0=BH_, r1=BB_, r2=text, r10=offset, r12=textstart, r13=textend+1
.endm

.macro SUCCR	;r1,jumpeof
	;go on to next BB node - input r1=BB_
	.check %N=2 & (%1=r1)
%La:	cpy [r1+LN_SUCC],r1	;points to next node
	tst [r1+LN_SUCC]	;next but one
	beq %2
	cpy [r1+BB_NTEXT],r13
	bool r13=0,%La	;next...
	if [r1+BB_FLAG]>2
		qcall ED/B/GETBLK
	endif
	lea [r1+BB_DATA],r12
	add r12,r13
	cpy r12,r2	;start at beginning
	;r1=BB_, r2=text, r12=textstart, r13=textend+1; pres others
.endm

.macro PREDR	;r1,jumpsof
	;go back to previous BB node - input r1=BB_
	.check %N=2 & (%1=r1)
%La:	cpy [r1+LN_PRED],r1	;points to next node
	tst [r1+LN_PRED]	;next but one
	beq %2
	cpy [r1+BB_NTEXT],r13
	bool r13=0,%La	;next...
	if [r1+BB_FLAG]>2
		qcall ED/B/GETBLK
	endif
	lea [r1+BB_DATA],r12
	add r12,r13
	cpy r13,r2		;start at end+1
	;r1=BB_, r2=text+1, r12=textstart, r13=textend+1
.endm

.macro MOVE	;offset
	copy %1,r8
	qcall ED/MOVE
.endm

.macro SETBUF	;bh
	copy %1,r0
	qcall ED/B/SETBUF
.endm

.macro RESETXCOL
	cpy [r6+CT_EDDATA],r0
	cpy [r0+ED_CURWIN],r0
	cpy -1,[r0+WH_XCOL]
.endm

.macro MBLEFT ;r2
	;after GETR move r2 left one character, also decrements r10
	;nb: use MBTOWC to move right
	.check (%N=1) & (%1=r2)
	repeat
		dec r2
		dec r10
		breakif r2<=r12
		cpy.b [r2-1],r8
	until r8<$80
.endm

.macro ADDCHARWIDTH ;char, ctr
	inc %2
	if %1>$4000
		if %1<$FF00
			inc %2	;Kanji is twice as wide
		endif
	endif
.endm

********************************
** ED macros - flag handling
********************************

.macro FLAG ;EF_xxx,'name'
	;inputs
	;r0=command tail or ''
	;r8=set(1)/clr(0)/toggle(2)
	;outputs
	;r8=new state, r0=preseved or 'show %2 on/off'

	cpy [r6+CT_EDFLAGS],r9
	if r8=2	;toggle
		cpy r9,r8
		not r8
		and %1,r8
	endif
	lea %L0,r1
	bcr B%1,r9
	if r8!=0
		add %L1-%L0,r1
		bst B%1,r9
	endif
	cpy r9,[r6+CT_EDFLAGS]
	cpy.b [r0],r9
	if r9=0
		cpy r1,r0
	endif
	ret

%L0:	dc 'show ',%2,' off',0
%L1:	dc 'show ',%2,' on',0
.endm

********************************************
* end
********************************************
