.include 'tao'
.include 'ed/ed'

.macro skip_strings ;pointer to string array, number to skip - 1
	.check %N=2
	;Skip %2+1 strings in the string array pointed to by %1.
	;Will always skip at least 1 string.
	loop
		cps %1,%1,r11
		inc %1
		breakif %2=0
		dec %2
	endloop
.endm

node toolb,TOOLTP,VP,TEMPLATE	;tool object
	tool 'ED/FDO'

	;inputs
	;r0=ptr to command string
	;r8=character (ignored)
	;outputs
	;r0=redone command

	;r12 = Pointer to selected filename array
	clr r12		;Initialise to 0

	;copy from r0 to DOSTR, including space
	cpy [r6+CT_EDDATA],r2
	add ED_DOSTR,r2
	loop
		cpy.b [r0],r8
		breakif r8!=' '
		inc r0
	endloop
	repeat
		cpy.b [r0],r8
		inc r0
		cpy.b r8,[r2]
		inc r2
	until r8<=' '

	bool r8=0, err

	;do line command
	pshm r2,r12
	qcall ED/LINE
	pop r12
	bool r8=1,tb	;If tab was pressed, jump to file selection routine
	pop r2			;Back here with r0 = file selected

	;recombine
	if r0!=NULL
		cps r0,r2,r8
	else
		cpy.b 0,[r2]
	endif

	cpy [r6+CT_EDDATA],r0
	add ED_DOSTR,r0
	qcall ED/REDISP
err:	ret

;---------------------------------------------

ex1:	;Process all filenames in selected filename array (r12 points to it)
	pop r2

	if r12!=NULL
		cpy r12,r0
		add 12,r0
		psh r12

		loop
			;Execute command
			psh r2

			;If filename starts with './' remove those 2 characters
			;Also need to move down all other filenames in array by 2 chars
			cpy.b [r0],r8
			if r8='.'
				cpy.b [r0+1],r8
				if r8='/'
					cpy r0,r2
					add 2,r2
					psh r0
					loop
						loop
							cpy.b [r2],r8
							cpy.b r8,[r0]
							inc r0
							inc r2
							breakif r8=0
						endloop
						cpy.b [r2],r8
						breakif r8=0		;If end of list, finish, else loop
					endloop
					cpy.b 0,[r0]
					pop r0
					cpy [r7],r2
				endif
			endif

			;Copy filename into command string buffer changing all 
			; characters to lower case.
			loop
				cpy.b [r0],r8
				if r8>=$41								;If character is upper case
					if r8<$5A
						or $20,r8		;change to lower case
					endif
				endif
				cpy.b r8,[r2]
				breakif r8=0
				inc r2
				inc r0
			endloop

			inc r0
			psh r0
			cpy [r6+CT_EDDATA],r0
			add ED_DOSTR,r0
			qcall ED/EXEC
			popm r0,r2
			cpy.b [r0],r8
			breakif r8=0
		endloop

		pop r12
		freenode r12
	endif

	cpy [r6+CT_EDDATA],r0
	add ED_STATUS,r0
	cpy.b 0,[r0]
	bst BEF_STAT,[r6+CT_EDFLAGS]
	qcall ED/REDISP

	cpy [r6+CT_EDDATA],r0
	add ED_DOSTR,r0
	cpy.b 0,[r0]
	ret

;---------------------------------------------

tb:	;Do splitdir on string passed back. Try to opendir pathname returned.
	; If successful, it is a directory - no worries. If the opendir fails,
	; add "*" on end of pathname and retry splitdir.
	;
	;Execution gets to here with r0 = pointer to string (nul term).
	;Return from here goes to ex1 with r0 = pointer to new filename string
	; if successful, else back to loop with r0 preserved
	;

	cpy.b [r0],r13
	if r13=0				;If nul string returned, add '.'
		cpy.b '.',[r0]
		cpy.b 0,[r0+1]
	else
		cpy r0,r2
		cps r2,r2,r13
		cpy.b [r2-1],r13
		if r13='/'
			cpy.b 0,[r2-1]
		endif
	endif

	psh r0
	allocstruct 256,r1
	clr r14
trystar:
	pshm r12,r14,r0
	qcall LIB/SPLITDIR
	cpy r1,r3			;Save wildcard string
	pshm r0,r3			;
	cpy 1,r8			;Allow directories
	qcall LIB/LISTDIR	;Get directory listing
	cpy r0,r2			;Save directory listing pointer
	popm r3,r10,r0,r14,r12

	;r14 = Loop counter (0 or 1)
	;r10 = Pointer to directory pathname
	;r2  = Pointer to directory listing
	;r0  = Pointer to selection string destination buffer
	bool r2!=0,gotdir	;If successfully got directory listing, jump
	bool r14!=0,failtab ;Only one repeat attempt is valid

	;Add "*" on end of string (if there is enough space)
	cpy r0,r2			;
	cps r2,r2,r8		;Find end of string
	cpy.b '*',[r2]		;
	cpy.b 0,[r2+1]		;Add nul char
	inc r14 			;Increment loop counter
	cpy r7,r1
	got trystar 		;

;---------------------------------------------

gotdir:
	;Here with r2=directory listing pointer, r3=wildcard string pointer,
	; r10=pointer to directory spec string

	;Call file selection menu bit.

	psh r10
	lea titlestr,r8
	cps r8,r8,r11
	cpy [r2+MN_BYTES],r8
	add r11,r8
	allocmem r8			;Allocate memory for string buffer
	bool r8=0,failmem
	cpy r8,[r0+MN_BYTES]
	psh r0

	add 12,r0
	lea titlestr,r8		;Copy title string into new buffer
	cps r8,r0,r11
	inc r0

	psh r2
	add 12,r2
	clr r13				;Number of files
	clr r14				;Number of directories
	loop
		cpy.b [r2],r8
		breakif r8=0
		if r8='.'
			cpy.b [r2+1],r8
			if r8='/'
				cps r2,r2,r8	;Don't copy '.' directory string
				inc r2
				continue
			endif
		endif
		cpy.b ' ',[r0]		;Insert 2 spaces at beginning of filename
		cpy.b ' ',[r0+1]
		add 2,r0
		cps r2,r0,r8	;Copy string from old buffer into new buffer
		cpy.b [r0-1],r8
		if r8='/'
			inc r14		;Increment directory count
		else
			inc r13		;Increment file count
		endif
		inc r0
		inc r2
	endloop
	cpy.b 0,[r0]
	pop r2

	freenode r2
	cpy [r7],r0		;Get string array pointer
	
	if r13=0	;If no strings, error - no menu
		if r14=0
			popm r0,r10
			freenode r0
			got failtab
		endif
	endif

	;Sort files alphabetically.
	add 12,r0
	cps r0,r0,r8	;Skip title string
	inc r0
	loop
		breakif r14=0
		cps r0,r0,r8	;Skip directory strings
		inc r0
		dec r14
	endloop
	psh r12				;Save pointer to filename array
	qcall LIB/T_SORT	;Call sorting routine
	pop r12

	;Display instructions on status line
	pshm r0,r12,r3
	cpy [r6+CT_EDDATA],r0
	add ED_STATUS,r0
	lea statusline,r1
	cps r1,r0,r8
	bst BEF_STAT,[r6+CT_EDFLAGS]
	qcall ED/DISP
	popm r3,r12,r0

	cpy [r7],r1
	psh r3
	add 12,r1
	;r1 points to menu string
	cpy [r6+CT_EDDATA],r0
	clr r8
tryag:	pshm r0,r1,r12
	lcall r0,EL_MENU
	popm r12,r1,r0
	bool r9=$a,return_key
	bool r9=' ',space_bar
	bool r9=$1B,escape_key
	bool r9='*',asterisk
	bool r9=$E02A,asterisk
	got tryag

;----------------------------------------------

	;Escape was pressed. Do not process any files
escape_key:
	popm r3,r0,r10

	;r0 = Pointer to options string, r1 = Pointer to buffer, r8 = selection
	;r10 = Pointer to directory name string

	freenode r0
	got failtab

;----------------------------------------------

	;Return was pressed. Add selected string to array of filenames and 
	;go to processing routine.
return_key:
	popm r3,r0,r10

	;r0 = Pointer to options string, r1 = Pointer to buffer, r8 = selection
	;r10 = Pointer to directory name string

	psh r0				;Push string buffer pointer
	add 12,r0
	skip_strings r0,r8	;skip to correct string

gotstring:
	;here with r0=pointer to selected string, r1=pointer to buffer
	; r10=pointer to directory name string, r3=pointer to wildcard string

	psh r0
	cps r0,r0,r8
	cpy.b [r0-1],r8
	pop r0
	bool r8='/',directry

	;Here if string is not a directory.

	gos add_strings		;Add strings r10 and r0 to string array r12
	bool r8=0,failadd1

	pop r14				;Pop pointer to string buffer

	freenode r14		;Free string buffer
	freestruct 256		;Clean up stack
	pop r0
	got ex1

;---------------------------------------

	;Space was pressed - add selected string to array of filenames, and
	;go back to menu display routine.
space_bar:
	;Add selected string to array of selected strings
	popm r3,r0,r10

	;r0 = Pointer to options string, r1 = Pointer to buffer, r8 = selection
	;r10 = Pointer to directory name string

	cpy r0,r14
	cpy r8,r9
	add 12,r0
	skip_strings r0,r9	;Get pointer to correct string

	;Here with r0=pointer to selected string, r1=pointer to buffer
	; r10=pointer to directory name string, r3=pointer to wildcard string

	psh r0
	cps r0,r0,r9
	cpy.b [r0-1],r9
	pop r0
	psh r14
	bool r9='/',directry
	add 4,r7

	cpy.b [r0],r9
	if r9=$3E		;if file already selected, remove from list
		pshm r10,r14,r3,r8,r1,r0
		gos remove_strings
		pop r0
		cpy.b ' ',[r0]		
	else
		pshm r10,r14,r3,r8,r1,r0
		gos add_strings		;Add strings r10 & r0 to string array r12
		bool r8=0,failadd2
		pop r0
		cpy.b '>',[r0]
	endif
	cpy [r6+CT_EDDATA],r0
	popm r1,r8
	got tryag			;Go back for another string

;---------------------------------------

	;Asterisk was pressed - add all filenames to the array of selected
	;strings and go back to menu display routine.
asterisk:
	popm r3,r0,r10

	;r0 = Pointer to options string, r1 = Pointer to buffer, r8 = selection
	;r10 = Pointer to directory name string

	pshm r8,r0			;Save option number

	add 12,r0
	cps r0,r0,r8	;Skip title string
	inc r0
	;Skip directory strings
	loop
		cpy r0,r2
		cps r0,r0,r8
		cpy.b [r0-1],r8
		breakif r8!='/'	;If not a directory, break out of loop
		inc r0
	endloop

	;r2 points to first non-directory entry in string array.
	; r10=pointer to directory name string, r3=pointer to wildcard string

	cpy r2,r0
	popm r2,r8
	pshm r10,r2,r3,r8,r1,r0
	loop
		pshm r10,r0
		gos add_strings
		popm r0,r10
		bool r8=0,failadd2
		cpy.b '>',[r0]
		cps r0,r0,r8		;Find next string in array
		inc r0
		cpy.b [r0],r8
		breakif r8=0		;Break out if end of list
	endloop

	cpy [r6+CT_EDDATA],r0
	add 4,r7
	popm r1,r8

	got tryag			;Go back for another string

;----------------------------------------------

directry:
	;If wildcard string is not null, copy it to another buffer for a while

	if r3!=NULL
		pshm r0,r3
		cps r3,r3,r8		;Find length of string
		inc r8				;Allow for nul char
		add MN_SIZE,r8
		allocmem r8			;Allocate memory
		bool r8=0,failmem1
		cpy r8,[r0+MN_SIZE]
		add 12,r0
		pop r3
		cps r3,r0,r8		;Copy string
		sub r8,r0
		cpy r0,r3			;r3 = Pointer to wildcard string
		pop r0
	endif

	pop r14				;Pop pointer to string buffer
	cpy r0,r8			;Save pointer to selected string
	add 2,r8			;Allow for 2 spaces at start
	freestruct 256		;Clean stack
	cpy [r7],r2			;Get destination buffer pointer
	cps r10,r2,r9		;Copy directory name
	if r9!=0			;Copy '/' if non-zero length
		cpy.b '/',[r2]
		inc r2
	endif
	cps r8,r2,r9		;Copy new directory name
	psh r2

	freenode r14		;Free string buffer
	popm r2,r0

	;r0 = Destination string buffer pointer
	;r2 = Terminal nul of destination string pointer
	;r3 = Wildcard string

	cpy.b 0,[r2-1]	;Remove final '/'
	dec r2
	cpy.b [r2-1],r8
	if r8='.'			;If the ".." directory has been selected
		cpy.b 0,[r2-1]	;Remove last '.'
		cpy.b 0,[r2-2]	;Remove first '.'
		sub 3,r2
		cpy.b 0,[r2]			;Remove '/'
		dec r2
		loop					;Remove previous level directory name
			cpy.b [r2],r8
			cpy.b 0,[r2]
			breakif r2<=r0
			breakif r8='/'
			dec r2
		endloop
	endif

	if r3!=NULL
		psh r0
		if r2!=r0
			cpy.b '/',[r2]
			inc r2
		endif
		cps r3,r2,r8		;Copy in wildcard string
		sub r8,r3
		sub 12,r3

		freenode r3		;Free wildcard string buffer
		pop r0
	endif

	bst BEF_REDI,[r6+CT_EDFLAGS]
	psh r12
	qcall ED/DISP
	pop r12
	got tb

;---------------------------------------------

failadd2:
	popm r0,r1,r8,r3,r14,r10
	freenode r14
	got failtab
failadd1:
	pop r14				;Pop pointer to string buffer
	freenode r14		;Free string buffer
	got failtab
failmem1:
	pop r0				;Pop pointer to string buffer
	freenode r0			;Free string buffer
	got failtab
failmem:
	add 4,r7
	freenode r2
failtab:
	if r12!=NULL
		freenode r12
	endif
	freestruct 256		;clean up stack
	add 4,r7			;restore pointers
	qcall ED/REDISP
	cpy 0,r0
	pop r2
	cpy.b 0,[r2]
	ret

;----------------------------------------------

add_strings:
	;Inputs: r0 = Pointer to Filename string (preceded by 2 spaces)
	;		 r10 = Pointer to directory string
	;		 r12 = Pointer to string array

	;Adds a pair of strings making up a filename to a string array.
	;The string array may need to be extended, and it may be a NULL
	; pointer in which case it must be created. The pointer in r12 may
	; be changed.

	pshm r0,r10
	clr r11	;Length
	cps r10,r10,r11
	inc r11	;Allow for '/'
	cps r0,r0,r8
	add r8,r11
	inc r11	;Allow for nul character

	if r12=NULL
		;Create string array and copy strings into it.
		add 13,r11	;Allow for MN_ node and array terminating nul char
		allocmem r11
		bool r8=0,memerr
		cpy r8,[r0+MN_BYTES]
		cpy r0,r12
		add 12,r0
	else
		add [r12+MN_BYTES],r11
		allocmem r11
		bool r8=0,memerr
		cpy r8,[r0+MN_BYTES]
		add 12,r0
		cpy [r12+MN_BYTES],r8
		add 12,r12
		sub 12,r8
		cpb r12,r0,r8
		psh r0
		sub 12,r12
		freenode r12
		pop r0
		cpy r0,r12
		sub 12,r12
		loop		;Find insertion point
			cps r0,r0,r8
			inc r0
			cpy.b [r0],r8
			breakif r8=0
		endloop
	endif

	;r0 Points to insertion point
	popm r10,r1		;Get filename string
	cpy.b [r10],r8
	if r8='.'		;Unless directory is '.', copy directory string
		cpy.b [r10+1],r8
		if r8!=0
			cps r10,r0,r8	;Copy directory string
			cpy.b '/',[r0]	;Copy '/'
			inc r0			;
		endif
	else
		cps r10,r0,r8	;Copy directory string
		cpy.b '/',[r0]	;Copy '/'
		inc r0			;
	endif
	add 2,r1		;Don't copy the 2 spaces
	cps r1,r0,r8	;Copy filename string
	cpy.b 0,[r0+1]	;Add list terminating nul character
	cpy 1,r8		;Return "success"
	ret

memerr:	
	add 8,r7
	cpy 0,r8		;Memory error - return failure code
	ret

;----------------------------------------------

remove_strings:
	;Inputs: r0 = Pointer to Filename string (preceded by 2 spaces)
	;		 r10 = Pointer to directory string
	;		 r12 = Pointer to string array

	;Removes the string made up from the two strings specified in r10 and
	; r0 from the string array pointed to by r12. If the specified string
	; is not in the string array, no action is taken.
	;The pointer in r12 may be changed on exit from this routine as the
	; string array may have been re-allocated with a smaller size.

	bool r12=NULL,noarray
	cpy r12,r1
	add 12,r1
	add 2,r0
	clr r13				;Clear flag indicating whether changed
	loop
		pshm r10,r0
		loop				;Compare initial (r10) string
			cpy.b [r10],r8	;Get character
			cpy.b [r1],r9	;Get character
			inc r10
			if r8=0	;If end of string
				cpy 0,r11
				break
			endif
			if r8!=r9
				cpy 1,r11	;Indicate failure
				break
			endif
			inc r1
		endloop

		;At this point, if r11=1, string comparison has already failed, so
		; just skip to end of string and try next one.
		if r11=1
			cpy.b [r1],r8
			if r8!=0
				cps r1,r1,r8	;Skip to end of string
			endif
			inc r1			;r0 = Pointer to next string
		else	;Here if directory comparison successful
			inc r1		;Allow for '/' character
			loop
				cpy.b [r0],r8	;Get character
				cpy.b [r1],r9	;Get character
				if r8!=r9
					cpy 1,r11	;Indicate failure
					if r9!=0
						cps r1,r1,r8
					endif
					inc r1		;Go to end of string
					break
				endif
				inc r0
				if r8=0	;If end of string, comparison was successful
						; remove string from list.
					cpy r1,r2
					inc r2		;r2 = Pointer to string to copy down
					loop
						dec r1
						cpy.b [r1],r8
						breakif r8=0
					endloop
					inc r1		;r1 = Pointer to string to overwrite
					psh r1
					cpy 1,r13

					;Copy down successive strings, overwriting string r1
					loop
						cpy.b [r2],r8
						breakif r8=0
						cps r2,r1,r8
						inc r2
						inc r1
					endloop
					cpy.b 0,[r1]		;Copy list terminating nul char
					pop r1
					break
				endif
				inc r1
			endloop
		endif
		;Here with r1 pointing to start of next string to try.
		cpy.b [r1],r8
		popm r0,r10
		breakif r8=0
	endloop

	;If r13!=0, reallocate buffer with a more appropriate size.
	bool r13=0,noarray
	cpy r12,r1
	add 12,r1
	clr r11		;Initialise length counter
	loop
		cpy.b [r1],r8
		breakif r8=0
		cps r1,r1,r8
		add r8,r11
		inc r11
		inc r1
	endloop

	;Here with length of string array required in r11
	clr r0
	bool r11=0,freer12		;If no string array required, free it.
	add 13,r11
	psh r11
	allocmem r11
	pop r11
	bool r8=0,memerr1
	cpy r8,[r0+MN_BYTES]
	add 12,r0
	sub 12,r11
	add 12,r12
	cpb r12,r0,r11
	sub 12,r0
	sub 12,r12
freer12:
	psh r0		;Free original array and copy pointer
	freenode r12
	pop r12
noarray:
	cpy 0,r8	;Return success value
	ret
memerr1:
	cpy 1,r8	;Return failure value
	ret

;--------------------------------------------

statusline:	dc '*=Select all, space=Select curr, ret=Select curr & exit, esc=Escape',0
titlestr:	dc 'File Selection',0

	toolend toolb
nodeend toolb

.end
