.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/FILEEXT'

	;inputs
	;r0=ptr to command string
	;r8=character to insert on left of cursor
	;outputs
	;r0 advanced

	;takes "fileext .XXX" and creates XR_ of the correct ext.
	;modifies the current window type
	;execs the rest of the line in this new context.
	;finally restores current window extension type.

	cpy [r6+CT_EDDATA],r3
	cpy [r3+ED_CURWIN],r3
	cpy [r3+WH_BUFH],r3
	
	loop
		cpy.b [r0],r8
		breakif r8!=' '
		inc r0
	endloop
	if r8='.'
		inc r0
	endif

	clr r12	;place to accumulate them
	loop
		cpy.b [r0],r8
		breakif r8<=' '
		asl 8,r12
		or r8,r12
		inc r0
	endloop
	psh r0
	allocmem XR_SIZE
	bool r8=0, bad

	;here r0->curext structure
	cpy r8,[r0+MN_BYTES]
	cpy r12,[r0+XR_EXT]
	clr [r0+XR_WRAP]		;default no wrap
	cpy $20181008,[r0+XR_TABS]	;default 8 col tabs
	cpy $00383028,[r0+(XR_TABS+4)]

	;save as current
	cpy r0,[r3+BH_EXTP]

	;add to list
	cpy [r6+CT_EDDATA],r1
	add ED_XRLIST,r1
	addhead r1,r0,r8

bad:	pop r0
	qcall ED/EXEC		;execute rest of line in EXTP context

	;now reset all buffer's BH_EXTP
	cpy [r6+CT_EDDATA],r3
	cpy [r3+ED_BUFLIST],r3
	loop
		nextnode r3,r2
		.include 'ed/buf/setxr.ism'
	endloop

	clr r0
	ret

	toolend toolb
nodeend toolb

.end

