.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/FIND'

	;inputs
	;r0=ptr to string to find (NULL=previous string)
	;r8=character (ignored) or -1 to indicate pre-advance
	;outputs
	;r0=NULL (success) or show error message
	;r8=number of bytes matched (0=none)
	;also aborts any macro if search fails

.macro TOUPPER ;reg
	if %1>='a'
		if %1<='z'
			sub 'a'-'A',%1
		endif
	endif
.endm

.macro TOLOWER ;reg
	if %1>='A'
		if %1<='Z'
			add 'a'-'A',%1
		endif
	endif
.endm

	;save flag
	cpy r8,r15

	if r0!=0
		;skip exactly one leading space (since "find<sp><pattern>")
		cpy.b [r0],r8
		if r8=' '
			inc r0
		endif

		;save string for which to search, expanding \t \n \\
		cpy [r6+CT_EDDATA],r1
		add ED_FINDSTR,r1
		repeat
			cpy.b [r0],r8
			inc r0
			if r8='\'
				cpy.b [r0],r8
				inc r0
				if r8='t'
					cpy TAB,r8
				elseif r8='n'
					cpy LF,r8
				endif
			endif
			cpy.b r8,[r1]
			inc r1
		until r8=0
	endif

	cpy [r6+CT_EDDATA],r3
	add ED_FINDSTR,r3

	;find start position
	GETCUR r8
	if r15=-1
		inc r8	;special pre-increment
	endif
	GETR r8
	;r1=BB_, r2=text, r10=offset, r12=textstart, r13=textend+1
	;set r3=string to find, r9=first char of string

	bool [r6+CT_EDFLAGS]?BEF_FWD, fwd
	got back

prev:	add r2,r10
	PREDR r1,xeof
back:	;search backwards
	cpy r3,r0
	MBTOWC r0,r9,r14,r15
	cpy r9,r11
	bool [r6+CT_EDFLAGS] ? BEF_GCAS, upr1
	if [r6+CT_EDFLAGS] ? BEF_ICAS
		TOLOWER r9
upr1:		TOUPPER r11
	endif
	sub r2,r10
	repeat
		bool r2=r12, prev
		cpy r2,r15
		;MBTOWC_LEFT r2,r8...
		clr r8
		dec r2
		cpy.b [r2],r14
		repeat
			asl 7,r8
			and $7F,r14
			add r14,r8
			dec r2
			breakif r2<=r12
			cpy.b [r2],r14
		until r14<$80
		inc r2
		;...END MBTOWC_LEFT
		sub r2,r15	;size of this char
		breakif r8=r11
	until r8=r9
	add r2,r10
	;now cmp...
	cpy r2,r14
	add r15,r2	;skip char (r10 unchanged)
	got cmp

next:	add r2,r10
	SUCCR r1,xeof
fwd:	;search forwards
	cpy r3,r0
	MBTOWC r0,r9,r14,r15
	cpy r9,r11
	bool [r6+CT_EDFLAGS] ? BEF_GCAS, upr2
	if [r6+CT_EDFLAGS] ? BEF_ICAS
		TOLOWER r9
upr2:		TOUPPER r11
	endif
	sub r2,r10
	repeat
		bool r2=r13, next
		cpy r2,r15
		MBTOWC r2,r8,r14,r12
		breakif r8=r11
	until r8=r9
	add r2,r10
	sub r2,r15
	neg r15		;size of this char
	cpy r2,r14
cmp:	;compare rest of string
	;r1=BB_, r2=text, r10=offset, r12=textstart, r13=textend+1
	;r0=string to find, r14=saved R2, r15=size of 1st char
	repeat
		MBTOWC r0,r8,r11,r9
		bool r8=0, found	;end of match str
		if r2=r13
			SUCCR r1,xeof
			clr r14 ;to say use GETR to get back
		endif
		sub r2,r15
		psh r15
		MBTOWC r2,r9,r11,r15
		pop r15
		add r2,r15
		;r10 preserved unincremented here
		cpy r8,r11
		bool [r6+CT_EDFLAGS] ? BEF_GCAS, cmpupr
		if [r6+CT_EDFLAGS] ? BEF_ICAS
			TOLOWER r8
cmpupr:			TOUPPER r11
			continueif r11=r9
		endif
	until r8!=r9
	cpy r14,r2
	if r14=0
		;already moved to another block - reseek
		GETR r10
	endif
	bool [r6+CT_EDFLAGS]?BEF_FWD, fwd
	got back

found:	;here with r10=offset, r15=size (in bytes) of found text
	;if fwd: one block too far right
	psh r15

	if [r6+CT_EDFLAGS]?BEF_FWD
		cpy r14,r2
		if r14=0
			;already moved to another block - reseek
			GETR r10
		endif
		MBLEFT r2	;go one left
	endif
	;here with r10=offset at which found
	MOVE r10

	pop r8
	clr r0
	ret

xeof:	;here if not found anywhere
	;do not move cursor, return not found message

	;cancel macro
	cpy [r6+CT_EDDATA],r0
	clr [r0+ED_MACSTRP]

	;return msg
	lea m1,r0
	clr r8
	ret

m1:	dc 'beep show not found',0

	toolend toolb
nodeend toolb

.end
