.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/LINE'

	;inputs
	;r0=ptr to prompt string
	;r8=character (ignored)
	;outputs
	;r0=line of text input
	;r8=flag (1 if input line was terminated by a tab, else 0)

	;note the editing on a line is fairly elementary.
	;it is probably better to construct an "edit" tool which permits
	;more elaboarate editing and use this in both this routine and
	;the shell line input.

	;line [+]<h><prompt>
	;where [+] is an optional + to indicate TAB terminate
	;<h> is a history buffer id (A,B,C...)
	;<prompt> is the prompt to request a line

	;e.g.
	;dk E272 fdo r +C Read File: 

	clr r14
	repeat
		cpy.b [r0],r8		;history buff id or + or space
		inc r0
		if r8='+'
			cpy 1,r14
			continue
		endif
	until r8!=' '

	bst BEF_SCUR,[r6+CT_EDFLAGS]

	psh r14
	qcall ED/SHOW	;show prompt
	pop r14

	cpy [r6+CT_EDDATA],r1
	add ED_STATUS,r1
	repeat
		cpy.b [r1],r8
		inc r1
	until r8=0
	dec r1

	;r1=end of prompt
	cpy r1,r0

	;here with r0=string start, r1=string end/current edit

lp2:	pshm r0,r1,r14
	qcall ED/KEYSTAT
	if r8=0
		qcall ED/DISP
	endif
	qcall ED/KEY
	popm r14,r1,r0

	bool r8=$A,ex1	;end of line?
	bool r8=$D,ex1	;end of line?
	bool r8=$9,tb1	;tab?
	bool r8=8,back
		;insert character
ins:	lea [r0+80],r2
	if r1<r2
		cpy.b r8,[r1]
		inc r1
		clr.b [r1]
	endif
	bst BEF_STAT,[r6+CT_EDFLAGS]
	got lp2

tb1:		;here if tab
	bool r14!=1,ins		;insert it
	cpy 1,r8			;treat it as special exit case
	got ex2

back:	if r1>r0
		dec r1
		clr.b [r1]
	endif
	bst BEF_STAT,[r6+CT_EDFLAGS]
	got lp2

ex1:	cpy 0,r8
ex2:	cpy [r6+CT_EDDATA],r1
	add ED_CMDSTR,r1
	cpy r1,r2
	psh r8

	cps r0,r2,r8

	bcr BEF_SCUR,[r6+CT_EDFLAGS]
	bst BEF_STAT,[r6+CT_EDFLAGS]
	cpy [r6+CT_EDDATA],r0
	clr [r0+ED_STATUS]

	cpy r1,r0			;cmdbuf
	qcall ED/DISP		;make sure displayed before exit
	pop r8
	ret

	toolend toolb
nodeend toolb

.end
