.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/LINEDRAW'

	;inputs
	;r0=ptr to string to show
	;outputs
	;r0="show"

	qcall ED/SHOW	;display status line

loop1:	qcall ED/KEYSTAT
	if r8=0
		qcall ED/DISP
	endif
	qcall ED/KEY
	bool r8=27,exi	;ESC => break
	bool r8=$E021,up
	bool r8=$E022,down
	bool r8=$E023,left
	bool r8=$E024,right
	qcall ED/BEEP
	got loop1

up:	gos ldup
	qcall ED/XCOL
	qcall ED/UP
	qcall ED/FILLXCOL
	gos lddown
	got loop1

down:	gos lddown
	qcall ED/XCOL
	qcall ED/DOWN
	qcall ED/FILLXCOL
	gos ldup
	got loop1

left:	gos ldleft
	qcall ED/LEFTNW
	gos ldright
	got loop1

right:	gos ldright
	qcall ED/RIGHT
	gos ldleft
	got loop1

exi:	lea mexit,r0
	ret

************ subroutines *************
*
* each take the current character and add on the graphic for the
* specified direction (up,down,right,left) and write it back
*
**************************************

ldup:	lea tablup,r0
	got ld1

lddown:	lea tabldown,r0
	got ld1

ldleft:	lea tablleft,r0
	got ld1

ldright:
	lea tablright,r0
ld1:	psh r0
	;get character
	qcall ED/RIGHT
	if r8!=0
		if r9!=EOL
			psh r9
			qcall ED/DELB
			pop r8
		else
			qcall ED/LEFT
			clr r8
		endif
	endif
	;mange char
	sub $2500,r8
	if.u r8>$50
		cpy $50,r8
	endif
	pop r0
	cpy.b [r0+r8],r8
	add $2500,r8
	;put char back
	qcall ED/INSL
	qcall ED/LEFT
	ret

mexit:	dc 'show',0	;erase status line

;each table is $51 chars long
;nb: $2504,5,6,7 are used for: centre to left,right,up,down
;ie. not whole lines but start or end.

tablup:
	dc $34, $34, $02, $02, $14, $18, $06, $02
	dc $34, $34, $02, $02, $1C, $1C, $1C, $1C
	dc $24, $24, $24, $24, $14, $14, $14, $14
	dc $18, $18, $18, $18, $1C, $1C, $1C, $1C
	dc $1C, $1C, $1C, $1C, $24, $24, $24, $24
	dc $24, $24, $24, $24, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $34, $34, $34, $34
	dc $34, $34, $34, $34, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $34, $34, $02, $02
	dc $06

tabldown:
	dc $2C, $2C, $02, $02, $0C, $10, $02, $07
	dc $2C, $2C, $02, $02, $0C, $0C, $0C, $0C
	dc $10, $10, $10, $10, $1C, $1C, $1C, $1C
	dc $24, $24, $24, $24, $1C, $1C, $1C, $1C
	dc $1C, $1C, $1C, $1C, $24, $24, $24, $24
	dc $24, $24, $24, $24, $2C, $2C, $2C, $2C
	dc $2C, $2C, $2C, $2C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $2C, $2C, $02, $02
	dc $07

tablright:
	dc $00, $00, $1C, $1C, $04, $00, $14, $0C
	dc $00, $00, $1C, $1C, $0C, $0C, $0C, $0C
	dc $2C, $2C, $2C, $2C, $14, $14, $14, $14
	dc $34, $34, $34, $34, $1C, $1C, $1C, $1C
	dc $1C, $1C, $1C, $1C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $2C, $2C, $2C, $2C
	dc $2C, $2C, $2C, $2C, $34, $34, $34, $34
	dc $34, $34, $34, $34, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $00, $00, $1C, $1C
	dc $04

tablleft:
	dc $00, $00, $24, $24, $00, $05, $18, $10
	dc $00, $00, $24, $24, $2C, $2C, $2C, $2C
	dc $10, $10, $10, $10, $34, $34, $34, $34
	dc $18, $18, $18, $18, $34, $34, $34, $34
	dc $3C, $3C, $3C, $3C, $24, $24, $24, $24
	dc $24, $24, $24, $24, $2C, $2C, $2C, $2C
	dc $2C, $2C, $2C, $2C, $34, $34, $34, $34
	dc $34, $34, $34, $34, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $3C, $3C, $3C, $3C
	dc $3C, $3C, $3C, $3C, $00, $00, $24, $24
	dc $05


	toolend toolb
nodeend toolb

.end
