********************************************
*
* ED MainInit
*
* Copyright (C) 1990-1994 by Andy HENSON
* All rights reserved
*
********************************************

.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/MAININIT'

	;input
	;r0=unused
	;r8=unused
	;returns
	;r0=NULL

	;input with EITHER:
	;ED_BUFLIST is NULL list - need to restore previous state, OR
	;ED_BUFLIST contians valid buffers setup.

	;and with EITHER:
	;ED_CURWIN=NULL - need to restore/create window, OR
	;ED_CURWIN+window list all setup.

	;and with EITHER:
	;ED_CMDSTR.i=0 - use ed/edini.ed, OR
	;ED_CMDSTR setup to a file to be USEd.

	cpy EF_REDI,[r6+CT_EDFLAGS]	;only flag is REDI
	clr [r6+CT_EDPREFIX]		;no prefixes

	;init vars
	cpy [r6+CT_EDDATA],r0
	clr [r0+ED_SPOSX]
	clr [r0+ED_SPOSY]
	clr [r0+ED_PASTEP]
	clr [r0+ED_MACSTRP]
	clr [r0+ED_MACSTRR]
	cpy $FFFF,[r0+ED_MACSTR]	;end of macro
	cpy.l $10201020102,[r0+ED_COLORS]

	;init screen size to DISPLAY size
	enquire 'DISPLAY',0
	if r8!=0
		qcall SERVER/DV_RAW
		if r8>0
			cpy [r1],r9
			cpy [r6+CT_EDDATA],r1
			cpy.l r8,[r1+ED_XMAX]
			freenode r0
		endif
	endif

	;init DK list
	cpy [r6+CT_EDDATA],r0
	add ED_DKLIST,r0
	initlist r0
	lea m2,r0	     		;add default ^X
	qcall ED/DK

	cpy [r6+CT_EDDATA],r3
	;init XR list
	add ED_XRLIST,r3
	initlist r3
	allocmem XR_SIZE
	bool r8=0, quitmem
	cpy r8,[r0+MN_BYTES]
	clr [r0+XR_EXT] ;default
	clr [r0+XR_WRAP]		;default no wrap
	cpy $20181008,[r0+XR_TABS]	;default 8 col tabs
	cpy $00383028,[r0+(XR_TABS+4)]
	addhead r3,r0,r1

	;buffer setup: restore state
	cpy [r6+CT_EDDATA],r0
	cpy [r0+ED_BUFLIST],r1
	if [r1+LN_SUCC]=0
		;no buffers on list:
		;need to restore buffers (and windows if poss)
		lea stat,r0
		lea mode,r1
		qcall LIB/FOPEN
		cpy r0,r2
		if r0!=0
			;restore all buffers/windows
			gos RESTORE
			cpy r2,r0
			qcall LIB/FCLOSE
		endif
	endif

	;buffer setup - if none present
	cpy [r6+CT_EDDATA],r0
	cpy [r0+ED_BUFLIST],r1
	if [r1+LN_SUCC]=0
		;need to set buffer since none created by "restore"
		;init code to create an initial buffer
		clr	r0
		qcall	ED/BUF/MAKE	;get new buffer
		bool	r0=NULL, quitmem

		cpy	[r6+CT_EDDATA],r1	;add to list
		add	ED_BUFLIST,r1
		addtail	r1,r0,r8	
	endif

	;window setup
	cpy [r6+CT_EDDATA],r3
	if [r3+ED_CURWIN]=0
		;need to set window: set just one on first buffer
		allocmem WH_SIZE
		bool r8=0, quitmem
		cpy r8,[r0+MN_BYTES]

		;init WH_
		cpy [r3+ED_BUFLIST],r1
		cpy [r1+BH_CURSOR],r8
		cpy [r1+BH_TOPCUR],r9
		cpy [r1+BH_RSCROLL],r10
		cpy r1,[r0+WH_BUFH]
		cpy r8,[r0+WH_CURSOR]
		cpy r9,[r0+WH_TOPCUR]
		cpy r10,[r0+WH_RSCROLL]
		clr [r0+WH_POSX]
		clr [r0+WH_POSY]
		clr [r0+WH_TURN]
		clr [r0+WH_WOB]
		clr [r0+WH_CHANGEF]
		cpy -1,[r0+WH_XCOL]
		
		;create list and add window to list
		cpy r0,[r3+ED_CURWIN]
		add ED_WINLIST,r3
		initlist r3
		addtail	r3,r0,r8	
	endif

	;initial "use"
	cpy	[r6+CT_EDDATA],r0
	add	ED_CMDSTR,r0
	if	[r0]=0
		lea	m1,r0
	endif
	qcall	ED/USE

quit:	ret

quitmem:	;here if no memory on init
	tracef 'no memory\n'
	ret

***************************************
* restore
***************************************

restore:	;restore buffers/windows
	;in r2=handle
	;r2 preserved

	cpy [r6+CT_EDDATA],r0
	add ED_SPOSX,r0
	cpy r2,r1
	cpy 8,r8
	cpy 1,r9
	qcall LIB/FREAD	;read file

	allocstruct 128,r7

restlp:		;as restore but 128 bytes alloc'd
	cpy r7,r0
	cpy r2,r1
	cpy 4,r8
	cpy 1,r9
	qcall LIB/FREAD	;read file
	cpy [r7],r9 ;word read
	bool r8=0, rquit ;EOF
	bool r9<0, rwindow
rbuffer:
	lea [r7+4],r0
	cpy r2,r1
	cpy 8,r8
	cpy 1,r9
	qcall LIB/FREAD ;get extra words
	lea [r7+12],r3
	cpy r2,r0
	repeat
		getc r0		;read filename (to NUL)
		cpy.b r8,[r3]
		inc r3
	until r8=0
	lea [r7+12],r0
	psh r2
	qcall ED/BUF/MAKE
	pop r2
	if r0!=NULL
		;add to list
		cpy [r6+CT_EDDATA],r1
		add ED_BUFLIST,r1
		addtail	r1,r0,r8
		add BH_CURSOR,r0
		cpy r7,r1
		cpy 12,r8
		cpb r1,r0,r8
	endif
	got restlp

rwindow:
	allocmem WH_SIZE
	if r8!=0
		cpy r8,[r0+MN_BYTES]
		;init WH_
		clr [r0+WH_TURN]
		clr [r0+WH_WOB]
		clr [r0+WH_CHANGEF]
		cpy -1,[r0+WH_XCOL]
		psh r0
		add WH_SAVEBI+4,r0
		cpy r2,r1
		cpy WH_SAVEEND-WH_SAVEBI-4,r8
		cpy 1,r9
		qcall LIB/FREAD ;get extra words
		pop r0

		;find buffer for WH_BUFH
		cpy [r6+CT_EDDATA],r3
		cpy [r7],r9	;index
		cpy [r3+ED_BUFLIST],r1
		repeat
			nextnode r1,r8
			inc r9
		until r9=0	;found
		cpy r8,[r0+WH_BUFH]

		;create list and add window to list
		cpy [r6+CT_EDDATA],r3
		add ED_WINLIST,r3
		if [r3+(ED_CURWIN-ED_WINLIST)]=0
			cpy r0,[r3+(ED_CURWIN-ED_WINLIST)]
			initlist r3
		endif
		addtail	r3,r0,r8	
	endif
	got restlp

rquit:	freestruct 128
	ret

*******************************************

;default setups
m1:	dc 'ed/edini.ed',0	;use
m2:	dc '^X quit',0		;dk
stat:	dc 'ED/EDSTAT.DAT',0
mode:	dc 'r',0

	toolend	toolb
nodeend	toolb

.end
