.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/QUIT'

	;inputs
	;r0=ptr to command string
	;r8=character (ignored)
	;outputs
	;r0=NULL

	;check buffers all saved
	cpy [r6+CT_EDDATA],r3
	cpy [r3+ED_BUFLIST],r3
	clr r10
	loop
		nextnode r3,r1
		cpy [r1+BH_CHANGEF],r8
		and 3,r8
		if r8!=0
			inc r10	;count
		endif
	endloop
	bool r10=0, doquit

	;some buffers have been changed and not saved
	cpy [r6+CT_EDDATA],r0
	lea exmenu,r1
	clr r8
	lcall r0,EL_MENU
	;0=yes(exit) 1/-1=no, 2=write
	or $20,r9
	bool r9='y',doquit
	bool r9='n',noquit
	bool r9='w',wrte

	bool r8=0, doquit
	bool r8!=2, noquit

wrte:	;must write
	qcall ED/SAVEALL,VIRTUAL

doquit:
	;save status info
	lea stat,r0
	lea mode,r1
	qcall LIB/FOPEN
	cpy r0,r2
	if r0!=0
		;write SPOSX/Y
		cpy [r6+CT_EDDATA],r0
		add ED_SPOSX,r0		
 		cpy 1,r8
 		cpy 8,r9
		cpy r2,r1
		qcall LIB/FWRITE	;write window record

		;write all buffers
		cpy [r6+CT_EDDATA],r3
		cpy [r3+ED_BUFLIST],r3
		loop
			nextnode r3,r1
			lea [r1+BH_CURSOR],r0
			add BH_NAME,r1
			repeat
				cpy.b [r1],r8
				inc r1
			until r8=0	;find string end
			cpy r1,r9
			sub r0,r9
			cpy 1,r8
			cpy r2,r1
			qcall LIB/FWRITE	;write buffer record
		endloop

		;write all windows
		cpy [r6+CT_EDDATA],r3
		cpy [r3+ED_WINLIST],r3
		loop
			nextnode r3,r0
			;now compute Buffer Index
			cpy [r0+WH_BUFH],r9	;looking for...
			cpy [r6+CT_EDDATA],r1
			cpy [r1+ED_BUFLIST],r1
			clr r10		;index so far
			repeat
				nextnode r1,r8
				dec r10		;index, decrements each loop
			until r8=r9
			add WH_SAVEBI,r0
			cpy r10,[r0]
			cpy 1,r8
			cpy (WH_SAVEEND-WH_SAVEBI),r9
			cpy r2,r1
			qcall LIB/FWRITE	;write window record
		endloop
		cpy r2,r0
		qcall LIB/FCLOSE
	endif

	;check all saved
	;qcall LIB/SYNC

	;now exit
	bst BEF_QUIT,[r6+CT_EDFLAGS]
noquit:	bst BEF_REDI,[r6+CT_EDFLAGS]
	cpy [r6+CT_EDDATA],r0
	lcall r0,EL_DISP
	clr r0
	ret

stat:	dc 'ED/EDSTAT.DAT',0
mode:	dc 'w',0

exmenu:	dc 'Buffers not saved - Exit?',0,'Yes',0,'No',0,'Write',0,0

	toolend toolb
nodeend toolb

.end

