.include 'tao'
.include 'ed/ed'

node toolb,TOOLTP,VP,TEMPLATE
	tool 'ED/SELBUF'

	;inputs
	;r0=ptr to command string
	;r8=character (ignored)
	;outputs
	;r0 preserved

	psh	r0

	;sync window & buffer cursor ptrs
	cpy	[r6+CT_EDDATA],r0
	cpy	[r0+ED_CURWIN],r0
	cpy	[r0+WH_BUFH],r1
	cpy r1,r10				;Save pointer to current buffer
	cpy	[r0+WH_RSCROLL],r8
	cpy	r8,[r1+BH_RSCROLL]
	cpy	[r0+WH_TOPCUR],r8
	cpy	r8,[r1+BH_TOPCUR]

	;Find current buffer
	clr r12
	clr r11
	cpy	[r6+CT_EDDATA],r0
	lea	[r0+ED_BUFLIST],r1
	loop
		succ r1,r1	;Get next buffer
		breakif [r1]=0
		if r1=r10
			cpy r11,r12
		endif
		inc r11
	endloop

	;Allocate memory for string buffer
	allocmem 4096+12
	bool r8=0,out
	cpy r8,[r0+MN_BYTES]
	cpy r0,r2
	clr r13					;Clear space line count
try2:	add 12,r0
	lea titlestr,r1
	cps r1,r0,r8
	inc r0
	psh r0
	cpy	[r6+CT_EDDATA],r0
	lea	[r0+ED_BUFLIST],r1
	pop r0

	;r1 = List header of buffer lists

	clr r11				;Loop counter

	loop
		succ r1,r1	;Get next buffer
		breakif [r1]=0
		lea [r1+BH_NAME],r3

		;Check that name will fit within buffer
		pshm r0,r3
		cps r3,r3,r8
		sub r2,r0
		add r8,r0
		sub 10,r0
		if r0>=4096
			tracef "too long.......\n"
			popm r3,r0
			cpy -1,r8
			got out1
		endif
		popm r3,r0

		cpy [r1+BH_CHANGEF],r8
		or 4,r8
		if r8=4
			cpy.b ' ',r8
		else
			cpy.b '*',r8
		endif
		cpy.b r8,[r0]
		cpy.b ' ',[r0+1]
		add 2,r0
		cps r3,r0,r8
		inc r0
	endloop

	if r13!=0
		pshm r12,r2,r0
		bst BEF_STAT,[r6+CT_EDFLAGS]
		qcall ED/DISP
		bst BEF_REDI,[r6+CT_EDFLAGS]
		bcr BEF_STAT,[r6+CT_EDFLAGS]
		qcall ED/DISP
		clr r13
		popm r0,r2,r12
	endif

	cpy.b 0,[r0]	;Terminate list with a nul char
	cpy r2,r1
	add 12,r1
	cpy [r6+CT_EDDATA],r0
	pshm r2,r13

	;Display instructions on status line
	pshm r0,r1,r12
	cpy [r6+CT_EDDATA],r0
	add ED_STATUS,r0
	lea statusline,r1
	cps r1,r0,r8
	bst BEF_STAT,[r6+CT_EDFLAGS]
	qcall ED/DISP
	popm r12,r1,r0

	cpy r12,r8
	lcall r0,EL_MENU
	cpy r8,r12
	popm r13,r2
	cpy r2,r0
	bool r9=$1B,out
	bool r9=$A,out1
	or $20,r9
	bool r9='c',close
	bool r9='w',writ
	got try2

out1:	psh r8
	freenode r2
	pop r8
	bool r8<0,out

	cpy	[r6+CT_EDDATA],r0
	lea	[r0+ED_BUFLIST],r1

	loop
		succ r1,r1	;Get next buffer pointer
		breakif r8=0
		dec r8
	endloop

	;Copy pointer BH_ of selected buffer into [r0+WH_BUFH]
	cpy	[r6+CT_EDDATA],r0
	cpy	[r0+ED_CURWIN],r0
	cpy r1,[r0+WH_BUFH]

out:	;sync window & buffer cursor ptrs
	cpy	[r6+CT_EDDATA],r0
	cpy	[r0+ED_CURWIN],r0
	cpy	[r0+WH_BUFH],r1
	cpy	[r1+BH_CURSOR],r8
	cpy	r8,[r0+WH_CURSOR]
	cpy	[r1+BH_RSCROLL],r8
	cpy	r8,[r0+WH_RSCROLL]
	cpy	[r1+BH_TOPCUR],r8
	cpy	r8,[r0+WH_TOPCUR]

	;display file name
	cpy [r6+CT_EDDATA],r0
	add ED_STATUS,r0
	cpy [r1+BH_CHANGEF],r8
	and 3,r8
	if r8!=0
		cpy.b '*',[r0]
		inc r0
	endif
	add BH_NAME,r1
	cps r1,r0,r8

	bst BEF_STAT,[r6+CT_EDFLAGS]
	qcall ED/DISP
	bcr BEF_STAT,[r6+CT_EDFLAGS]
	qcall ED/REDISP
	qcall ED/DISP

	pop	r0
	ret

close:	;Preserve r2, decrement r12
	pshm r2,r12
	cpy	[r6+CT_EDDATA],r0
	lea	[r0+ED_BUFLIST],r1

	loop
		succ r1,r1	;Get next buffer pointer
		breakif r8=0
		dec r8
	endloop

	;Copy pointer BH_ of selected buffer into [r0+WH_BUFH]
	cpy	[r6+CT_EDDATA],r0
	cpy	[r0+ED_CURWIN],r0
	cpy r1,[r0+WH_BUFH]

	qcall ED/CLOSE
	popm r12,r2
	dec r12
	if r12<0
		cpy 0,r12
	endif
	cpy r2,r0
	inc r13
	got try2
	
writ:	;Preserve r12,r2
	pshm r2,r12
	cpy	[r6+CT_EDDATA],r0
	lea	[r0+ED_BUFLIST],r1

	loop
		succ r1,r1	;Get next buffer pointer
		breakif r8=0
		dec r8
	endloop

	;Copy pointer BH_ of selected buffer into [r0+WH_BUFH]
	cpy	[r6+CT_EDDATA],r0
	cpy	[r0+ED_CURWIN],r0
	cpy r1,[r0+WH_BUFH]

	qcall ED/SAVE
	popm r12,r2
	clr r13
	cpy r2,r0
	got try2

statusline:	dc 'c=Close, w=Write, ret=Select, esc=Escape',0
titlestr:	dc 'Select buffer',0

	toolend toolb
nodeend toolb

.end
