.include 'tao.inc'

tet_x=10 ;width of tetros area (left)
tet_y=25 ;height
tet_s=16 ;total width including stack on right

tet_queue_size=256
one_second=1000000/64
buttonsize=16

;data structure (usually r3)
structure
	struct tetros_node,mn_size
	;bytemap of the blocks (stride * y bytes)
	struct tetros_map,tet_s*tet_y
	;a number of pre-defined order
	struct tetros_queue,tet_queue_size*4
	int32 tetros_queue_out
	;parameters of current tetroid
	int32 tetros_x
	int32 tetros_y
	int32 tetros_angle
	pointer tetros_tetroid
	;timing parameters
	int32 tetros_tick
	int32 tetros_tick_interval
	;goodbye farewell,so long if this is non-zero
	int32 tetros_death
	;close button handle
	pointer tetclose
size tetros_size

CT_WINDOW=CT_USER1
CT_TETROS=CT_USER2
CT_R7=CT_USER3

node tetproc,CONTROLTP,0,TEMPLATE|GUI
	control 0,3000,MOUSETP|RESIZETP|KEYBOARDTP|REFRESHTP,0,0,0,0
	component cttool1-tetproc
	compend
	tstring cttool1,'GAMES/TETROS/TETROS'
nodeend tetproc

node tl_tetros,TOOLTP,VP,TEMPLATE
	tool 'GAMES/TETROS/TETROS'
	;inputs
	;r6=control object pointer

	clr [r6+CT_WINDOW]
	clr [r6+CT_TETROS]
	cpy r7,[r6+CT_R7]

	;open local window
	cpy CENTER,r10
	cpy 243,r11
	cpy 385,r12
	qcall CLASS/LWINDOW
	if r0=0
		ret
	endif
	cpy r0,[r6+CT_WINDOW]
	
	;make the global data structure
	allocmem tetros_size
	bool r8=0,mem_error
	cpy r8,[r0+MN_BYTES]
	cpy r0,[r6+CT_TETROS]

	;set up the time parameters
	cpy one_second/2,[r0+tetros_tick_interval]
	gettime r8
	add one_second/2,r8
	cpy r8,[r0+tetros_tick]

	;generate a number of random tetroids
	lea [r0+tetros_queue],r1
	lea tetroids,r2
	add $aaaaaaaa,r8
	forsp tet_queue_size
		if r8!?0
			lsr 1,r8
			xor $a3000000,r8
		else
			lsr 1,r8
		endif
		cpy r8,r10
		and 7,r10
		mul 4*9,r10
		add r2,r10
		cpy r10,[r1]
		add 4,r1
	nextsp
	cpy 0,[r0+tetros_queue_out]
	cpy 0,[r0+tetros_death]

	;clear the map
	add tetros_map,r0
	cpy 0,r8
	cpy tet_s*tet_y,r9
	qcall LIB/MEMSET

	;generate a new tetroid at the top of the screen
	gos new_tetroid

	;plot everything based on the tetroid map
	gos reset_clip
	gos repaint

	;main game loop
	loop
		;be sociable by descheduleing. Check the mailbox to see if anyone
		;has sent us a message
		tao DESCHEDULE
		testmymail REFRESHTP|MOUSETP|RESIZETP|KEYBOARDTP

		;what sort of message have we got?
		if r8=RESIZETP
			cpy 83,r8
			cpy 135,r9
			cpy 0,r10
			cpy 243,r11
			cpy 385,r12
			cpy 0,r13
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_RESIZE
			if r8!=0
				;resize ok
				cpy [r6+CT_WINDOW],r0
				clr r1
				lcall r0,WN_CLRGOB
				gos reset_clip
				gos repaint
			endif
		elseif r8=REFRESHTP
			;update the window
			cpy [r6+CT_WINDOW],r0
			lcall r0,WN_UPDATE
		elseif r8=MOUSETP
			;click from mouse
			readmymail r8
			cpy [r1+MO_RX],r13
			cpy [r1+MO_RY],r14
			cpy [r1+MO_BUTTON],r15
			freenode r0

			;quit if right hand button
			bool r15=MB_RIGHT,error_exit

			;quit if left click on close button
			if r15=MB_LEFT
				cpy r13,r8
				cpy r14,r9
				cpy 1,r11
				cpy 1,r12
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_HITGOB
				cpy [r6+CT_TETROS],r0
				bool r1=[r0+tetclose],error_exit
			endif
		elseif r8=KEYBOARDTP
			;interpret key codes.  codes are duplicated in case num lock
			;is pressed.  check_move handles down,left,right and spin
			readmymail r8
			cpy.s [r1+8],r8
			cpy 0,r10
			cpy 0,r11
			cpy 0,r12
			;spin?
			if r8='8'
				cpy 1,r10
				gos check_move
			;space bar
			elseif r8=' '
				cpy 1,r10
				gos check_move
			;up arrow
			elseif r8=$e021
				cpy 1,r10
				gos check_move
			;left?
			elseif r8='4'
				cpy -1,r11
				gos check_move
			;left arrow
			elseif r8=$e023
				cpy -1,r11
				gos check_move
			;right?
			elseif r8='6'
				cpy 1,r11
				gos check_move
			;right arrow
			elseif r8=$e024
				cpy 1,r11
				gos check_move
			;drop to your doom?
			elseif r8='2'
				cpy 1,r12
				gos check_move
			;down arrow
			elseif r8=$e022
				cpy 1,r12
				gos check_move
			endif
			freenode r0
		elseif r8!=0
			;some other odd message. (paranoid mode)
			readmymail r8
			freenode r0
		else
			;no messages,every few moments move down
			gettime r8
			cpy [r6+CT_TETROS],r3
			if r8 >= [r3+tetros_tick]
				;shorten the time taken for next move down
				cpy [r3+tetros_tick_interval],r8
				add r8,[r3+tetros_tick]
				mul 2047,r8
				lsr 11,r8
				cpy r8,[r3+tetros_tick_interval]
				gos do_tick

				;update the window
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_UPDATE
			endif
		endif

		;see if we died
		cpy [r6+CT_TETROS],r3
		breakif [r3+tetros_death]!=0
	endloop

	delay one_second*3

;clean up and quit
error_exit:
	cpy [r6+CT_WINDOW],r0
	if r0!=0
		lcall r0,WN_CLOSE
	endif
	cpy [r6+CT_TETROS],r0
	if r0!=0
		freenode r0
	endif
	ret

;cheapskate!
mem_error:
	cpy [r6+CT_R7],r7
	got error_exit

;set clip region, title bar and close button
reset_clip:
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_GETCLIP
	add buttonsize,r9
	pshm r8,r11
	lcall r0,WN_SETCLIP
	popm r11,r8
	cpy 4,r9
	cpy buttonsize,r12
	add r12,r8
	sub r8,r11
	lea tettitle,r1
	cpy [r6+CT_WINDOW],r0
	qcall GOB/CUITITLE
	cpy 4,r8
	cpy r8,r9
	cpy buttonsize,r11
	cpy r11,r12
	cpy [r6+CT_WINDOW],r0
	qcall GOB/CUICLOSE
	cpy [r6+CT_TETROS],r1
	cpy r0,[r1+tetclose]
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_INFO
	clr r8
	clr r9
	cpy 4,r13
	qcall GOB/CUIBORDER
	ret

;create a new tetroid at the top of the window
new_tetroid:
	cpy [r6+CT_TETROS],r3

	;check for completed lines of blocks
	lea [r3+tetros_map],r1
	forsp tet_y
		cpy r1,r2
		cpy 0,r8
		for tet_x,r10
			cpy.b [r2],r9
			inc r2
			if r9!=0
				inc r8
			endif
		next r10

		;if we have all tet_x blocks full,zap the line
		if r8=tet_x
			;first blast the blocks away
			cpy r1,r2
			for tet_x,r10
				cpy.b 0,[r2]
				inc r2
			next r10
			pshm r1
				gos repaint
				delay one_second/2
				add one_second/2,[r3+tetros_tick]
			popm r1

			;then shuffle the blocks down
			cpy r1,r2
			lea [r3+(tetros_map+tet_s)],r9
			while r2 > r9
				for tet_x,r10
					cpy.b [r2-tet_s],r8
					cpy.b r8,[r2]
					inc r2
				next r10
				sub tet_s+tet_x,r2
			endwhile
			pshm r0,r1
				gos repaint
				delay one_second/2
				add one_second/2,[r3+tetros_tick]

				;flush any key messages
				loop
					testmymail KEYBOARDTP
					breakif r8=0
					readmymail r8
					freenode r0
				endloop
			popm r1,r0
		endif
		add tet_s,r1
	nextsp

	;clear the list on the right
	lea [r3+tetros_map],r1
	forsp tet_y
		cpy.b 0,[r1+(tet_s-1)]
		cpy.b 0,[r1+(tet_s-2)]
		cpy.b 0,[r1+(tet_s-3)]
		cpy.b 0,[r1+(tet_s-4)]
		add tet_s,r1
	nextsp

	;rebuild the list on the right in the bytemap
	cpy 2,r12
	cpy [r3+tetros_queue_out],r8
	cpy 0,[r3+tetros_angle]
	cpy tet_s-2,[r3+tetros_x]
	forsp tet_y/3
		cpy r12,[r3+tetros_y]
		add 4,r8
		and ((tet_queue_size-1)*4),r8
		cpy [r3+r8+tetros_queue],r1
		cpy r1,[r3+tetros_tetroid]
		pshm r8,r12
			gos paint_tetroid
		popm r12,r8
		add 3,r12
	nextsp

	;get the latest tetroid in the queue
	cpy [r3+tetros_queue_out],r8
	cpy [r3+r8+tetros_queue],r1
	add 4,r8
	and ((tet_queue_size-1)*4),r8
	cpy r8,[r3+tetros_queue_out]
	cpy 0,[r3+tetros_angle]
	cpy tet_x/2,[r3+tetros_x]
	cpy 2,[r3+tetros_y]
	cpy r1,[r3+tetros_tetroid]

	;make sure it doesn't go bang on the first move
	cpy [r3+tetros_angle],r10
	cpy [r3+tetros_x],r11
	cpy [r3+tetros_y],r12
	gos try_collisions
	if r15=1
		;wollop! your'e dead mate
		cpy 1,[r3+tetros_death]
	else
		gos paint_tetroid
	endif
	ret

;move down (pretty much the same as hitting the down key)
do_tick:
	cpy [r6+CT_TETROS],r3
	cpy 0,r10
	cpy 0,r11
	cpy 1,r12
	gos check_move
	ret

;check a new tetroid position so see if its ok
check_move:
	pshm r0
		pshm r10,r11,r12
			gos unpaint_tetroid
		popm r12,r11,r10
		add [r3+tetros_angle],r10
		and 3,r10
		add [r3+tetros_x],r11
		add [r3+tetros_y],r12
		gos try_collisions
		if r15=0
			;no collisions,just paint
			cpy r10,[r3+tetros_angle]
			cpy r11,[r3+tetros_x]
			cpy r12,[r3+tetros_y]
			gos paint_tetroid
			gos repaint
		elseif r15=1
			;sticky collision,leave it there and start a new tetroid
			gos paint_tetroid
			gos new_tetroid
		elseif r15=2
			;slide off side smoothly
			gos paint_tetroid
		endif
	popm r0
	ret

;use the tetros_x,y,angle,pointer parameters to plot a tetroid in the bytemap
paint_tetroid:
	cpy [r6+CT_TETROS],r3
	cpy [r3+tetros_tetroid],r1
	cpy [r1],r15
	add 4,r1
	cpy [r3+tetros_angle],r10
	cpy [r3+tetros_x],r11
	cpy [r3+tetros_y],r12
	forsp 4
		gos get_tet
		mul tet_s,r9
		add r9,r8
		cpy.b r15,[r3+r8+tetros_map]
	nextsp
	ret

;blank out the old tetroid before moving
unpaint_tetroid:
	cpy [r6+CT_TETROS],r3
	cpy [r3+tetros_tetroid],r1
	add 4,r1
	cpy [r3+tetros_angle],r10
	cpy [r3+tetros_x],r11
	cpy [r3+tetros_y],r12
	forsp 4
		gos get_tet
		mul tet_s,r9
		add r9,r8
		cpy.b 0,[r3+r8+tetros_map]
	nextsp
	ret

;check a new position to see if it collides
try_collisions:
	cpy [r6+CT_TETROS],r3
	cpy [r3+tetros_tetroid],r1
	add 4,r1
	cpy 0,r15
	for 4,r14
		gos get_tet
		bool r8 < 0,dont_move
		bool r9 < 0,dont_move
		bool r8 >= tet_x,dont_move
		bool r9 >= tet_y,stick_move
		mul tet_s,r9
		add r9,r8
		cpy.b [r3+r8+tetros_map],r15
		bool r15!=0,stick_move
	next r14
	cpy 0,r15
	ret
;sticky collision (other tetroids,the bottom)
stick_move:
	cpy 1,r15
	ret
;smooth collision (the sides)
dont_move:
	cpy 2,r15
	ret

;support routine for paint_tetroid,unpaint_tetroid etc
get_tet:
	cpy [r1+0],r8
	cpy [r1+4],r9
	add 8,r1
	if r10=1
		neg r8
		exg r8,r9
	elseif r10=2
		neg r8
		neg r9
	elseif r10=3
		exg r8,r9
		neg r8
	endif
	add r11,r8
	add r12,r9
	ret

;transfer the map to the window
repaint:
	;clear the clip area of the window
	cpy [r6+CT_WINDOW],r0
	lcall r0,WN_CLPCLR
	cpy [r6+CT_TETROS],r3

	;calculate the basic block size based on the window clip area
	cpy [r0+BM_CLIPX1],r11
	sub [r0+BM_CLIPX],r11
	sub 10,r11
	div tet_s,r11
	cpy [r0+BM_CLIPY1],r12
	sub [r0+BM_CLIPY],r12
	sub 10,r12
	div tet_y,r12
	if r11 < r12
		cpy r11,r12
	else
		cpy r12,r11
	endif

	;draw left hand boundary
	pshm r11,r12
		mul tet_x,r11
		mul tet_y,r12
		add 7,r11
		add 7,r12
		cpy [r0+BM_CLIPX],r8
		cpy [r0+BM_CLIPY],r9
		add 2,r8
		add 2,r9
		cpy WHITE,r10
		pshm r3
			lcall r0,WN_BOX
		popm r3
	popm r12,r11

	;draw right hand boundary
	pshm r11,r12
		cpy r11,r8
		mul tet_s-4,r8
		mul 4,r11
		mul tet_y,r12
		add 7,r11
		add 7,r12
		add [r0+BM_CLIPX],r8
		cpy [r0+BM_CLIPY],r9
		add 2,r8
		add 2,r9
		cpy WHITE,r10
		pshm r3
			lcall r0,WN_BOX
		popm r3
	popm r12,r11

	;draw the bytemap
	cpy [r6+CT_WINDOW],r0
	lea [r3+tetros_map],r1
	cpy [r0+BM_CLIPY],r9
	add 5,r9
	forsp tet_y
		cpy [r0+BM_CLIPX],r8
		add 5,r8
		forsp tet_s
			cpy.b [r1],r10
			inc r1
			if r10!=0
				lea [r8+r11],r13
				if r13 < [r0+BM_CLIPX1]
					lea [r9+r12],r13
					if r13 < [r0+BM_CLIPY1]
						pshm r1,r3,r8,r9,r10,r11,r12
							lcall r0,WN_FBOX
						popm r12,r11,r10,r9,r8,r3,r1
					endif
				endif
			endif
			add r11,r8
		nextsp
		add r12,r9
	nextsp

	;update the window
	pshm r3
		cpy [r6+CT_WINDOW],r0
		lcall r0,WN_UPDATE
	popm r3
	ret

	string tettitle,'Tetros'

;colours and shapes of tetroids in x,y coordinates
	even
tetroids:
	dc.i RED,-2,0,-1,0,0,0,1,0
	dc.i GREEN,-1,0,0,0,1,0,1,1
	dc.i BLUE,-1,0,0,0,1,0,1,-1
	dc.i MAGENTA,0,-1,0,0,1,0,1,1
	dc.i YELLOW,0,1,0,0,1,0,1,-1
	dc.i CYAN,-1,0,0,0,0,1,1,0
	dc.i GREEN,-1,0,0,0,0,-1,1,0
	dc.i RED,0,1,0,0,1,0,1,1

	toolend tl_tetros
nodeend tl_tetros

.end
