*Hyperlink equates
*command bits from gob to parent

HP_QUIT	=	0
HP_GOTO	=	1

HP_BUTTON	=	1
HP_RBUTTON	=	2
HP_GRAPHIC	=	4
HP_TEXT	=	8
HP_SLIDER	=	16


GB_USER5	=	GB_USER4+4
GB_USER6	=	GB_USER5+4
GB_USER7	=	GB_USER6+4
**********
*offsets from control obj
STACKBASE	=	CT_USER1
CLICK_XY	=	CT_USER2
COMMAND	=	CT_USER3
DATA	=	CT_USER4

**********
*macro to allow correct addressing of both local and global variables
*local variables are held as ones complement and addressed off compspace
*globals are true offsets and addressed off stackbase

*macro returns pointer to variable
*only works from gobs
.macro	HPADDR	;R6 offset,dest reg
	cpy	[r6+GB_PARENT],%2
	cpy	[%2+BM_CONTROL],%2	;point to control obj

	tst	[r6+%1]
	bmi	%L_do_loc

	cpy	[%2+STACKBASE],%2
	add	[r6+%1],%2
	got	%Ldoneaddr

%L_do_loc:	psh	r15		;index embedded vars
	add	ND_SIZE,%2
	add	[%2+CP_VEC],%2
	add	[%2+CP_VEC],%2	;2nd comp
	add	CP_SIZE,%2
	cpy	[r6+%1],r15
	not	r15
	add	r15,%2
	pop	r15
%Ldoneaddr:
.endm
***
*saves var-stacktop for global variables or var for locals
.macro	HPOFFSET	;variable name

.if	?DEF(l_$$$$%1)=TRUE
	dc.i	l_$$$$%1
.else
	dc.i	%1-stacktop
.endif
.endm
**********
*Hyperlink macros

.macro	frame
	even
%1:
.endm
.macro	frameend
	dc.i	0
.endm
**
*definition of button
*x,y,width,height,depth,col,buttonstext,actiontool,actiondata

.macro	button
%La:	dc.i	%Lb-%La	      	;size
	dc.i	HP_BUTTON,%1,%2,%3,%4,%5,%6*65536
	HPOFFSET	%7
.ifnb	%8
	dc.i	%8-stacktop
.ifnb	%9
	HPOFFSET	%9
.else
	dc.i	0
.endif
.else
	dc.i	nulltool-stacktop,0
.endif
%Lb:
.endm
*
**
*definition of radio button
*x,y,width,height,depth,col,hilite flag,hilite data,id,state,buttonstext,actiontool,actiondata
*hilite flag=0 for hilite colour or 1 for hilite depth
*id=unique 4 byte id for this button
*state is address of status variable which holds current button

rbhi_col	=	0	;hilight=colour
rbhi_dep	=	1	;hilight=depth

.macro	rbutton
%La:	dc.i	%Lb-%La	      	;size
	dc.i	HP_RBUTTON,%1,%2,%3,%4,%5,%6*65536+%7,%8*65536+32768
	dc.i	%9
	HPOFFSET	%10
	dc.i	%11-stacktop
.ifnb	%12
	dc.i	%12-stacktop
.ifnb	%13
	HPOFFSET	%13
.else
	dc.i	0
.endif
.else
	dc.i	nulltool-stacktop,0
.endif
%Lb:
.endm
*
****
*definition of slider
*x,y,width,height,depth,col,slider_val_VARIABLE,min,max,actiontool,actiondata

.macro	slider
%La:	dc.i	%Lb-%La	      	;size
	dc.i	HP_SLIDER,%1,%2,%3,%4,%5,%6*65536
	HPOFFSET	%7
	dc.i	%8,%9		;min,max
.ifnb	%10
	dc.i	%10-stacktop
.ifnb	%11
	HPOFFSET	%11
.else
	dc.i	0
.endif
.else
	dc.i	nulltool-stacktop,0
.endif
%Lb:
.endm
*
********
*definition of graphic
*x,y,blitmode,graphictool,actiontool,actiondata
*flags is 16 bit

.macro	graphic
%La:	dc.i	%Lb-%La	      	;size
	dc.i	HP_GRAPHIC,%1,%2,%3
	dc.i	%4-stacktop
.ifnb	%5
	dc.i	%5-stacktop
.ifnb	%6
	dc.i	%6-stacktop
.else
	dc.i	0
.endif
.else
	dc.i	nulltool-stacktop,0
.endif
%Lb:
.endm
********
*definition of text
*x,y,width,height,col,text,actiontool,actiondata
*flags is 16 bit

.macro	text
%La:	dc.i	%Lb-%La	      	;size
	dc.i	HP_TEXT,%1,%2,%3,%4,%5*65536
	dc.i	%6-stacktop

.ifnb	%7
	dc.i	%7-stacktop
.ifnb	%8
	dc.i	%8-stacktop
.else
	dc.i	0
.endif
.else
	dc.i	nulltool-stacktop,0
.endif
%Lb:
.endm
************************
*Macros to support local variables

.macro	hpvar	;label,contents
.if	?def(hpcount)=FALSE
hpcount	:=	0
.endif

l_$$$$%1	=	~hpcount
EVAL	hpcount
.if	"%2{1,1}"="'"		;for reversal of strings
varcont%E	=	'%2{5,1}%2{4,1}%2{3,1}%2{2,1}'
.else
varcont%E	=	%2
.endif
hpcount	:=	hpcount+4
.endm
*****

.macro	insertvars
ivcount	:=	0
rept	(hpcount/4)
EVAL	ivcount
	dc.i	varcont%E
ivcount	:=	ivcount+4
.endm
.endm

************************
*Startup stuff for stacks
*macro takes title and bitmap size as parameters
noquit	=	1

.macro	initstack	;'title',bitmap_width,bitmap_height,[noquit]
	check	%N>=3

*stack control
	node	hyperproc,CONTROLTP,0,TEMPLATE|GUI	;hyper control template
	control	NULL,1024,MOUSETP|REFRESHTP,NULL,NULL,NULL,NULL

*system stuff, rmb flag, col pal
sysvars:	dc.i	sysvarse-sysvars	;offset to next component
	dc.i	NULL		;code vector
.ifb	%4
	dc.i	0
.else
	dc.i	%4		;rmb flag (1=no quit)
.endif
;	blk.i	80,0
	dc.i	sysvarse-sysvars	 ;offset to last component
sysvarse:

.if	?def(hpcount)=TRUE
qhpvars:	dc.i	qhpvarse-qhpvars	;offset to next component
	dc.i	NULL		;code vector
	insertvars
	dc.i	qhpvarse-qhpvars	 ;offset to last component
qhpvarse:
.endif

	component	hymtd2-hyperproc
	component	hymtd3-hyperproc
	compend

	node	hyperw,BITMAPTP,0,TEMPLATE|NOFREE|CENTER		;window object
	bitmap	hymthd1-hyperw,0,0,%2,%3,NULL,NULL,NULL,NULL
	sublist	hymthd3-hyperw
	component	hymthd7-hyperw
	compend
	tstring	hymthd1,'GUI/BM_CLOSE'
	tstring	hymthd3,'TAO/SL_LIST'
	tstring	hymthd7,'GUI/PH_BLIT'
	nodeend	hyperw

	tstring	hymtd2,%1{1,99U}
	tstring	hymtd3,'HYPER/HP_F_MGR'
	nodeend	hyperproc

**********
*stack tool
	node	tl_teststack,TOOLTP,VP,TEMPLATE	;tool object
	tool	%1

*encapsulated Hyperlink stack tool
*stuffs start address into STACKBASE

	lea	stacktop,r1
	cpy	r1,[r6+STACKBASE]
	ret
	even
stacktop:

.endm

.macro	endstack

	string	goto,'HYPER/ACTION/GOTO'
	string	quit,'HYPER/ACTION/QUIT'
	string	nulltool,'TAO/NULL'
	string	run,'HYPER/ACTION/RUN_CTL'
	string	multi,'HYPER/ACTION/MULTI'
	string	send_i,'HYPER/ACTION/SEND_I'

	toolend	tl_teststack
	nodeend	tl_teststack
.endm

.macro	multilist
	check	%N>1
	rept	%N
	HPOFFSET	%1
	mshift
	.endm
.if	%N/2=(%N+1)/2
	dc.i	0
.else
	dc.i	0,0
.endif

.endm

