;
; AS 16/11/91
; AS 5/2/93 strtoksave initialised to point to a null, not null
;
; pointer to block 'malloc'ed by ARGCARGV containing global
; variables for 'C'.
;
	structure
	struct	memlist,LH_SIZE	;list header for memblocks
	struct	filelist,LH_SIZE	;list header for openfiles
	struct	exitlist,LH_SIZE	;list header for atexit
	pointer	stackref		;stack reference
	int32	starttime		;processor clock at start
	pointer	timestring		;pointer to time string
	pointer	tmstruct		;pointer to time structure
	pointer	strtoksave		;strtok string pointer
	int64	randseed		;rand no generator seed
	pointer	tmpnamp		;pointer to tmpnam buffer
	size	GLOB_SIZE
;
; define initial global variable values used by library tools
; when defining a new global variable, define its initial value here
; and re-assemble the whole of LIB/*.ASM
; (currently used by LIB/INIT, LIB/ARGCARGV and the macro openlib)
macro	initglobs
	cpy	r0,[r6+CT_STDIO]	;save start of block
	cpy	r3,[r0+stackref]	;save stack ref
;
; initialise all pointers to show blocks not yet MALLOCed
	cpy	NULL,[r0+timestring]	;no time string buffer yet
	cpy	NULL,[r0+tmstruct]	;no time structure buffer yet
	lea	[r6+ND_NULL],r8
	cpy	r8,[r0+strtoksave]	;pointer used by strtok
	cpy	NULL,[r0+tmpnamp]	;no tmpnam buffer
;
; initialise int32 and int64 variables to required constant value
	cpy.l	1,[r0+randseed]	;random no seed
;
; initialise the process start time in ticks
	tao	GETTIME		;read processor clock
	cpy	r8,[r0+starttime]	;save 
endm
;
; macro's to enable use of C library without using STDIO
;
macro	openlib
	allocstruct GLOB_SIZE,r7

	lea	[r7+exitlist],r0
	initlist	r0
	lea	[r7+filelist],r0
	initlist	r0
	lea	[r7+memlist],r0
	initlist	r0

	cpy	r7,r3		;stack reference
	initglobs			;initialise all globals
endm

macro	closelib
	lea	[r7+memlist],r0
	dumplist	r0		;dumps all blocks malloc'ed

	cpy	[r7+(filelist+LH_HEAD)],r8	;get lookahead reg
%loopf:	succnode	r8,r0,breakf%l
	cpy	r0,r1
	remove	r1,r2	;remove file* from list
	psh	r8
	lcall	r0,FP_CLOSE	;calls file* destructor
	pop	r8
	got	%loopf
breakf%l:
	freestruct	GLOB_SIZE
endm

;Equates

L_tmpnam	=	128
