.include 'tao'
.include 'pworld/pworld'

structure CT_USER1
int32 CT_WINDOW
int32 CT_CBUTTON
int32 CT_BORDER
int32 CT_BORDERSIZE
int32 CT_BUTTONSIZE
int32 CT_FACEBUTTON
int32 CT_PIXELBUTTON
int32 CT_BOTHBUTTON
int32 CT_NONEBUTTON
int32 CT_WIREBUTTON
int32 CT_SOLIDBUTTON
int32 CT_SPECULARBUTTON
int32 CT_NORMALBUTTON
int32 CT_SELECTED
int32 CT_SELECTEDNUM
int32 CT_SELECTED1
int32 CT_SELECTEDNUM1
int32 CT_SELECTED2
int32 CT_SELECTEDNUM2
int32 CT_IMAGEFLAGS
int32 CT_FRAMETIME
int32 CT_UPDATEFLAG
size CT_VAREND

numobjects=1
width=256
height=256
minwidth=256
minheight=256
maxwidth=512
maxheight=512

structure
pointer OBJECTHANDLE
pointer OBJTRANHANDLE
struct OBJECTTRANSFORM,(PM_SIZE-PM_MATRIX)
int32 OBJECTROTVALX
int32 OBJECTROTANGLEX
int32 OBJECTROTVALY
int32 OBJECTROTANGLEY
int32 OBJECTROTVALZ
int32 OBJECTROTANGLEZ
size OBJSIZE

structure
struct FILENAME,80
pointer FILEMSGPNT
pointer FILEDATAPNT
pointer TEXTUREMSGPNT
pointer TEXTUREDATAPNT
struct TIMESTRINGBUF,16
pointer BUFFER
int32 BUFFERSIZE
pointer WORLDHANDLE
pointer GEOMETRYHANDLE
pointer TEXTUREHANDLE
pointer CAMERAHANDLE
pointer CAMTRANHANDLE
struct CAMERATRANSFORM,(PM_SIZE-PM_MATRIX)
int32 CAMERAROTVALZ
int32 CAMERAROTANGLEZ
struct OBJECTSTART,(OBJSIZE*numobjects)
size VARSIZE

node testproc,CONTROLTP,0,TEMPLATE|GUI
	control NULL,4096+VARSIZE,RESIZETP|MOUSETP,CT_VAREND-CT_USER1
	component testproc,'PWORLD/POLYTEST'
	controlend testproc
nodeend	testproc

node tl_test,TOOLTP,VP,TEMPLATE
	tool 'PWORLD/POLYTEST'
	;inputs
	;r6=control object pointer

	;initvars etc
	cpy IM_WIREFRAME,[r6+CT_IMAGEFLAGS]
	allocstruct VARSIZE,r7

	;load test texture
	enquire 'SERVER',0
	lea texturefile,r1
	cpy -1,r8
	clr r11
	clr r12
	qcall SERVER/SV_READ
	bool r8<=0,terror
	cpy r0,[r7+TEXTUREMSGPNT]
	cpy r1,[r7+TEXTUREDATAPNT]

	loop
		;request filename from user
		lea [r7+FILENAME],r0
		lea browpath,r1
		qcall GUI/GI_BROWSE
		breakif r8=0

		;load object selected
		enquire 'SERVER',0
		lea [r7+FILENAME],r1
		cpy -1,r8
		clr r11
		clr r12
		qcall SERVER/SV_READ
		breakif r8<=0

		;save details, setup vars
		cpy r0,[r7+FILEMSGPNT]
		cpy r1,[r7+FILEDATAPNT]

		;open frame buffer
		allocmem maxwidth*maxheight
		if r8!=0
			;save buffer info
			cpy r0,[r7+BUFFER]
			cpy r8,[r7+BUFFERSIZE]

			;get CUI information
			qcall GOB/CUIINFO
			cpy [r1+CUI_BORDERSIZE],r8
			cpy [r1+CUI_BUTTONSIZE],r9
			cpy r8,[r6+CT_BORDERSIZE]
			cpy r9,[r6+CT_BUTTONSIZE]

			;open window
			cpy CENTER,r10
			cpy width,r11
			cpy height,r12
			add r8,r8
			add r8,r11
			add r8,r12
			add r9,r12
			add r9,r12
			add r9,r12
			qcall CLASS/RWINDOW
			if r0!=0
				;save window handle,set palette
				cpy r0,[r6+CT_WINDOW]
				cpy 0,r1
				lcall r0,WN_SETPAL

				;add any gadgets etc
				gos gadgets

			resetworld:
				;open polygon world
				cpy 0,r8
				qcall PWORLD/OPENWORLD
				bool r0=0,error
				cpy r0,[r7+WORLDHANDLE]

				;open geometry
				cpy [r7+FILEDATAPNT],r1
				qcall PWORLD/OPENGEOMETRY
				bool r8=0,error1
				cpy r8,[r7+GEOMETRYHANDLE]

				;open texture
				cpy [r7+TEXTUREDATAPNT],r1
				qcall PWORLD/OPENTEXTURE
				bool r8=0,error1
				cpy r8,[r7+TEXTUREHANDLE]

				;init camera rot angle z
				cpy FP1,r14
				qcall LIB/Q_RANDOM
				cpy r15,[r7+CAMERAROTVALZ]
				cpy 64*10,r14
				qcall LIB/Q_RANDOM
				sub 64*5,r15
				cpy r15,[r7+CAMERAROTANGLEZ]

				;open camera transform
				qcall PWORLD/OPENTRANSFORM
				bool r8=0,error1
				cpy r8,[r7+CAMTRANHANDLE]

				;open camera
				cpy r8,r1
				qcall PWORLD/OPENCAMERA
				bool r8=0,error1
				cpy r8,[r7+CAMERAHANDLE]

				;init camera transform
				lea [r7+CAMERATRANSFORM],r0
				cpy FP1,r8
				qcall PWORLD/MATSCALE
				cpy 0,r8
				cpy 0,r9
				cpy 0,r10
				qcall PWORLD/MATMOVE

				;load camera transform
				cpy [r7+WORLDHANDLE],r0
				cpy [r7+CAMTRANHANDLE],r1
				lea [r7+CAMERATRANSFORM],r2
				qcall PWORLD/SET

				;init all objects in scene
				lea [r7+OBJECTSTART],r2
				lea [r2+(OBJSIZE*numobjects)],r3
				repeat
					pshm r3,r2

					;init object rot angle x
					cpy FP1,r14
					qcall LIB/Q_RANDOM
					cpy r15,[r2+OBJECTROTVALX]
					cpy 64*20,r14
					qcall LIB/Q_RANDOM
					sub 64*10,r15
					cpy r15,[r2+OBJECTROTANGLEX]

					;init object rot angle y
					cpy FP1,r14
					qcall LIB/Q_RANDOM
					cpy r15,[r2+OBJECTROTVALY]
					cpy 64*20,r14
					qcall LIB/Q_RANDOM
					sub 64*10,r15
					cpy r15,[r2+OBJECTROTANGLEY]

					;init object rot angle z
					cpy FP1,r14
					qcall LIB/Q_RANDOM
					cpy r15,[r2+OBJECTROTVALZ]
					cpy 64*20,r14
					qcall LIB/Q_RANDOM
					sub 64*10,r15
					cpy r15,[r2+OBJECTROTANGLEZ]

					;open object transform
					cpy [r7+(8+WORLDHANDLE)],r0
					qcall PWORLD/OPENTRANSFORM
					if r8=0
						freestruct 8
						got error1
					endif
					cpy [r7],r2
					cpy r8,[r2+OBJTRANHANDLE]

					;open object
					cpy [r7+(8+GEOMETRYHANDLE)],r1
					cpy r8,r2
					cpy 1,r8
					lea [r7+(8+TEXTUREHANDLE)],r3
					qcall PWORLD/OPENOBJECT
					if r8=0
						freestruct 8
						got error1
					endif
					cpy [r7],r2
					cpy r8,[r2+OBJECTHANDLE]

					.if numobjects=1
						;init object transform
						lea [r2+OBJECTTRANSFORM],r0
						cpy 275<<16,r8
						qcall PWORLD/MATSCALE
						cpy 0,r8
						cpy 0,r9
						cpy 200<<16,r10
						qcall PWORLD/MATMOVE
					.else
						;init object transform
						lea [r2+OBJECTTRANSFORM],r0
						cpy 50,r14
						qcall LIB/Q_RANDOM
						add 250,r15
						cpy r15,r8
						i2h r8
						qcall PWORLD/MATSCALE
						cpy 300,r14
						qcall LIB/Q_RANDOM
						sub 150,r15
						cpy r15,r8
						cpy 300,r14
						qcall LIB/Q_RANDOM
						sub 150,r15
						cpy r15,r9
						cpy 50,r14
						qcall LIB/Q_RANDOM
						add 200,r15
						cpy r15,r10
						i2h r8
						i2h r9
						i2h r10
						qcall PWORLD/MATMOVE
					.endif

					popm r2,r3
					add OBJSIZE,r2
				until r2=r3

				loop
					;check mailbox
					testmymail -1
					if r8=RESIZETP
						;resize window with limits on size
						cpy [r6+CT_WINDOW],r0
						cpy [r6+CT_BORDERSIZE],r8
						cpy [r6+CT_BUTTONSIZE],r9
						add r8,r8
						mul 3,r9
						add r8,r9
						lea [r8+maxwidth],r11
						lea [r9+maxheight],r12
						add minwidth,r8
						add minheight,r9
						clr r10
						clr r13
						lcall r0,WN_RESIZE
						if r8!=0
							clr r1
							lcall r0,WN_CLRGOB
							;add any gadgets etc
							gos gadgets
						endif
					elseif r8=MOUSETP
						readmymail r8
						cpy [r1+MO_RX],r13
						cpy [r1+MO_RY],r14
						cpy [r1+MO_BUTTON],r15
						freenode r0

						;right button click
						breakif r15=MB_RIGHT

						if r15=MB_LEFT
							;left click on buttons ?
							cpy r13,r8
							cpy r14,r9
							cpy 1,r11
							cpy 1,r12
							cpy [r6+CT_WINDOW],r0
							psh.l r8
							lcall r0,WN_HITGOB
							pop.l r8
							if r1=[r6+CT_BORDER]
								cpy 1,r11
								cpy 1,r12
								lcall r0,WN_NXTGOB
							endif
							breakif r1=[r6+CT_CBUTTON]
							if r1=[r6+CT_NONEBUTTON]
								gos selectnew
								cpy 0,[r6+CT_SELECTEDNUM]
								and ~(IM_FACESORT|IM_PIXELSORT),[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_FACEBUTTON]
								gos selectnew
								cpy 1,[r6+CT_SELECTEDNUM]
								and ~IM_PIXELSORT,[r6+CT_IMAGEFLAGS]
								or IM_FACESORT,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_PIXELBUTTON]
								gos selectnew
								cpy 2,[r6+CT_SELECTEDNUM]
								and ~IM_FACESORT,[r6+CT_IMAGEFLAGS]
								or IM_PIXELSORT,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_BOTHBUTTON]
								gos selectnew
								cpy 3,[r6+CT_SELECTEDNUM]
								or IM_FACESORT|IM_PIXELSORT,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_WIREBUTTON]
								gos selectnew1
								cpy 0,[r6+CT_SELECTEDNUM1]
								or IM_WIREFRAME,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_SOLIDBUTTON]
								gos selectnew1
								cpy 1,[r6+CT_SELECTEDNUM1]
								and ~IM_WIREFRAME,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_SPECULARBUTTON]
								gos selectnew2
								cpy 1,[r6+CT_SELECTEDNUM2]
								or IM_SPECULAR,[r6+CT_IMAGEFLAGS]
							elseif r1=[r6+CT_NORMALBUTTON]
								gos selectnew2
								cpy 0,[r6+CT_SELECTEDNUM2]
								and ~IM_SPECULAR,[r6+CT_IMAGEFLAGS]
							else
								;close polygon world, and reset test
								cpy [r7+WORLDHANDLE],r0
								qcall PWORLD/CLOSEWORLD
								got resetworld
							endif
						endif
					elseif r8!=0
						;dump alien mail
						readmymail r8
						freenode r0
					endif

					;process all objects in scene
					lea [r7+OBJECTSTART],r2
					lea [r2+(OBJSIZE*numobjects)],r3
					repeat
						pshm r3,r2

						;rotate object transform
						lea [r2+OBJECTTRANSFORM],r0
						qcall PWORLD/MATINIT
						cpy [r2+OBJECTROTVALX],r8
						add [r2+OBJECTROTANGLEX],r8
						cpy r8,[r2+OBJECTROTVALX]
						qcall PWORLD/MATROTX
						cpy [r2+OBJECTROTVALY],r8
						add [r2+OBJECTROTANGLEY],r8
						cpy r8,[r2+OBJECTROTVALY]
						qcall PWORLD/MATROTY
						cpy [r2+OBJECTROTVALZ],r8
						add [r2+OBJECTROTANGLEZ],r8
						cpy r8,[r2+OBJECTROTVALZ]
						qcall PWORLD/MATROTZ

						;load object transform
						cpy [r7+(8+WORLDHANDLE)],r0
						cpy [r2+OBJTRANHANDLE],r1
						lea [r2+OBJECTTRANSFORM],r2
						qcall PWORLD/SET

						popm r2,r3
						add OBJSIZE,r2
					until r2=r3

					;rotate camera transform
					lea [r7+CAMERATRANSFORM],r0
					qcall PWORLD/MATINIT
					cpy [r7+CAMERAROTVALZ],r8
					add [r7+CAMERAROTANGLEZ],r8
					cpy r8,[r7+CAMERAROTVALZ]
					qcall PWORLD/MATROTZ

					;load cmaera transform
					cpy [r7+WORLDHANDLE],r0
					cpy [r7+CAMTRANHANDLE],r1
					lea [r7+CAMERATRANSFORM],r2
					qcall PWORLD/SET

					;get current time
					tao GETTIME
					cpy r8,[r6+CT_FRAMETIME]

					;generate frame
					cpy [r6+CT_WINDOW],r0
					lcall r0,WN_INFO
					cpy [r6+CT_BORDERSIZE],r8
					cpy [r6+CT_BUTTONSIZE],r9
					add r8,r8
					mul 3,r9
					sub r8,r11
					sub r8,r12
					sub r9,r12
					cpy FP1,r13
					cpy [r7+WORLDHANDLE],r0
					cpy [r7+CAMERAHANDLE],r1
					cpy [r7+BUFFER],r2
					cpy [r6+CT_IMAGEFLAGS],r8
					pshm r11,r12
					qcall PWORLD/IMAGE
					popm r12,r11

					;calc total time in ms, save for print
					tao GETTIME
					sub [r6+CT_FRAMETIME],r8
					asl	3,r8
					div	125,r8
					psh r8

					;copy frame into window
					cpy [r6+CT_WINDOW],r0
					cpy [r7+(4+BUFFER)],r1
					cpy [r6+CT_BORDERSIZE],r8
					cpy [r6+CT_BUTTONSIZE],r9
					mul 3,r9
					add r8,r9
					cpy 0,r10
					lcall r0,WN_BLIT

					;print time
					cpy [r6+CT_WINDOW],r0
					lea homestring,r1
					lcall r0,WN_PRINT
					pop r8
					cpy 10,r9
					lea [r7+TIMESTRINGBUF],r0
					qcall LIB/ITOA
					cpy r0,r1
					cpy [r6+CT_WINDOW],r0
					lcall r0,WN_PRINT

					;update window
					if [r6+CT_UPDATEFLAG]=0
						lcall r0,WN_UPDATE
						cpy 1,[r6+CT_UPDATEFLAG]
					else
						lcall r0,WN_GETCLIP
						sub r8,r11
						sub r9,r12
						lcall r0,WN_FUPDATE
					endif
				endloop

			error:
				;close polygon world
				cpy [r7+WORLDHANDLE],r0
				qcall PWORLD/CLOSEWORLD

			error1:
				;close window
				cpy [r6+CT_WINDOW],r0
				lcall r0,WN_CLOSE
			endif

			;free frame buffer
			cpy [r7+BUFFER],r0
			cpy [r7+BUFFERSIZE],r8
			freemem r0,r8
		endif

		;free object file
		cpy [r7+FILEMSGPNT],r0
		freenode r0
	endloop

	;free test texture
	cpy [r7+TEXTUREMSGPNT],r0
	freenode r0

terror:
	freestruct VARSIZE
	ret

gadgets:
	;add gadgets
	clr [r6+CT_UPDATEFLAG]

	cpy [r6+CT_WINDOW],r0
	lea ptesttitle,r1
	cpy GA_BORDER|GA_TITLE|GA_CLOSE,r8
	qcall GOB/CUIGADGETS
	cpy r8,[r6+CT_BORDER]
	cpy r10,[r6+CT_CBUTTON]

	;drop clip region
	lcall r0,WN_GETCLIP
	psh r11
	add [r6+CT_BUTTONSIZE],r9
	add [r6+CT_BUTTONSIZE],r9
	lcall r0,WN_SETCLIP

	;add none button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	div 4,r11
	lea nonebutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM]=0
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_NONEBUTTON]
	if [r6+CT_SELECTEDNUM]=0
		cpy r0,[r6+CT_SELECTED]
	endif

	;add face button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	div 4,r11
	add r11,r8
	lea facebutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM]=1
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_FACEBUTTON]
	if [r6+CT_SELECTEDNUM]=1
		cpy r0,[r6+CT_SELECTED]
	endif

	;add pixel button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	div 4,r11
	add r11,r8
	add r11,r8
	lea pixelbutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM]=2
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_PIXELBUTTON]
	if [r6+CT_SELECTEDNUM]=2
		cpy r0,[r6+CT_SELECTED]
	endif

	;add both button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	div 4,r11
	add r11,r8
	add r11,r8
	add r11,r8
	lea bothbutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM]=3
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_BOTHBUTTON]
	if [r6+CT_SELECTEDNUM]=3
		cpy r0,[r6+CT_SELECTED]
	endif

	;add wire button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	add r12,r9
	div 4,r11
	lea wirebutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM1]=0
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_WIREBUTTON]
	if [r6+CT_SELECTEDNUM1]=0
		cpy r0,[r6+CT_SELECTED1]
	endif

	;add solid button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	add r12,r9
	div 4,r11
	add r11,r8
	lea solidbutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM1]=1
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_SOLIDBUTTON]
	if [r6+CT_SELECTEDNUM1]=1
		cpy r0,[r6+CT_SELECTED1]
	endif

	;add norm button
	cpy [r7],r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	add r12,r9
	div 4,r11
	add r11,r8
	add r11,r8
	lea normalbutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM2]=0
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_NORMALBUTTON]
	if [r6+CT_SELECTEDNUM2]=0
		cpy r0,[r6+CT_SELECTED2]
	endif

	;add specular button
	pop r11
	cpy [r6+CT_BORDERSIZE],r8
	cpy [r6+CT_BUTTONSIZE],r12
	sub r8,r11
	cpy r8,r9
	add r12,r9
	add r12,r9
	div 4,r11
	add r11,r8
	add r11,r8
	add r11,r8
	lea specularbutton,r1
	cpy [r6+CT_WINDOW],r0
	if [r6+CT_SELECTEDNUM2]=1
		cpy -1,r13
	else
		cpy 1,r13
	endif
	qcall GOB/CUITBUTTON
	cpy r0,[r6+CT_SPECULARBUTTON]
	if [r6+CT_SELECTEDNUM2]=1
		cpy r0,[r6+CT_SELECTED2]
	endif
	ret

selectnew:
	;select new button (first group)
	;inputs
	;r0=window handle
	;r1=gadget handle
	clr [r6+CT_UPDATEFLAG]
	allocstruct 12,r7
	cpy r1,[r7+8]
	cpy r7,r2
	cpy [r6+CT_SELECTED],r1
	cpy 0,[r2]
	cpy 1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	cpy [r7+8],r1
	cpy r1,[r6+CT_SELECTED]
	cpy r7,r2
	cpy -1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	freestruct 12
	ret

selectnew1:
	;select new button (second group)
	;inputs
	;r0=window handle
	;r1=gadget handle
	clr [r6+CT_UPDATEFLAG]
	allocstruct 12,r7
	cpy r1,[r7+8]
	cpy r7,r2
	cpy [r6+CT_SELECTED1],r1
	cpy 0,[r2]
	cpy 1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	cpy [r7+8],r1
	cpy r1,[r6+CT_SELECTED1]
	cpy r7,r2
	cpy -1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	freestruct 12
	ret

selectnew2:
	;select new button (third group)
	;inputs
	;r0=window handle
	;r1=gadget handle
	clr [r6+CT_UPDATEFLAG]
	allocstruct 12,r7
	cpy r1,[r7+8]
	cpy r7,r2
	cpy [r6+CT_SELECTED2],r1
	cpy 0,[r2]
	cpy 1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	cpy [r7+8],r1
	cpy r1,[r6+CT_SELECTED2]
	cpy r7,r2
	cpy -1,[r2+4]
	cpy GB_USER1,r8
	cpy 8,r9
	lcall r0,WN_SETVAR
	freestruct 12
	ret

	string ptesttitle,'PolyTest'
	string nonebutton,'Nosort'
	string facebutton,'Face'
	string pixelbutton,'Pixel'
	string bothbutton,'Both'
	string wirebutton,'Wire'
	string solidbutton,'Solid'
	string specularbutton,'SpecOn'
	string normalbutton,'SpecOff'
	string browpath,'basic/3dobject/*.img'
	string texturefile,'bitmaps/marble.tbm'

homestring:
	dc.b 27,'H',0

	toolend tl_test
nodeend tl_test

.end
