.include 'tao.inc'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/CAT'
nodeend fi_cont

node tl_pgm,TOOLTP,VP,TEMPLATE
	tool 'STDIO/CAT'
	;cat file(s)
	;inputs
	;r6=pipe object pointer

	cpy	r7,r3
	qcall	LIB/ARGCARGV	;divide up names
	tst	r8
	beq	exit
		;first skip past program name
	cmp	1,r8
	beq	fromstdin	;get names from stdin

loop:	add	4,r0		;skip to next
	cpy	[r0],r1
	tst	r1
	beq	exit2	;exit after last param
	psh	r0
	gos	process
	pop	r0
	got	loop

fromstdin:	cpy	256,r8
	qcall	LIB/MALLOC
	tst	r0
	beq	exit2	;woops no line buffer
	cpy	r0,r3

loop1:	cpy	r3,r0
	qcall	LIB/GETS
	tst	r0
	beq	exit2	;exit on finish
	psh	r3
	cpy	r0,r1
	gos	process	;do action
	pop	r3
	got	loop1

exit2:	qcall	LIB/EXIT
exit:	ret

*filename string > r1

process:	cpy	FP_READ,r8
	psh	r1
	cpy	r1,r0
	qcall	CLASS/FILE
	pop	r1
	tst	r0
	bne	gotfile

	tracef	"Cannot find object %s\n",r1
	ret

gotfile:	cpy	r0,r2	;r2 is file handle
	stdout	r3	;r3 is STDOUT
	got	getblock

putblock:	cpy	[r0+FP_BUFE],r9
	cpy	r9,[r0+FP_BUFP]	;set to read all block
	lea	[r1-1],r0	;adjust for first char read
	sub	r0,r9	;size of block
	cpy	1,r8	;byte sized objects
	cpy	r3,r1	;STDOUT file*
	qcall	LIB/FWRITE	;write block to STDOUT
getblock:	getc	r2
	cmp	EOF,r8
	bne	putblock

	lcall	r2,FP_CLOSE
	ret

	toolend tl_pgm
nodeend tl_pgm

.end
