.include 'tao.inc'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/COLUMN'
nodeend fi_cont

node tl_inlet,TOOLTP,VP,TEMPLATE
	tool 'STDIO/COLUMN'

	;Columnise STDIN to STDOUT
	;inputs
	;stdin ->  column num width -> stdout

	cpy	r7,r3		;copy stack
	qcall	LIB/ARGCARGV		;get arguments
	tst	r8
	beq	bye
	cmp	3,r8	;want = 3 parameters
	bne	tellem	;no, so bye

	psh	r0	;R0 points to args
	cpy	r0,r1
	add	4,r1	;1st parm
	cpy	[r1],r0
	qcall	LIB/ATOI		;numcols
	cpy	r8,[r6+CT_USER1]

	pop	r1
	add	8,r1
	cpy	[r1],r0
	qcall	LIB/ATOI
	cpy	r8,[r6+CT_USER2]	;width

	;get a buffer
	cpy	512,r8
	qcall	LIB/MALLOC	;r0 -> block
	tst	r0
	beq	nomem
	cpy	r0,[r6+CT_USER3]	;save block ptr

top:	cpy	[r6+CT_USER1],r8
	dec	r8		;for numcols-1
	forsp	r8
	  cpy	[r6+CT_USER3],r0
	  qcall	LIB/GETS	;r0->buffer
	  tst	r0
	  beq	out

	  cpy	[r6+CT_USER2],r8	;width
	  printf	'%-*s',r8,r0		;print string

	nextsp
	
	cpy	[r6+CT_USER3],r0
	qcall	LIB/GETS	;r0->buffer
	tst	r0
	beq	out

	printf	'%s\n',r0	;print string
	got	top

out:	qcall	LIB/EXIT		;close streams
bye:	ret

tellem:	printf	'Usage:\nCOLUMN <numcol> <width> (numcol columns of size width)\n'
	got	out

nomem:	tracef	'Column: not enough memory\n'
	stdin	r0	;failed, but pass through without columns anyway
lop2:	getc	r0

	cmp	EOF,r8
	beq	out

	putc	r8,r0
	got	lop2

	toolend tl_inlet
nodeend tl_inlet

.end
