********************************************
** DIFF1
** Parent method : for Standard I/O
**
** Copyright (C) 1991-1994 Andy HENSON
** Licenced to Tao Systems Ltd.
** All rights reserved
********************************************

.include 'tao.inc'

.ctlprefix 'STDIO/'

*** CONTROL ***

node ctl,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,-1,0,0,0,0
	component ctl,'STDIO/DIFF'
	controlend ctl
nodeend ctl

*** TOOL ***

node toolb,TOOLTP,VP,TEMPLATE
	tool 'STDIO/DIFF'
		;inputs
		;r6=control object pointer
	cpy	r7,r3
	qcall	LIB/ARGCARGV
	tst	r8
	beq	exitq
	cmp	2,r8
	bge	args
	allocstruct	80,r7
		;here for no args case... prompt for it:
prompt:	lea	stt_m,r0
	printfp	r0
	cpy	r7,r2
getit:	stdin	r0
	GETC	r0
	cmp	EOF,r8
	beq	exit
	cmp	EOL,r8
	beq	gotit
	cmpu	' ',r8
	blt	getit		;junk unknown controls
	cpy.b	r8,[r2]
	inc	r2
	got	getit

gotit:	cpy.b	0,[r2]
	cpy	r7,r1
	call	processit
	lea	end_m,r0
	printfp	r0
	got	prompt

args:	cpy	1,r8			;default VERBOSE
	cpy	[r0+4],r1
	cpy.b	[r1],r9
	cmp	'-',r9
	bne	argnop
	call	OPT		;set R8 from R1
	add	4,r0
	cpy	[r0+4],r1
argnop:	cpy	[r0+8],r0
	exg	r0,r1
	;tracef	'opt R8=%d\nname1 R0=%s\nname2 R1=%s\n',r8,r0,r1
	qcall	STDIO/DIFF1
	;tracef	'exited DIFF'
exit:	qcall	LIB/EXIT
exitq:	ret

Processit:	;Here to execute the line, R1
	;tracef	'processit\n'
	clr	[r6+CT_USER2]
	cpy	1,r8			;default VERBOSE
	;tracef	'parsing /%s/\n',r1
	call	SKIP			;skip to after space
	;tracef	'skipped to $%x',r9
	cmp	'-',r9
	bne	noopt
	call	OPT		;r1=opt string
noopt:			;here with R1-1 =1st after options, R8=flags
	call	SKIP
	cpy	r1,r0		;1st param
second:	inc	r1
	cpy.b	[r1],r9
	cmp	' ',r9
	bne	second
	cpy.b	0,[r1]
	call	SKIPI
			;now run it
	;tracef	'LINE\nopt R8=%d\nname1 R0=%s\nname2 R1=%s\n',r8,r0,r1
	qcall	STDIO/DIFF1
	;tracef	'exited DIFF'
	ret

OPT:		;into OPT with [r1]='-', r8=default
	inc	r1
opt15:	cpy.b	[r1],r9
	inc	r1
	and	$DF,r9
	cmp	'T',r9
	bne	opt2
	cpy	0,r8		;TERSE
opt2:	cmp	'B',r9
	bne	opt3
	cpy 2,r8
opt3:	cmp ' ',r9
	bgt	opt15
	ret

SKIPI:	inc	r1
SKIP:		;skip till R1 after spaces, return R9
	cpy.b	[r1],r9
	cmp	' ',r9
	beq	skipi
	ret

	.align
stt_m:	dc 10,'diff - file differences program'
	dc 10,'[options]  oldfile  newfile'
	dc 10,' -t  terse output'
	dc 10,' -b  add change bars on output'
	dc 10,'? ',0
end_m:	dc 10,'----------',10,0

	toolend toolb
nodeend toolb

.end
