********************************************
** DIFF1
** main method Diff program
**
** Copyright (C) 1991-1994 Andy HENSON
** Licenced to Tao Systems Ltd.
** All rights reserved
********************************************

;Output format (terse format, -t):
;  c<n>		;copy <n> lines, i.e. they were identical (n decimal)
;  d<n>		;delete <n> lines from OLD file at this point
;  i<text>	;insert line of text into NEW file at this point

;Output format (verbose):
;  is intended to be human readable and lists both filenames and lines
;  from both old and new files which have changed.

;Output format (change bars, -b):
;  new file output with bar ("|") added to column 0 when change is
;  detected.  All text shifted by 2 cols.
;  Bars can be removed by "nobars" command.

.include 'tao'

MAXLINES = 6500		;up to 6,500 lines in each file

	structure
	struct	node,MN_SIZE
	struct	buff,160
	size	bufftop
	int32	options
	int32	difcount
	int32	fileoff1
	int32	filenam1
	int32	fileh1			;FILE* handle
	struct	hash1,MAXLINES*8	;hash:4 offset:4
	int32	fileoff2
	int32	filenam2
	int32	fileh2
	struct	hash2,MAXLINES*8	;ditto
	size	data_size

********************************************
**         start of method node           **
********************************************
	
node toolb,TOOLTP,VP,TEMPLATE
	tool 'STDIO/DIFF1'
	;inputs
		;r6=control object pointer
		;r0=old file
		;r1=new file
		;r8=options, 1=verbose, 2=change bars
	;outputs
		;via STDIO
	;pres R4-R7
	psh r5
	psh r1
	psh r0
	psh r8
	lea ver_m,r0
	printfp r0
			;alloc ram
	cpy data_size,r8
	tao ALLOCMEM
	tst r8
	bne memok
	add 12,r7	;pop 3 regs
	pop r5
	ret
	
memok:			;alloc'd ok
	cpy r0,r5
	cpy r8,r9
memclr:			;zero whole block, r9=r8=size, r0=r3=addr
	clr [r0]
	add 4,r0
	sub 4,r9
	tst r9
	bgt memclr
			;mem zero'd
	cpy r8,[r5+MN_BYTES]	;save size
		;get file
	pop r8
	cpy r8,[r5+OPTIONS]
	pop r0		;file#1
	cpy r0,[r5+FILENAM1]
	clr r8		;share mode
	cpy FP_READ,r8	;text mode
	qcall CLASS/FILE
	cpy r0,r1		;FILE*
	pop r0		;file#2
	cpy r0,[r5+FILENAM2]
	tst r1
	beq fnf
	cpy r1,[r5+FILEH1]
	clr r8		;share mode
	cpy FP_READ,r8	;text mode
	qcall CLASS/FILE
	tst r0
	beq fnf
	cpy r0,[r5+FILEH2]
		;now calc hash's
		;file 1
	cpy [r5+FILEH1],r0
	lea [r5+HASH1],r2	;start of hash's
	lea [r2+((MAXLINES-5)*8)],r3	;limit
	clr r11		;offset
f1ha:		;compute hash for line, R2=table, R0/R1=block
	clr r12		;hash so far
	cpy r11,[r2+4]	;save offset
f1ch:	GETC r0
	tst r8
	bmi f1eof
	inc r11
	cmp EOL,r8
	beq f1ch2
	cmp.u ' ',r8
	blt f1ch		;ignore control chars
	mul 279,r12
	add r8,r12
	got f1ch

f1ch2:
	tst r12
	bne f1ch3
	cpy 1,r12		;in unlikely case of hash=0, set NZ
f1ch3:
	cpy r12,[r2]
	add 8,r2
	bool r2<r3,f1ha
	clr r12
	cpy -2,[r2+4]	;special "too big" flag
f1eof:		;EOF (or too big)
	cpy r12,[r2]
	cpy -1,[r2+8]		;terminal
	cpy -1,[r2+16]
	cpy -1,[r2+24]
	cpy -1,[r2+12]		;text ptrs (EOF)
	cpy -1,[r2+20]
	cpy -1,[r2+28]
		;file 2
	cpy [r5+FILEH2],r0
	lea [r5+HASH2],r2	;start of hash's
	lea [r2+((MAXLINES-5)*8)],r3	;limit
	clr r11		;offset
f2ha:		;compute hash for line, R2=table, R0/R1=block
	clr r12		;hash so far
	cpy r11,[r2+4]	;save offset
f2ch:	GETC r0
	tst r8
	bmi f2eof
	inc r11
	cmp EOL,r8
	beq f2ch2
	cmp.u ' ',r8
	blt f2ch		;ignore control chars
	mul 279,r12
	add r8,r12
	got f2ch

f2ch2:
	tst r12
	bne f2ch3
	cpy 1,r12		;in unlikely case of hash=0, set NZ
f2ch3:
	cpy r12,[r2]
	add 8,r2
	bool r2<r3,f2ha
	cpy 2,r12
	cpy -2,[r2+4]	;special "too big" flag
f2eof:		;EOF or too big
	cpy r12,[r2]
	cpy -1,[r2+8]		;terminal
	cpy -1,[r2+16]
	cpy -1,[r2+24]
	cpy -1,[r2+12]		;text ptrs (EOF)
	cpy -1,[r2+20]
	cpy -1,[r2+28]
		;both hashes computed ok
	cpy $ffffff,[r5+FILEOFF1]		;invalid, to force rewind
	cpy $ffffff,[r5+FILEOFF2]
		;now check for differences
		;start in "same" mode
	lea [r5+HASH1],r0	;old file
	lea [r5+HASH2],r1	;new file
same:	cpy -1,r9		;nr lines same
same1:	inc	r9
	cpy [r0],r8
	cmp [r1],r8
	bne diffxs
	add 8,r0
	add 8,r1
	tst r8
	bne same1
	sub 8,r1
	gos disp_c		;exit same
	gos disp_f		;and display at end
	got fin

diffxs:
	call disp_c		;exit same
	clr r9		;nr lines diff (*8)
diff:	add 8,r9
		;try and match #2 lines against current
 	lea [r0+r9],r2
	clr r10
	cpy r1,r3
diff1:
	cpy [r2],r8
	cmp [r3],r8
	bne diff11
	bool r8=0,diff11
	cpy [r2+8],r8		;min of 3 conseq lines same
	cmp [r3+8],r8
	bne diff11
	cpy [r2+16],r8		;min of 3 conseq lines same
	cmp [r3+16],r8
	beq diff1x
diff11:
	add 8,r3
	add 8,r10
	cmp r9,r10
	ble diff1
		;try and match #1 lines against current
	lea [r1+r9],r3
	clr r10
	cpy r0,r2
diff2:
	cpy [r2],r8
	cmp [r3],r8
	bne diff22
	bool r8=0,diff22
	cpy [r2+8],r8		;min of 2 conseq lines same
	cmp [r3+8],r8
	bne diff22
	cpy [r2+16],r8		;min of 3 conseq lines same
	cmp [r3+16],r8
	beq diff2x
diff22:
	add 8,r2
	add 8,r10
	cmp r9,r10
	bne diff2
		;none, increment current
	got diff

diff2x:		;exit from #1 at R10, #2 at R9
	exg r9,r10
diff1x:		;exec from #1 at R9, #2 at R10
		;R2=match #1, R3=match #2;  R0=diff #1, R1=diff #2
	exg r2,r0
	exg r3,r1
	call display
	got same

fnf:		;here if file not found, close and report
	cpy [r5+FILEH1],r0
	tst r0
	beq fnf2
	lcall r0,FP_CLOSE
fnf2:	cpy [r5+FILEH2],r0
	tst r0
	beq fnf3
	lcall r0,FP_CLOSE
fnf3:		;free local block
	cpy r5,r0
	cpy [r0+MN_BYTES],r8
	freemem r0,r8
		;send msg
	lea fnf_m,r0
	printfp r0
	pop r5
	ret

fin:		;here if finished
	cpy [r5+FILEH1],r0
	lcall r0,FP_CLOSE
	cpy [r5+FILEH2],r0
	lcall r0,FP_CLOSE
		;free local block
	cpy r5,r0
	cpy [r0+MN_BYTES],r8
	freemem r0,r8
	pop r5
	ret

***********************
*** DISPLAY section ***
***********************

disp_c:		;COPY (i.e. lines same)
		;R9=nr lines to copy
		;r1=line to list of new file
	cpy 'c',r8
	bool [r5+OPTIONS]=0, printit		;'c' line if TERSE mode
	bool [r5+OPTIONS]=2, cnobars
	ret			;no display if VERBOSE

cnobars:	;here for list without change bars
	cpy r1,r2
	cpy r9,r8
	mul 8,r8
	sub r8,r2
		;print R9 lines from R2
		;pres R0,R1
	pshm r0,r1
cnb2:	tst r9
	beq cnb3
	pshm r9,r2
	lea [r5+buff],r1
	cpy [r2+4],r8		;offset
	cpy [r5+fileh2],r0		;handle
	cpy [r5+fileoff2],r9
	call showline
	cpy r11,[r5+fileoff2]
	popm r2,r9
	add 8,r2
	dec r9
	got cnb2

cnb3:	popm r1,r0
	ret


*---*

disp_f:		;FIN display
		;only in verbose mode
	bool [r5+OPTIONS]!=1,disf3
	cpy [r5+DIFCOUNT],r9
	cpy 1,r10
	lea fin1_m,r0
	cmp 1,r9
	beq disf2
	lea fin_m,r0
disf2:	printfp r0,r9
disf3:	ret

*---*

display:	;DISPLAY changes (d/i or verbose)
		;R2/R3=hash ptrs, R9/R10=nr lines
		;pres R0/R1
	bool [r5+OPTIONS]=0, terse		;'d/i' lines if TERSE mode
	bool [r5+OPTIONS]=2, cbars		;list lines with bars
		;here for more wordy display
	inc [r5+difcount]
	psh r10
	psh r3
	lsr 3,r9		;number of lines
	lea [r5+hash1],r3
	call verbose
	pop r2
	pop r9
	lsr 3,r9		;number of lines
	lea [r5+hash2],r3
	call verbose
	pshm r0,r1
	lea mark,r0
	printfp r0
	popm r1,r0
	ret

verbose:	;here to o/p one set in verbose mode
		;R3=hash table (-8=filename,-4=handle)
		;r2=hash entry start, R9=nr lines
	inc r9	;include extra line at end
	tst [r2+4]	;offset = 0?
	beq ver2
	sub 8,r2
	inc r9	;include extra line at start
ver2:	pshm r0,r1,r2,r3,r9
	cpy [r3-8],r0
	lea [r5+buff],r1
	cpy.b '"',[r1]
	inc r1
	cps r0,r1,r8
	cpy.b '"',[r1]
	cpy.b EOL,[r1+1]
	cpy.b 0,[r1+2]
	lea [r5+buff],r1
	printf '%s',r1
	popm r9,r3,r2,r1,r0
		;done header... now
		;print R9 lines from R2, R3->start of hashtab
		;pres R0,R1
	bool r9<41,ver3a
		;split and omit middle
	psh r9
	cpy 20,r9
	gos ver3a
	pop r8
	sub 40,r8
	mul 8,r8
	add r8,r2
	pshm r0,r1
	printf "...\n"
	popm r1,r0
	cpy 20,r9
ver3a:		;display r9 lines
	pshm r0,r1
ver3:	tst r9
	bne ver4
	popm r1,r0
	ret

ver4:	pshm r9,r2,r3
	cpy r2,r9
	sub r3,r9
	lsr 3,r9
	inc r9
	bool [r2+4]<0,ver5	;offset = EOF?
	printf '%6d: ',r9
	lea [r5+buff],r1
	cpy [r2+4],r8		;offset
	cpy [r3-4],r0		;handle
	cpy [r3-12],r9		;old offset
	psh r3
	call showline
	pop r3
	cpy r11,[r3-12]		;set new offset
	popm r3,r2,r9
	add 8,r2
	dec r9
	got ver3

ver5:	;here at EOF/Too big, line r9
	if [r2+4]=-2
		printf "File too big: compare aborted\n"
	endif
	popm r3,r2,r9
	clr r9	;immediately end
	got ver3
	
** Terse **

terse:		;here for terse
	psh r10
	psh r3
	lsr 3,r9		;number of lines
	cpy 'd',r8
	call printit
	pop r2
	pop r9
	lsr 3,r9		;number of lines
		;now for I
		;print R9 lines from R2, R3->start of hashtab
		;pres R0,R1
	pshm r0,r1
ter2:	tst r9
	beq ter3
	pshm r9,r2
	lea [r5+buff],r1
	cpy.b 'i',[r1]
	inc r1
	cpy [r2+4],r8		;offset
	cpy [r5+fileh2],r0		;handle
	cpy [r5+fileoff2],r9
	call showline
	cpy r11,[r5+fileoff2]
	popm r2,r9
	add 8,r2
	dec r9
	got ter2

ter3:	popm r1,r0
	ret

** Change bars **

cbars:		;here for list with change bars
	cpy r10,r9
	lsr 3,r9		;number of lines
	cpy r3,r2
		;print R9 lines from R2
		;pres R0,R1
	pshm r0,r1
cb2:	tst r9
	beq cb3
	pshm r9,r2
	lea [r5+buff],r1
	cpy [r2+4],r8		;offset
	cpy [r5+fileh2],r0		;handle
	cpy [r5+fileoff2],r9
	call showlineb
	cpy r11,[r5+fileoff2]
	popm r2,r9
	add 8,r2
	dec r9
	got cb2

cb3:	popm r1,r0
	ret

;Subroutines

showline:	;here with R8=offset, r9=oldoffset, R0=handle, showline
		;r1=ptr to buffer to fill & print
		;returns R11=new offset
	psh r1
	psh r8
	call SEEK
	pop r11
	pop r2
	psh r3
	lea [r5+(bufftop-2)],r3
sh3:	GETC r0
	inc r11			;incr new offset each char rd
	cmp -1,r8
	beq sh4			;EOF
	cmp EOL,r8
	beq sh4
	bool r2=r3,sh4
	cpy.b r8,[r2]			;copy till EOL
	inc r1
	inc r2
	got sh3

sh4:	pop r3
	cpy.b EOL,[r2]
	cpy.b 0,[r2+1]
	lea [r5+buff],r1
	printf '%s',r1
	ret

showlineb:	;here with R8=offset, r9=oldoffset, R0=handle, showline
		;r1=ptr to buffer to fill & print; adds change bar
		;returns R11=new offset
	psh r1
	psh r8
	call SEEK
	pop r11
	pop r2
	psh r3
	lea [r5+(bufftop-3)],r3
	clr r14	;xcol
shb3:	GETC r0
	inc r11			;incr new offset each char rd
	if r8=TAB
		or 7,r14
	endif
	inc r14
	cmp -1,r8
	beq shb4			;EOF
	cmp EOL,r8
	beq shb4
	bool r2=r3,shb5
	cpy.b r8,[r2]			;copy till EOL
	inc r1
	inc r2
	got shb3

shb4:	bool r14>=78,shb5
	bool r2=r3,shb5
	cpy.b ' ',[r2]
	inc r2
	inc r14
	got shb4

shb5:	pop r3
	cpy.b '|',[r2]
	cpy.b EOL,[r2+1]
	cpy.b 0,[r2+2]
	lea [r5+buff],r1
	printf '%s',r1
	ret

printit:	;print letter R8 followed by value R9
		;pres R0,R1
	tst r9
	beq print2
	pshm r0,r1
	printf '%c%d\n',r8,r9
	popm r1,r0
print2:	ret

SEEK:		;seek R0 to offset R8, old offset R9
		;pres R0
	cmp r8,r9
	ble sk1
	psh r8
	psh r0
	clr r8
	clr r9
	lcall r0,FP_SEEK
	pop r0
	pop r8
	clr r9
sk1:	sub r9,r8
	tst r8
	beq sk3
	cpy r8,r11
sk2:	getc r0		;just read R8 chars
	dec r11
	tst r11
	bne sk2
sk3:	ret

***************************
*** End DISPLAY section ***
***************************

ver_m:	dc 10,'diff v1.2',10,0
fnf_m:	dc 10,'File not found',0
mark:	dc '---------------',10,0
fin_m:	dc '%d differences',10,12,0
fin1_m:	dc '1 difference',10,12,0
	
********************************************

	toolend toolb
nodeend toolb
	
.end
