* stdio/dir - test of new dir stuff
* all new implementation

.include 'tao'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,8192,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/DIR'
nodeend fi_cont

node tl_dir,TOOLTP,VP,TEMPLATE
	tool 'STDIO/DIR'
;
; output directory listing
; inputs:- none required
; r6=pipe control object pointer
; outputs
; sends filenames to stdout.
; terminates sending EOF.

;
; initialise flags - CT_USER1
;
sflag	= 1	;bitmasks
pflag	= 2
dflag	= 4

sbit	= 0	;bitnumbers
pbit	= 1
dbit	= 2

pagelen	= 24

	cpy	r7,r3
	qcall	LIB/ARGCARGV	;divide up names

	cpy r4,[r6+CT_USER2]
	if r8!=0
		lea opts,r1
		qcall LIB/OPTIONS	;proces options according to table
		qcall LIB/PROCESSARGS	;process remaining args
		qcall LIB/EXIT
	endif
	ret

	.align
opts:	;options table
	;consists of entries of format:
	; dc.i options_letter, action
	;actions can be one of:
	; routine   - gos this routine
	; OPT_IGN   - ignore option, leave in arg list		
	; OPT_SET+n - set bit n in CT_USER1	
	;terminate with 0,help,process

	dc.i ('s'), OPT_SET+sbit
	dc.i ('d'), OPT_SET+dbit
	dc.i 0
	dc.i help_m-opts	;help message text for /?
	dc.i process-opts

process:	;process each name
	cpy [r6+CT_USER2],r4
	cpy r1,r0
	allocstruct 256,r1
	qcall LIB/SPLITDIR
	cpy r1,r3		;wild match str
	cpy.b [r0],r8
	cpy r0,r14		;prefix
	gos p_one
	freestruct 256
	ret

p_one:		;here to process 1 dir
		;r0=dir, r3=wild, r14=prefix str (=r0)
	qcall LIB/OPENDIR
	cpy r0,r2
	loop
		cpy r2,r0
		qcall LIB/READDIR
		breakif r0=0
		cpy.b [r0+2],r8
		if r8=1
			cpy.b [r0+DE_NAME],r8
			if r8!='.'
				if [r6+CT_USER1]?sbit
					gos recurse
				endif
			endif
		endif
		psh r0
		cpy r3,r1
		qcall LIB/MATCHDIR
		pop r0
		if r8=0
			;matched
			cpy.b [r0+2],r8
			add DE_NAME,r0
			cpy r14,r15
			cps r15,r15,r13
			cpy.b [r15-1],r13
			if r13='/'
				if r8=0
					printf '%s%s\n',r14,r0
				else
					cpy.b [r0],r8
					if r8!='.'
						if [r6+CT_USER1]?dbit
							printf '%s%s/\n',r14,r0
						endif
					endif
				endif
			else
				if r8=0
					printf '%s/%s\n',r14,r0
				else
					cpy.b [r0],r8
					if r8!='.'
						if [r6+CT_USER1]?dbit
							printf '%s/%s/\n',r14,r0
						endif
					endif
				endif
			endif
		endif
	endloop
	cpy r2,r0
	qcall LIB/CLOSEDIR
	ret

recurse:	;here to recuse subdirs
	;r0=new DIRENT, r3 as p_one
	pshm r0,r2
	add DE_NAME,r0
	cpy r14,r1
	tao STRINGLEN
	psh r1		;nul at end
	cpy.b [r1-1],r8
	if r8!='/'
		cpy.b '/',[r1]
		inc r1
	endif
	cps r0,r1,r8
	cpy r14,r0
	gos p_one	;r3 still ok from before
	pop r1
	clr.b [r1]	;put back nul at end of prev
	popm r2,r0
	ret

help_m:		;help message
dc 'Usage:',10
dc 'DIR [options] files...',10
dc ' -s  include files in subdirectories',10
dc ' -d  list directory names',10
dc 'does not print or recurse into directory names beginning dot (.)'
dc 0

	toolend tl_dir
nodeend tl_dir

.end
