.include 'tao.inc'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/DOS2TAO'
nodeend fi_cont

node tl_pgm,TOOLTP,VP,TEMPLATE
	tool 'STDIO/DOS2TAO'
	;cat file(s)
	;inputs
	;r6=pipe object pointer
	;deletes any CR from input

	cpy	r7,r3
	qcall	LIB/ARGCARGV	;divide up names
	tst	r8
	beq	exit	;first skip past program name

	pshall
	cpy	512,r8
	qcall	LIB/MALLOC
	cpy	r0,[r6+CT_USER1]	;save pointer to line buffer
	popall
	tst	[r6+CT_USER1]
	beq	exit2	;no memory for line buffer

	cmp	1,r8
	beq	fromstdin	;get names from stdin

loop:	add	4,r0		;skip to next
	cpy	[r0],r1
	tst	r1
	beq	exit2	;exit after last param
	psh	r0
	gos	process
	pop	r0
	got	loop

fromstdin:	cpy	256,r8
	qcall	LIB/MALLOC
	tst	r0
	beq	exit2	;woops no line buffer
	cpy	r0,r3

loop1:	cpy	r3,r0
	qcall	LIB/GETS
	tst	r0
	beq	exit2	;exit on finish
	psh	r3
	cpy	r0,r1
	gos	process	;do action
	pop	r3
	got	loop1

exit2:	qcall	LIB/EXIT
exit:	ret

*filename string > r1

	structure
	pointer	SRCFILENAME
	pointer	SFILENAME
	pointer	FHANDLE
	pointer	THANDLE
	pointer	TEMPFILENAME
	pointer	TEMPMSG
	int64	SERVERSID
	size	VARSIZE

process:	allocstruct	VARSIZE,r7
	cpy	r1,[r7+SRCFILENAME]	;save filename pointer
	cpy	r1,r0
	qcall	LIB/GETDSID
	tst	r8
	beq	error
	cpy.l	r9,[r7+SERVERSID]	;save temp file server ID
	cpy	r0,[r7+SFILENAME]	;save adjusted pointer

	qcall	SERVER/SV_TEMP
	tst	r8
	beq	error
	cpy	r0,[r7+TEMPMSG]
	cpy	r1,[r7+TEMPFILENAME]

	cpy	[r7+SRCFILENAME],r0
	cpy	FP_READ|FP_CHECK,r8	;check present
	qcall	CLASS/FILE
	tst	r0
	beq	error1	;no such file
	cpy	r0,[r7+FHANDLE]	;save file handle

	cpy	[r7+TEMPFILENAME],r0
	cpy	FP_WRITE,r8
	qcall	CLASS/FILE
	tst	r0
	beq	error2	;no temp file
	cpy	r0,[r7+THANDLE]	;save temp file handle

	;here to process file
	loop
		cpy [r7+FHANDLE],r0	;source file handle
		getc r0
		breakif r8=EOF
		if r8<>CR
			cpy [r7+THANDLE],r0	;temp file handle
			putc r8,r0
		endif
	endloop

	;end of file
	cpy	[r7+THANDLE],r0
	lcall	r0,FP_CLOSE	;close temp file
	tst	r8
	bne	error2	;error closeing temp file
	cpy	[r7+FHANDLE],r0
	lcall	r0,FP_CLOSE	;close src file

	cpy.l	[r7+SERVERSID],r9
	cpy	[r7+SFILENAME],r1
	qcall	SERVER/SV_DELETE	;delete src filename

	cpy.l	[r7+SERVERSID],r9
	cpy	[r7+SFILENAME],r0
	cpy	[r7+TEMPFILENAME],r1
	qcall	SERVER/SV_RENAME	;rename temp file to src name

	cpy	[r7+SRCFILENAME],r0
	printf	'Converted %s to Taos format\n',r0
	stdout	r0
	lcall	r0,FP_FLUSH

	cpy	[r7+TEMPMSG],r0
	freenode	r0	;dump temp name string node
	freestruct	VARSIZE
	ret

*error during conversion process

error3:	cpy	[r7+THANDLE],r0
	lcall	r0,FP_CLOSE	;close temp file
error2:	cpy	[r7+FHANDLE],r0
	lcall	r0,FP_CLOSE	;close src file
	cpy	[r7+TEMPFILENAME],r1
	cpy.l	[r7+SERVERSID],r9
	qcall	SERVER/SV_DELETE	;delete temp file
error1:	cpy	[r7+TEMPMSG],r0
	freenode	r0	;dump temp name string node
error:	freestruct	VARSIZE
	ret

	toolend tl_pgm
nodeend tl_pgm

.end
