;
; Andy Stout, C.A.Hinsley
; 1/2/92  text search. Read text lines from input, if the line contains
; the required string then output to stdout, else discard the line
;
; inputs
; r6=pipe object pointer
;
.include 'tao.inc'

	
.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring FI_CONTM2,'STDIO/FIND'
nodeend fi_cont

node tl_fi_ts,TOOLTP,VP,TEMPLATE
	tool 'STDIO/FIND'
;
; assorted constants
MAXLINE	= 200	;maximum line size
;
; This tool uses
; CT_USER1 file* of input
; CT_USER2 for temp buffer pointer
; CT_USER3 for pointer to string to find
;
	cpy	r7,r3		;stack reference
	qcall	LIB/ARGCARGV	;setup argv block
	tst	r8
	beq	exit
;
; two parameters, assumed to be <string> <filename>
	if	r8=3		;got two params?
	  cpy	[r0+4],r2		;1st param pointer
	  cpy	[r0+8],r1		;2nd param pointer
	  cpy	r2,[r6+CT_USER3]	;save string pointer

	  cpy	r1,r0		;filename pointer
	  lea	accessm,r1		;access mode
	  psh	r0
	  qcall	LIB/FOPEN		;open file
	  pop	r1
	  if	r0=NULL
	    printf	'Cannot find object "%s"\n',r1
	    got	finish
	  endif
	  cpy	r0,[r6+CT_USER1]	;save file*
;
; only one parameter, assume stdin, <string>
	elseif	r8=2		;only one param
	  cpy	[r0+4],r1		;1st param pointer
	  cpy	r1,[r6+CT_USER3]	;save string pointer

	  stdin	r0
	  cpy	r0,[r6+CT_USER1]	;save file*
	else
	  printf	'Usage:\nFIND <string> <filename> (search file for string)\n'
	  printf	'FIND <string>            (search stdin for string)\n'
	  got	finish
	endif

	cpy	MAXLINE*2,r8		;size of block required
	qcall	LIB/MALLOC
	cpy	r0,[r6+CT_USER2]	;save buffer start

	cpy	[r6+CT_USER3],r0	;string to find
	qcall	LIB/STRLOWC		;lowercase string

top:	  cpy	[r6+CT_USER2],r0	;buffer pointer
	  cpy	[r6+CT_USER1],r1	;file*
	  cpy	MAXLINE,r8		;buffersize
	  qcall	LIB/FGETS		;get line from file*
	  cmp	NULL,r0		;eof?
	  beq	finish
;
; if this line [r0] contains the string then send to stdout
	  cpy	[r6+CT_USER2],r0	;buffer pointer
	  lea	[r0+MAXLINE],r1
	  cps	r0,r1,r8	;make a copy of line
	  sub	r8,r0	;back to first copy
	  qcall	LIB/STRLOWC		;lowercase string
	  cpy	[r6+CT_USER3],r1	;string to find
	  qcall	LIB/STRSTR
	  if	r0!=NULL		;found?
	    cpy	[r6+CT_USER2],r0	;buffer pointer start
	    add	MAXLINE,r0	;print un-lowercased line
	    printf	'%s',r0
	  endif
	got	top		;do next line

finish:	qcall	LIB/EXIT		;close opened files
exit:	ret

accessm:	dc.b	'r',0

	toolend tl_fi_ts
nodeend tl_fi_ts

.end
