;
; A Stout 2/12/94
; describe purpose of every line.
; all characters to the right of a ';' (semicolon) character are
; comments, and are ignored by the assembler
; This file actually contains two parts, a control object and a tool.
; They do not need to be in the same source file.

;
; pull in standard macros from VP/INCLUDE/TAO.INC
.include 'tao.inc'

;
; specify where the control object should go
; because this file is called hello.asm, output will be
; STDIO/HELLO.CTL
.ctlprefix 'STDIO/'

;
; This is the code for the control object HELLO, which will
; assemble into HELLO.CTL which calls HELLO.00
; It has a standard header followed by a list of tools to be run
; in sequence.

;
; 'node' see VP/INCLUDE/TAO_EQUS.INC
; parameters to node are:
; 1. <name>, used to calculate the length of this node
; 2. node_type, define this node as a control object
; 3. zero for control object
; 4. flags, this node is in template format & uses standard i/o tools
node fi_cont,CONTROLTP,0,TEMPLATE|STDIO

;
; 'control' see VP/INCLUDE/TAO_EQUS.INC
; parameters to control are:
; 1. tool pointer, always null for template
; 2. stack size
; 3. flags, defines allowed input mail types
; 4-7 initial values for CT_USER1 .. 4
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0

;
; 'component' see VP/INCLUDE/TAO_EQUS.INC
; parameters to component are:
; 1. offset to name of the tool to run,
;   ie string start address - node start address
	component fi_contm2-fi_cont

;
; 'component' see VP/INCLUDE/TAO_EQUS.INC
; parameters to component are:
; none, this just marks the end of the current component
	compend

;
; 'tstring' see VP/INCLUDE/TAO_EQUS.INC
; parameters to tstring are:
; 1. name of this string
; 2. tool to be run by the control object
	tstring fi_contm2,'STDIO/HELLO'

;
; 'nodeend' see VP/INCLUDE/TAO_EQUS.INC
; parameters to nodeend are:
; 1. <name> matching name given at 'node'
nodeend fi_cont


;
; This is the code for the tool HELLO, which will assemble into HELLO.00
; called by HELLO.CTL

;
; 'node' see VP/INCLUDE/TAO_EQUS.INC
; parameters to node are:
; 1. <name>, used to calculate the length of this node
; 2. node_type, define this node as a tool
; 3. define that this tool will run on any VP processor
; 4. flags, this node is in template format
node tl_pgm,TOOLTP,VP,TEMPLATE

;
; 'tool' see VP/INCLUDE/TAO_EQUS.INC
; parameters to tool are:
; 1. name of this tool, as this is a VP tool, output will be
;    STDIO/HELLO.00
	tool 'STDIO/HELLO'

;
; when execution begins, r6 will point to the control object node
; defined above.  So that (for example) the initial values of
; CT_USER1..4 can be accessed using cpy [r6+CT_USER1],r8

;inputs
;r6=pipe object pointer

;
; convert the command line into an argcargv structure
; reserve space & initailise global variables used by the
; stdio library
	cpy	r7,r3				;remember stack start
	qcall LIB/ARGCARGV		;divide up names
;
; lib/argcargv returns
; r0 = pointer to argv, array of pointers to command line parameters
; r8 = argc, number of parameters, including program name ie >= 1
	if r8>0					;argcargv opened library ok

;
; send 'hello world', carriage return to standard out
	  printf "hello world\n"

;
; close all open files, windows, free memory, restore stack
; (don't run this if lib/argcargv did not open library)
	  qcall LIB/EXIT
	endif
;
; return to the shell
	ret
;
; toolend, nodeend. (these two lines always seem to occur together)
;
; 'toolend' see VP/INCLUDE/TAO_EQUS.INC
; parameters to toolend are:
; 1. <name>, this must match the name given at the start of the tool node
	toolend tl_pgm

;
; 'nodeend' see VP/INCLUDE/TAO_EQUS.INC
; parameters to node are:
; 1. <name>, this must match the name given at the start of the tool node
nodeend tl_pgm

;
; force end of source file
.end

