.include 'tao.inc'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control 0,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/SAVAGE'
nodeend fi_cont

node tl_pgm,TOOLTP,VP,TEMPLATE
	tool 'STDIO/SAVAGE'
	;
	;inputs
	;r6=pipe object pointer

	cpy	r7,r3
	qcall	LIB/ARGCARGV
	tst	r8
	beq	exit

	printf '\n\nThe Savage Benchmark, measures the speed and accuracy of elementary\n'
	printf 'functions.  The final value should be 2500.0 exactly, so any difference\n'
	printf 'from this figure is a measure of their cumulative accuracy.\n\n'
	printf 'Start ...'
	
	tao	gettime		;read time into r8
	cpy	r8,r12		;save start time

	cpy.d	1.0,r8
	for	2499,r10		;loop count
	  mul.d	r8,r8
	  qcall	MATH/SQRT
	  qcall	MATH/LOG
	  qcall	MATH/EXP
	  qcall	MATH/ATAN
	  qcall	MATH/TAN
	  add.d	1.0,r8
	next	r10

	cpy.d	r8,r10
;
; read clock again, print execution time
	tao	gettime		;get end time
	sub	r12,r8
	i2l	r8
	l2d	r8
	mul.d	64e-3,r8		;convert to milliseconds
	printf ' Stop   time taken = %.1f ms   final value = %.6f\n\n',r8.d,r10.d
	cpy.d	r8,r12
;
; print error
	sub.d	2500.0,r10
	if.d	r10<0		;error=abs(2500-r8)
	  neg.d	r10
	endif

	printf '(The best error which can be obtained using doubles is 1.177e-9)\n'
	printf '(An error smaller than 1e-6 would be acceptable)\n'
	printf '(The smallest error in the shortest period of time is better)\n\n'

	printf 'Results:-  Error = %e   Time = %.1f ms\n',r10.d,r12.d

finish:	qcall	LIB/EXIT
exit:	ret


	toolend tl_pgm
nodeend tl_pgm

.end
