;
; Andy Stout
; 31/1/92  Text search, display chunk of binary or text file
; containing given string
; This is useful to find a word & then display it in context
;
; inputs
; r6=pipe object pointer
;
.include 'tao.inc'

	
.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring FI_CONTM2,'STDIO/SEARCH'
nodeend fi_cont

node tl_fi_ts,TOOLTP,VP,TEMPLATE
	tool 'STDIO/SEARCH'
;
; assorted constants
BUFFSIZE	= 200	;working buffersize
;
; This tool uses
; CT_USER1 file* of input
; CT_USER2 for temp buffer pointer
; CT_USER3 for pointer to string to find
;
	cpy	r7,r3		;stack reference
	qcall	LIB/ARGCARGV	;setup argv block
	tst	r8
	beq	exit

	if	r8!=3
	  printf	'Usage:\nSEARCH <filename> <string> (search file for string)\n'
	else
	  cpy	[r0+4],r1		;1st param pointer
	  cpy	[r0+8],r2		;2nd param pointer
	  cpy	r2,[r6+CT_USER3]	;save 2nd parameter

	  pshm	r1,r2
	  cpy	BUFFSIZE,r8		;size of block required
	  qcall	LIB/MALLOC
	  if	r0=NULL
	    freestruct 8		;tidy stack
	    got	failexit		;no buffer
	  endif
	  cpy	r0,[r6+CT_USER2]	;save buffer start
	  popm	r2,r1

	  cpy	r1,r0		;filename pointer
	  psh	r1
	  lea	accessm,r1		;access mode
	  qcall	LIB/FOPEN		;open phone file
	  pop	r1
	  cpy	r0,[r6+CT_USER1]	;save file*
	  if	r0=NULL
	  printf	'File "%s" not found\n',r1
	    got	failexit		;no file
	  else
;
; search forwards from the current file position
again:	  cpy	[r6+CT_USER1],r0	;get file*
	  cpy	[r6+CT_USER3],r1	;string to search for
	  qcall	LIB/FSEARCH		;search for string
	  if	r8!=1		;string not found
	    got	failexit
	  endif
;
; the string has been found, get that line of text into a buffer
	  cpy	[r6+CT_USER1],r0	;get file*
	  psh	r1	    
	  qcall	LIB/FTELL		;find current position
	  pop	r1
;
; search back BUFFSIZE/2 bytes from word
; (check for near to start of file)
	  if	r8>BUFFSIZE/2	;worth rewinding?
	      cpy	-BUFFSIZE/2,r8	;rewind
	      cpy	1,r9
	      cpy	BUFFSIZE/2,r10	;constant
	    else
	      cpy	r8,r10		;offset
	      cpy	0,r8		;seek to start of file
	      cpy	0,r9
	    endif 
	    qcall	LIB/FSEEK

	    cpy	[r6+CT_USER2],r0	;buffer
	    cpy	[r6+CT_USER1],r1	;get file*
	    cpy	BUFFSIZE,r8		;size of each object
	    cpy	1,r9		;number of objects
	    qcall	LIB/FREAD		;read a block into [r0]
;
; [r0] is now a buffer containing the word searched for in the middle!
; display entire block
	    cpy	NULL,[r0+(BUFFSIZE-1)]

	    printf	'E%s\n',r0		;send to stdout
	    gos	pause
	    got	again		;do it again
	    
	  endif	;file opened ok
	endif	;parameters ok

failexit:	qcall	LIB/EXIT		;close opened files
exit:	ret

;
; pause
; print continue message to stdout, then wait for key from stdin
pause:	psh	r0
	lea	continue,r0
	qcall	LIB/PUTS		;to stdout
;
; get key from stdin
	qcall	LIB/GETCHAR		;key in r8 from stdin
	pop	r0
	ret

accessm:	dc.b	'rb',0		;read binary file
continue:	dc.b	10,'press any key to continue',10,0

	toolend tl_fi_ts
nodeend tl_fi_ts

.end
