.include 'tao.inc'

.ctlprefix 'STDIO/'

node profproc,CONTROLTP,0,TEMPLATE|STDIO|HERE
	control NULL,1024,DATATP|SYSTEMTP|STREAMTP|FLOWTP,0,0,0,0
	component lnmthd2-profproc
	compend
	tstring lnmthd2,'STDIO/SPEED'
nodeend profproc

node tl_prof,TOOLTP,VP,TEMPLATE
	tool 'STDIO/SPEED'

	cpy	r7,r3
	qcall	LIB/ARGCARGV
	tst	r8	;failed ?
	beq	exit	;yes so abandon

* scan parameter list & extract flags

	bool	r8 = 1, global		;no params = global speed test

	cpy	[r0+4],r1	;get pointer to param
	cpy.b	[r1],r15	;1st char
	bool	r15='/', help
		;assume numeric parameter = processor
	cpy	r1,r0
	qcall	LIB/ATOCHIP
		;check R8 is valid processor
	psh	r8
	cpy	r8,r9
	clr	r8		;no mem required
	clr	r10		;any type
	tao	FINDTYPE
	pop	r11
	bool	r8=0, err
	bool	r9!=r11, err
	div	1024,r8		;mem to K
	printf	"Processor %d - %dK %02d ",r11,r8,r10
	cpy	r10,r8
	qcall	LIB/PROCNAME	;find name
	printf	"%s\n",r0

* One processor speed test

	psh	1			;constant 1 - single processor
	allocmem	12		;space to save child ids
	tst	r8
	beq	exit2	;no memory
	pshm	r8,r0

	getmyid	r6	;get my ID
	lea	speedchld,r0	;pointer to child template
	opendevice	r0,r8,r9,r11
	cpy	[r7],r0
	cpy.l	r8,[r0]		;save id
	got	askspeed

*-------------------------------------*

err:	printf	"No such processor\n"
	got	exit2

help:	lea	help_msg,r0
	printfp	r0
	got	exit2

*----------------------------------*

* global speed test

global:	tao	NETINFO
	psh	r10		;save number of child entries
	mul	8,r10
	add	4,r10
	allocmem	r10	;get child array mem
	tst	r8
	beq	exit2	;no memory

	pshm	r8,r0	;save ID block

	cpy [r7+8],r10
	clr	r11
	cpy	r0,r1
	getmyid	r6	;get my ID
	lea	speedchld,r0	;pointer to child template
	openglobal	r0,r1,r8,r9,r10,r11

*ask each child for it's speed mesurement

askspeed:	cpy	[r7],r3
	clr.l	[r6+CT_USER1]	;reset vpspeed's
	clr.l	[r6+CT_USER3]	;reset vpspeed's

	cpy	[r7+8],r10
	cpy	0,r14	;start at 0 sent
	forsp	r10

	tst	[r3]
	beq	empty
	lea	speedmsg,r0
	copynode	r0
	tst	r8
	beq	empty

	inc	r14	;increment sent count
	cpy.l	[r3],r8
	cpy.l	r8,[r0+(MG_DTM+8)]
	getmyid	r6
	cpy.l	r8,[r0+(MG_DTM+0)]
	cpy.l	r8,[r0+(MG_DTM+16)]
	sendmail	r0

empty:	add	8,r3
	nextsp

*update screen and wait for r14 replies

getnext:	lea	[r6+CT_MAILBOX],r0
	readtype	r0,DATATP|MOUSETP

	cmp	MOUSETP,r8
	beq	gotquit	;have got a mouse

*got a speed message

	cpy	[r1],r8
	cpy	[r1+4],r9
	cpy	[r1+8],r10
	cpy	[r1+12],r11
	add	r8,[r6+CT_USER1]
	add	r9,[r6+CT_USER2]
	add	r10,[r6+CT_USER3]
	add	r11,[r6+CT_USER4]	;add up SPEED's
	freenode	r0	;dump speed message

	dec	r14
	tst	r14
	bgt	getnext	;look for more if not got all yet

	cpy	[r6+CT_USER1],r8
	i2l	r8
	l2d	r8
	div.d	1000000,r8
	printf	'VP MIOPS  = %10f\n',r8.d

	cpy	[r6+CT_USER2],r8
	i2l	r8
	l2d	r8
	div.d	1000000,r8
	printf	'VP MLOPS  = %10f\n',r8.d

	cpy	[r6+CT_USER3],r8
	i2l	r8
	l2d	r8
	div.d	1000000,r8
	printf	'VP MFOPS  = %10f\n',r8.d

	cpy	[r6+CT_USER4],r8
	i2l	r8
	l2d	r8
	div.d	1000000,r8
	printf	'VP MDOPS  = %10f\n',r8.d
.if 0
	;print local speed info - more for kernel checks, not std
	cpy	VAR_PROCPOWER,r0
	tao	SYSVARADDR
	cpy.l	[r0+8],r8	;myspeed
	printf	'\n\nMyspeed=%d, Fratio=%d\n',r8,r9
.endif
	got	exitnow

*got mouse message
	
gotquit:	freenode	r0	;dump message

*ask each child to quit

exitnow:	cpy	[r7],r3
	cpy	[r7+8],r10
	forsp	r10
	tst	[r3]
	beq	empty1

retry:	lea	quitmsg,r0
	copynode	r0
	tst	r8
	bne	sendq
	delay	100000/64
	got	retry

sendq:	cpy.l	[r3],r8
	cpy.l	r8,[r0+(MG_DTM+8)]
	sendmail	r0
empty1:	add	8,r3
	nextsp

*dump ID array

exit1:	popm	r0,r8,r10
	freemem	r0,r8	;free array mem

exit2:	qcall	LIB/EXIT
exit:	ret

	msg	speedmsg,DATATP
	dc.l	0
	dc.l	0
	dc.l	0
	dtmend	speedmsg
	dc.i	NULL	;space for VP IOPS
	dc.i	NULL	;space for VP LOPS
	dc.i	NULL	;space for VP FOPS
	dc.i	NULL	;space for VP DOPS
	msgend	speedmsg

	msg	quitmsg,SYSTEMTP
	dc.l	0
	dc.l	0
	dtmend	quitmsg
	msgend	quitmsg

node speedchld,CONTROLTP,0,TEMPLATE	;control for child
	control NULL,1024,DATATP|SYSTEMTP,0,0,NULL,NULL
	component pmthd2-speedchld
	compend
	tstring pmthd2,'DESK/VPSPEED'
nodeend speedchld

help_msg: dc	"Usage:",10
	dc	"SPEED		(speed of whole network)",10
	dc	"SPEED <n>	(speed of processor n)",10,0

	toolend tl_prof
nodeend tl_prof

.end
