;
; (C) Andy Stout  Standard Pipe tools 6/11/92
; STRINGS : print any ascii strings found in a binary file
;
.include 'tao.inc'

.ctlprefix 'STDIO/'

node fi_cont,CONTROLTP,0,TEMPLATE|STDIO
	control NULL,1024,FLOWTP|DATATP|SYSTEMTP|STREAMTP,0,0,0,0
	component fi_contm2-fi_cont
	compend
	tstring fi_contm2,'STDIO/STRINGS'
nodeend fi_cont

node tl_fi_strings,TOOLTP,VP,TEMPLATE
	tool 'STDIO/STRINGS'
;
;strings pipe tool.  Print any sensible strings from an executable tool
;inputs
;r6=pipe object pointer
	cpy	r7,r3		;stack reference
	qcall	LIB/ARGCARGV
	tst	r8	;failed ?
	beq	exit	;yes so abandon
;
; if a filename has been specified then use that file for stdin
; otherwise open stdin.  Rely on LIB/EXIT to close any opened file
	if	r8=2
	  cpy	r0,r3		;copy argv ptr
	  cpy	[r3+4],r0		;ARGV[1]
	  lea	access,r1		;fopen access mode
	  qcall	LIB/FOPEN
	  if	r0=NULL		;successful?
	    cpy	[r3+4],r0		;point to filename again
	    printf	'STRINGS: fopen("%s") failed\n',r0
	    got	eoi		;flush stdout
	  endif
	  cpy	r0,r2		;file* of file
	else
	  if	r8=1		;no parameters
	    stdin	r2		;use standard in instead
	  else
	    printf	'TRY: strings <filename>\n'
	    got	eoi		;flush stdout
	  endif
	endif
	stdout	r3		;all output to stdout
;
; a good string is defined as starting with A..z, but then may
; contain any char 0..z
;
; get chars from stdin until char is good
bad:	getc	r2	;get one char from stdin

	cmp	EOF,r8
	beq	eoi	;if error or end of input then close

	cmp	'z',r8
	bgt	bad
	cmp	'A',r8
	blt	bad

	putc	r8,r3	;send the 1st good char
;
; get chars from stdin until char is bad
good:	getc	r2	;get one char from stdin

	cmp	EOF,r8
	beq	eoi	;if error or end of input then close

	cmp	' ',r8
	blt	endgood
	cmp	'z',r8
	bgt	endgood

	putc	r8,r3
	got	good
;
; the first bad char has been found, print LF to end a good string
endgood:	putc	LF,r3
	got	bad

eoi:	qcall	LIB/EXIT

exit:	ret

access:	dc.b	'r',0		;fopen access mode, read only

	toolend tl_fi_strings
nodeend tl_fi_strings

.end
