.if ~?def(DEF_IO_EQUS)
DEF_IO_EQUS=TRUE

;buffer size

IO_BUFSIZE	=	2048*4

;flowrate

IO_FLOWRATE	=	8

;FP_FLAGS bit definitions

	dbitstart
	dbit	FP_CHECK,BFP_CHECK	;check present on open
	dbit	FP_READ,BFP_READ	;read mode flag (1=can read)
	dbit	FP_WRITE,BFP_WRITE	;write mode flag (1=can write)
	dbit	FP_APPEND,BFP_APPEND	;write with append flag (1=append)
	dbit	FP_CREATE,BFP_CREATE	;delete on open (1=create)
	dbit	FP_TEMP,BFP_TEMP	;delete on close flag (1=delete)
	dbit	FP_EOF,BFP_EOF	;end of file flag (1=EOF)
	dbit	FP_ERROR,BFP_ERROR	;error flag (1=error)
	dbit	FP_STATE,BFP_STATE	;last r/w mode flag (1=write)

;FILE* OO structure

	structure
	struct	FP_NODE,OO_DATA	;oops node
	pointer	FP_BUFP	;buffer position pointer
	pointer	FP_BUFE	;end of buffer pointer
	pointer	FP_BLOCK	;pointer to current block
	int32	FP_FLAGS	;see above FP_? bits
	int32	FP_UNGET	;unget buffer area (2 chars, max)
	size	FP_SIZE

;Standard io variables structure

	structure
	pointer	FP_STDIN	;stdin stream FILE*
	pointer	FP_STDOUT	;stdout stream FILE*
	pointer	FP_STDERR	;stderr stream FILE*
	struct	IO_ILIST,LH_SIZE	;input message list header
	pointer	IO_INEXT	;next input message pointer
	pointer	IO_DATATP	;pointer to params message
	pointer	IO_PIPE	;pointer to pipe init message
	int32	IO_ISEC	;input sequence number
	int32	IO_OSEC	;output sequence number
	int32	IO_CIN	;amount of characters read in
	int32	IO_BOUTA	;amount of blocks sent out acknowledged
	int32	IO_COUTA	;amount of chars sent out acknowledged
	int32	IO_ASTATE	;acknowledge state
	int64	IO_FLOWID	;flow message mail box ID
	int32	IO_BYTES	;size of vars
	size	IO_SIZE	;size

*file stream structure

	structure
	struct	ST_FILE,FP_SIZE	;stream FILE*
	int32	ST_OFFSET	;next offset in file
	int64	ST_SERVERID	;server ID
	size	ST_FILENAME	;name of file

*fifo buffer structure

	structure
	struct	FF_NODE,MN_SIZE	;mem node
	struct	FF_LIST,LH_SIZE	;buffer list
	int32	FF_INPNT	;input pointer
	int32	FF_INBUF	;input buffer pointer
	int32	FF_OUTPNT	;output pointer
	int32	FF_OUTBUF	;output buffer pointer
	int32	FF_BUFSIZE	;size of each buffer
	size	FF_SIZE

*Equates

NUL	=	0
EOF	=	-1
TAB	=	9
EOL	=	10	; End of line
LF	= 	10	; ASCII line feed 
FF = 12
CR	= 	13	; ASCII return
ESC	=	27
SPACE	= 	' '	; ASCII space 

*IO macros live here

.imacro	putc	;char,stream
	;outputs char to stream
	.check	%n=2	;putc: requires 2 parameters
	.check	%2<>R1	;putc: R1 illegal as FILE *
	cpy	[%2+FP_BUFP],r1
	cmp	[%2+FP_BUFE],r1
	bne	%Lb
	copy %1,r8	;copy is Chris's macro=CPY
	copy %2,r0	;  if SRC<>DST already
	psh	r15
	lcall r0,FP_BPUT	;block put
	pop	r15
	got	%Lc
%Lb:
	cpy.b %1,[r1]
	inc r1
	cpy r1,[%2+FP_BUFP]
%Lc:
.endm

.imacro	putw	;word,stream
	;outputs word to stream
	.check	%n=2	;putw: requires 2 parameters
	.check	%2<>R1	;putw: R1 illegal as FILE *
	copy %1,r8
	psh	%1
	cpy	[%2+FP_BUFP],r1
	qputc r8,%2,r1
	cpy	[r7],r8
	lsr	8,r8
	qputc r8,%2,r1
	cpy	[r7],r8
	lsr	16,r8
	qputc r8,%2,r1
	cpy	[r7],r8
	lsr	24,r8
	qputc r8,%2,r1
	cpy	r1,[%2+FP_BUFP]
	pop r8
.endm

.imacro	qputc	;char,stream,ptr
	;same as putc, but ptr in reg
	.check	%n=3	;qputc: requires 3 parameters
	.check	%2<>R1	;qputc: R1 illegal as FILE *
	cmp	[%2+FP_BUFE],%3
	bne	%Lb
	cpy	%3,[%2+FP_BUFP]
	copy %1,r8	;copy is Chris's macro=CPY
	copy %2,r0	;  if SRC<>DST already
	psh	r15
	lcall r0,FP_BPUT	;block put
	pop	r15
	copy r1,%3
	got	%Lc
%Lb:
	cpy.b %1,[%3]
	inc	%3
%Lc:
.endm

.imacro	getc	;stream
	;gets char from stream
	.check	%n=1	;getc: requires 1 parameter
	.check	%1<>R1	;getc: R1 illegal as FILE *
	cpy	[%1+FP_BUFP],r1
	cmp	[%1+FP_BUFE],r1
	bne	%Lb
	copy %1,r0	;copy is Chris's macro=CPY
	psh	r15
	lcall r0,FP_BGET	;get block tool
	pop	r15
	got	%Lc
%Lb:
	cpy.b [r1],r8
	inc	r1
	cpy	r1,[%1+FP_BUFP]
%Lc:
.endm

.imacro	getw	;stream
	;get int32 from stream (4 bytes from little endian binary)
	.check	%n=1	;getw: requires 1 parameter
	.check	%1<>R1	;getw: R1 illegal as FILE *
	.check	%1<>R15	;getw: R15 illegal as FILE *
	.check	%1<>R10	;getw: R10 illegal as FILE *

	psh	r10
	cpy	[%1+FP_BUFP],r1
	qgetc %1,r1
	cpy	r8,r10	;lsb b0
	qgetc %1,r1
	asl	8,r8
	add	r8,r10	;b1
	qgetc %1,r1
	asl	16,r8
	add	r8,r10	;b2
	qgetc %1,r1
	asl	24,r8
	add	r10,r8	;msb b3 to r8
	cpy	r1,[%1+FP_BUFP]
	pop	r10
.endm

.imacro	qgetc	;stream,ptr
	;same as getc, but ptr in reg
	.check	%n=2	;qgetc: requires 2 parameters
	.check	%1<>R1	;qgetc: R1 illegal as FILE *
	cmp	[%1+FP_BUFE],%2
	bne	%Lb
	cpy	%2,[%1+FP_BUFP]
	copy %1,r0	;copy is Chris's macro=CPY
	psh	r15
	lcall r0,FP_BGET	;get block tool
	pop	r15
	copy r1,%2
	got	%Lc
%Lb:
	cpy.b [%2],r8
	inc	%2
%Lc:
.endm

.imacro	ungetc	;val,stream
	.check	%n=2	;ungetc: requires 2 parameters
	.check	%2<>R1	;ungetc: R1 illegal as FILE *
	cpy	[%2+FP_BUFP],r1
	dec	r1
	cpy.b %1,[r1]
	cpy	r1,[%2+FP_BUFP]
.endm

*get std? pointers

.imacro	stdin
	cpy	[r6+CT_STDIO],%1
	cpy	[%1-(IO_SIZE-FP_STDIN)],%1
.endm

.imacro	stdout
	cpy	[r6+CT_STDIO],%1
	cpy	[%1-(IO_SIZE-FP_STDOUT)],%1
.endm

.imacro	stderr
	cpy	[r6+CT_STDIO],%1
	cpy	[%1-(IO_SIZE-FP_STDERR)],%1
.endm

*open/close io macros

.imacro	openio	;var size, error label
	.check	%n=2
	cpy	%1,r8
	qcall IO/IO_OPEN	;open io channels
	tst	r8
	beq	%2	;exit if error/quit
.endm

.imacro	closeio
	qcall IO/IO_CLOSE
.endm

* Macros for MB chars and Wide chars

;15jun94 ARH written mbtowc,wctomb,getwc,putwc
;20jun94 ARH completely revised

;These convert using the algorithms defined by ARH to provide ASCII
;like Multi Byte (MB) streams while ISO10646-1:1993 Wide Chars (WC).

;Algorithm:
;MB character is a sequence of zero or more bytes $80..$FF
;followed by a byte of $00..$7F.
;The byte $00 only ever occurs for the character NUL.
;codes are little endian, 7 bits encoded per byte.
;e.g.
;1byte:  WC = terminalchar
;2bytes: WC = (prefix & $7F) + terminalchar<<7
;3bytes: WC = (prefix1 & $7F) + (prefix2 & $7F)<<7 +  terminalchar<<14
;single byte encodes 128 chars, 2bytes 16256 chars, 3bytes 2080768 chars

;mbtowc converts multibyte chars to wide chars (ISO10646-1)
;e.g. mbtowc r0,r8,r9,r15 - from [r0] returns result in r8, r0 advanced

.imacro mbtowc	;mb, wc, tmp1, tmp2
	.check %N=4
	clr %2
	clr %4
	loop
		cpy.b [%1],%3
		inc %1
		breakif %3<$80
		and $7F,%3
		asl %4,%3
		or %3,%2
		add 7,%4
	endloop
	asl %4,%3
	or %3,%2
.endm

;wctomb converts wide chars back to mb chars
;e.g. wctomb r8,r0,r9 - puts r8 to [r0], r0 advanced
;nb: %1 is destroyed by wctomb!

.imacro wctomb	;wc, mb, tmp
	while %1>=$80
		cpy %1,%3
		or $80,%3
		cpy.b %3,[%2]
		inc %2
		lsr 7,%1
	endwhile
	cpy.b %1,[%2]
	inc %2
.endm


;getwc converts gets a wide (ISO10646-1) char from a multibyte stream
;e.g. getwc r0

.imacro getwc	;stream
	copy %1,r0
	pshm r10,r11
	clr r10
	clr r11
	loop
		getc r0
		breakif r8<$80
		and $7F,r8
		asl r11,r8
		or r8,r10
		add 7,r11
	endloop
	asl r11,r8
	or r10,r8
	popm r11,r10
.endm

;putwc puts wide chars into mb file
;e.g. putwc r8,r0

.imacro putwc	;wc, stream
	copy %1,r8
	copy %2,r0
	while r8>=$80
		psh r8
		or $80,r8
		putc r8,r0
		pop r8
		lsr 7,r8
	endwhile
	putc r8,r0
.endm

.endif
