.if ~?def(DEF_POSIX)
DEF_POSIX=TRUE

* Posix include file for VP
*
* usage:
* .include 'tao'
* .include 'posix'
*
* Defined in here are
* (a) all the structures needed by the posix API user.
* (b) value equates needed by the posix API user.
* (c) VP macros for all the posix API functions, either calling the
* function or performing the same inline.
*
* Copyright (C) 1994 Tao Systems Ltd.
* All Rights Reserved.
*
* Authors:
* Andy Henson
* ...

** Equates **

	structure		;TC_ returned by tcgetattr
	int32	TC_1
	int32	TC_2
	int32	TC_3
	int32	TC_4
	int32	TC_ISPEED
	int32	TC_OSPEED

;....

** Macros **

.imacro	access	;fileptr r0, type r8
	.check %N=2
	copy	%1,r0
	copy	%2,r8
	qcall LIB/ACCESS	;result in r8
.endm

;....

.imacro	cfgetispeed	;tcattrptr r0
	.check %N=1
	cpy	[%1+TC_ISPEED],r8	;result in r8
.endm

.imacro	cfgetospeed	;tcattrptr r0
	.check %N=1
	cpy	[%1+TC_OSPEED],r8	;result in r8
.endm

.imacro	cfputispeed	;tcattrptr r0, speed r8
	.check %N=2
	cpy	%2, [%1+TC_ISPEED]	;no result
.endm

.imacro	cfputospeed	;tcattrptr r0, speed r8
	.check %N=2
	cpy	%2, [%1+TC_OSPEED]	;no result
.endm

;....

** end posix.inc **

.endif
