.if ~?def(DEF_STRUCT00)
DEF_STRUCT00=TRUE

;
; Andy Stout standard stuctures definition macros
; AS 2/6/93 addition of LOOP/ENDLOOP and BREAKIF macros
; AS & AWE Sullivan 13/11/93 removed depth and layering limits
; AS 14/11/93 added<>to bool/notbool expressions
; AS 24/11/93 changed next/nextsp to use bgt rather than bne (safer!)
; AS 24/11/93 added continue/continueif to set of structures
; CH 28/11/93 added nextnode/lastnode to set of structures
; AS 8/6/94   use new .elseifnb
;
; Macros for some commonly used code structures
;
; IF/ELSEIF/ELSE/ENDIF
; LOOP/ENDLOOP/ENDLOOPBREAK
; CONTINUE/CONTINUEIF	jump to top of most recent loop
; BREAK/BREAKIF		jump to end of most recent loop
; NEXTNODE/LASTNODE	jump to end of most recent loop on list end
; WHILE/ENDWHILE
; REPEAT/UNTIL
; FOR/NEXT/FORSP/NEXTSP
;

__stkptr:=0	;initialise stack pointer
__stack0:=0	;clear all flags on stacktop
__stkfoundp:=0	;used by stksearch

;
; every new structure encountered is given a unique id
; when stacked,the structure id has flag showing what is on the stack
__scount:=0	;how many structures seen

;
; assembler variables are signed 64 bit
; limit is __noflags (1e6) structures per file (should be enough!)
__noflags	=$fffff	;mask off all flags
__ifflag	=$100000
__elseflag	=$200000
__elseifflag	=$400000
__repeatflag	=$800000
__whileflag	=$1000000
__forflag	=$2000000
__forspflag	=$4000000
__loopflag	=$8000000
__breakflag	=$10000000
__allloops	=__repeatflag|__whileflag|__forflag|__loopflag|__forspflag

;
; push the parameter supplied onto the stack
.imacro	stkpush	;structure system stack push
 .check	%N=1	;stkpush expects value to push
__stkptr:=__stkptr+1	;adjust stack pointer
	.eval __stkptr
__stack%E:=%1	;write to stack
.endm

;
; pop the top of stack into %E,adjust the stack pointer
.imacro	stkpop	;structure system stack pop
 .check	%N=0	;stkpop needs no parameters
	.eval __stkptr
 .check	%E>0	;more ends than starts!
	.eval __stack%E
__stkptr:=__stkptr-1	;adjust stack pointer
.endm

;
; return top of if stack in %E,do not change stkptr
.imacro	getstacktop
 .check	%N=0	;getstacktop needs no parameters
	.eval __stkptr
 .if %E=0
 .error stack is empty
 .else
	.eval __stack%E
 .endif
.endm

;
; search stack. search stack at %1 for flag(s) %2
; return first value on stack that is found in %E
.imacro	stksearch
 .check	%N=2	;stksearch requires stkptr,flags
	.eval (__stack%1&%2)	;only look at some bits
 .if %E=0	;no match
 .if %1>0
	.eval %1-1
	stksearch %E,%2
 .else
 .error search fallen off stack,structure not found
__stkfoundp:=0
 .endif
 .else
	.eval __stack%1
__stkfoundp:=%1
 .endif
.endm

;
; format eg r9>=0,generates cmp 0,r9 bge label
;
; 14/11/93 AS added<>as well as !=for not equal
; 24/1/92 AS if.d r8=1.234 now generates cmp.d 1.234,r8
; put constant on the right hand side of the expression
; This macro to be replaced by a user definable (source code generating)
; tool using .ASMFUNC bool,LIB/EXPR,pass a pointer to a string to be
; evaluated

.imacro	bool	;cond,label if TRUE
 .check	%N=2	;bool macro needs 2 args
 .ifnb	%1{&'<>',99}
	cmp%s %1{'<>',99},%1{1,'<>'}	;swap params
	bne	%2
 .elseifnb	%1{&'>=',99}
	cmp%s %1{'>=',99},%1{1,'>='};swap params
	bge	%2
 .elseifnb	%1{&'>',99}
	cmp%s %1{'>',99},%1{1,'>'}	;swap params
	bgt	%2
 .elseifnb	%1{&'<=',99}
	cmp%s %1{'<=',99},%1{1,'<='};swap params
	ble	%2
 .elseifnb	%1{&'<',99}
	cmp%s %1{'<',99},%1{1,'<'}	;swap params
	blt	%2
 .elseifnb	%1{&'!=',99}
	cmp%s %1{'!=',99},%1{1,'!='}	;swap params
	bne	%2
 .elseifnb	%1{'=',99}	;avoid &'=' as assembler then tries to do assignment
	cmp%s %1{'=',99},%1{1,'='}	;swap params
	beq	%2
 .elseifnb	%1{'!?',99}
	bit%s %1{'!?',99},%1{1,'!?'}	;swap params
	beq	%2
 .elseifnb	%1{'?',99}
	bit%s %1{'?',99},%1{1,'?'}	;swap params
	bne	%2
 .else
 .error Bad boolean %1
 .endif
.endm

.imacro	notbool	;cond,label if FALSE
 .check	%N=2	;Bool macro needs 2 args
 .ifnb	%1{&'<>',99}
	cmp%s %1{'<>',99},%1{1,'<>'};swap params
	beq	%2
 .elseifnb	%1{&'>=',99}
	cmp%s %1{'>=',99},%1{1,'>='};swap params
	blt	%2
 .elseifnb	%1{&'>',99}
	cmp%s %1{'>',99},%1{1,'>'}	;swap params
	ble	%2
 .elseifnb	%1{&'<=',99}
	cmp%s %1{'<=',99},%1{1,'<='};swap params
	bgt	%2
 .elseifnb	%1{&'<',99}
	cmp%s %1{'<',99},%1{1,'<'}	;swap params
	bge	%2
 .elseifnb	%1{&'!=',99}
	cmp%s %1{'!=',99},%1{1,'!='};swap params
	beq	%2
 .elseifnb	%1{'=',99}	;avoid &'=' as assembler then tries to do assignment
	cmp%s %1{'=',99},%1{1,'='}	;swap params
	bne	%2
 .elseifnb	%1{'!?',99}
	bit%s %1{'!?',99},%1{1,'!?'}	;swap params
	bne	%2
 .elseifnb	%1{'?',99}
	bit%s %1{'?',99},%1{1,'?'}	;swap params
	beq	%2
 .else
 .error Bad boolean '%1''
 .endif
.endm

.imacro	while
 .check	%N=1	;WHILE needs boolean
__scount:=__scount+1
	.eval __scount
__w%E:
	notbool%s %1,__out%E
	stkpush %E|__whileflag
.endm

.imacro	endwhile
 .check	%N=0	;no args to ENDWHILE
	stkpop
 .if %E&__whileflag=0	;should be while
 .error ENDWHILE without WHILE
 .else
	.eval %E&__noflags
	got	__w%E
__out%E:	;always generated
 .endif
.endm

.imacro	repeat
 .check	%N=0	;no args to REPEAT
__scount:=__scount+1	;new structure,only ever counts up
	.eval __scount
	stkpush	%E|__repeatflag	;push next label
	.eval __scount
__r%E:
.endm

.imacro	until
 .check	%N=1	;Boolean needed in UNTIL
	getstacktop
 .if %E&__repeatflag=0	;should be repeat
 .error UNTIL without REPEAT
 .else
	.eval %E&__noflags
	notbool%s %1,__r%E
	stkpop
 .if %E&__breakflag<>0	;flag set
	.eval %E&__noflags
__out%E:	;only needed if break used
 .endif
 .endif
.endm

.imacro	break
 .check	%N=0	;break does not require params
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error BREAK not inside loop structure
 .else
	.eval %E&__noflags
	got __out%E	;goto end of last loop
	.eval __stkfoundp	;set breakflag in the last loop
__stack%E:=__stack%E|__breakflag
 .endif
.endm

.imacro	nextnode
 .check	%N=2	;nextnode requires 2 params
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error NEXTNODE not inside loop structure
 .else
	.eval %E&__noflags
	succnode %1,%2,__out%E	;goto end of last loop
	.eval __stkfoundp	;set breakflag in the last loop
__stack%E:=__stack%E|__breakflag
 .endif
.endm

.imacro	lastnode
 .check	%N=2	;lastnode requires 2 params
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error LASTNODE not inside loop structure
 .else
	.eval %E&__noflags
	prednode %1,%2,__out%E	;goto end of last loop
	.eval __stkfoundp	;set breakflag in the last loop
__stack%E:=__stack%E|__breakflag
 .endif
.endm

.imacro	breakif
 .check	%N=1	;BREAKIF requires expression
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error BREAKIF not inside loop structure
 .else
	.eval %E&__noflags
	bool%s %1,__out%E	;breakif jumps out
	.eval __stkfoundp	;set breakflag in the last loop
__stack%E:=__stack%E|__breakflag
 .endif
.endm

; continue jumps to top of most recent loop structure
; note: this means that for a WHILE loop the test is re-evaluated 

.imacro	continue
 .check	%N=0	;continue does not require params
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error CONTINUE not inside loop structure
 .elseif	%E&__repeatflag
	.eval %E&__noflags
	got __r%E	;goto top of last loop
 .elseif	%E&__loopflag
	.eval %E&__noflags
	got __l%E	;goto top of last loop
 .elseif	%E&__whileflag
	.eval %E&__noflags
	got __w%E	;goto top of last loop
 .elseif	%E&(__forflag|__forspflag)
	.eval %E&__noflags
	got __f%E	;goto top of last loop
 .else
 .error CONTINUE: inside unknown loop structure
 .endif
.endm

; continue jumps to top of most recent loop structure
; note: this means that for a WHILE loop the test is re-evaluated 
.imacro	continueif
 .check	%N=1	;CONTINUEIF requires expression
	.eval __stkptr
	stksearch %E,__allloops	;most recent loop
 .if __stkfoundp=0
 .error CONTINUEIF not inside loop structure
 .elseif	%E&__repeatflag
	.eval %E&__noflags
	bool%s %1,__r%E	;goto top of last loop
 .elseif	%E&__loopflag
	.eval %E&__noflags
	bool%s %1,__l%E	;goto top of last loop
 .elseif	%E&__whileflag
	.eval %E&__noflags
	bool%s %1,__w%E	;goto top of last loop
 .elseif	%E&(__forflag|__forspflag)
	.eval %E&__noflags
	bool%s %1,__f%E	;goto top of last loop
 .else
 .error CONTINUEIF: inside unknown loop structure
 .endif
.endm

.imacro	loop
 .check	%N=0	;no args to LOOP
__scount:=__scount+1	;new structure,only ever counts up
	.eval __scount
	stkpush	%E|__loopflag	;push next label
	.eval __scount
__l%E:
.endm

.imacro	endloop
 .check	%N=0	;no args to ENDLOOP
	getstacktop
 .if %E&__loopflag=0
 .error ENDLOOP without LOOP
 .else
	.eval %E&__noflags
	got	__l%E

	stkpop
 .if %E&__breakflag<>0	;flag set
	.eval %E&__noflags
__out%E:	;only needed if break used
 .endif
 .endif
.endm

.imacro	endloopbreak
 .check	%N=0	;no args to ENDLOOPBREAK
	getstacktop
 .if %E&__loopflag=0
 .error ENDLOOP without LOOP
 .else
	stkpop
 .if %E&__breakflag<>0	;flag set
	.eval %E&__noflags
__out%E:	;only needed if break used
 .endif
 .endif
.endm

 .remacro	if
 .check	%N=1 	;Boolean required for IF
__scount:=__scount+1	;new structure,only ever counts up
	.eval __scount	;else not present
	notbool%s %1,__et%E
	stkpush	%E|__ifflag	;push next label
.endm

.imacro	elseif
 .check	%N=1 	;Boolean required for ELSEIF
__scount:=__scount+1	;new structure,only ever counts up
	.eval __stkptr
	stksearch %E,__ifflag
 .if __stkfoundp=0
 .error ELSEIF without preceeding IF/ELSEIF
 .endif
	.eval %E&__noflags
	got	__ef%E	;goto endif
	getstacktop
	.eval %E&__noflags
__et%E:
	.eval __scount
	notbool%s %1,__et%E
	.eval __scount
	stkpush	%E|__elseifflag	;push next label
.endm

 .remacro	else
 .check	%N=0 	;no params required for ELSE
__scount:=__scount+1	;new structure,only ever counts up
	.eval __stkptr
	stksearch %E,__ifflag
 .if __stkfoundp=0
 .error ELSE without preceeding IF/ELSEIF
 .endif
	.eval %E&__noflags
	got	__ef%E	;goto endif
	getstacktop
	.eval %E&__noflags
__et%E:
	.eval __scount
	stkpush	%E|__elseflag	;push next label
.endm

 .remacro	endif
 .check	%N=0 	;no params required for ENDIF
	getstacktop
	.eval %E&(__elseflag|__elseifflag|__ifflag)
 .if %E=0
 .error	ENDIF without IF/ELSEIF/ELSE
 .endif
	getstacktop
 .if (%E&(__ifflag|__elseifflag))>0
	.eval %E&__noflags
__et%E:
 .endif
	getstacktop
	.eval %E&(__elseflag|__elseifflag)	;both labels for elseif
 .if %E>0
	.eval __stkptr
	stksearch %E,__ifflag
	.eval %E&__noflags
__ef%E:
 .endif
	.eval __stkptr	;pop all items from stack until find if
	stksearch %E,__ifflag
__stkptr:=__stkfoundp-1	;replace stackpointer
.endm

.imacro	for	;count,register
 .if %N=1
 .check	?reg(%1)	;FOR requires register
 .else
 .check	%N=2	;FOR requires count,register
 .check	?reg(%2)	;FOR expects count,register
 .check	~?reg(%1)	;try FOR register
	copy	%1,%2	;save count
 .endif
__scount:=__scount+1	;new structure,only ever counts up
	.eval __scount
	stkpush	%E|__forflag	;push next label
	.eval __scount
__f%E:
.endm

.imacro	next
 .check	%N=1 			;NEXT requires register 
 .check	?REG(%1)	;NEXT requires register 
	getstacktop
 .if %E&__forflag=0	;should be for
 .error NEXT without FOR
 .else
	.eval %E&__noflags
	dec	%1
	tst	%1
	bgt	__f%E

	stkpop
 .if %E&__breakflag<>0	;flag set
	.eval %E&__noflags
__out%E:	;only needed if break used
 .endif
 .endif
.endm

.imacro	forsp	;count
 .check	%N=1 ;FORSP requires register or constant
	psh	%1	;save count on stack
__scount:=__scount+1	;new structure,only ever counts up
	.eval __scount
	stkpush	%E|__forspflag	;push next label
	.eval __scount
__f%E:
.endm

.imacro	nextsp
 .check	%N=0 ;NEXTSP uses stack top for count
	getstacktop
 .if %E&__forspflag=0	;should be for
 .error NEXTSP without FORSP
 .else
	.eval %E&__noflags
	dec	[r7]
	tst	[r7]
	bgt	__f%E

	stkpop
 .if %E&__breakflag<>0	;flag set
	.eval %E&__noflags
__out%E:	;only needed if break used
 .endif
	add	4,r7	;tidy stack
 .endif
.endm

.endif
