.if ~?def(DEF_TAO)
DEF_TAO=TRUE

*******************************************
*                                         *
*                TAO.INC                  *
*                                         *
*  Master include file for VP code tools  *
*                                         *
*******************************************

.asmcode 'VP/VP'

.include 'tao_equs'
.include 'struct00'
.include 'tao_sys'
.include 'tb_equ'
.include 'libmac'
.include 'io_equs'
.include 'dir'

*VP intructions with no opcodes

.imacro h2i
	.check %N=1
	asr 16,%1
.endm

.imacro i2h
	.check %N=1
	asl 16,%1
.endm

.imacro h2f
	.check %N=1
	i2f %1
	mul.f 1.0/65536,%1
.endm

.imacro f2h
	.check %N=1
	mul.f 65536,%1
	f2i %1
.endm

.imacro h2d
	.check %N=1
	i2d %1
	mul.d 1.0/65536,%1
.endm

.imacro d2h
	.check %N=1
	mul.d 65536,%1
	d2i %1
.endm

.imacro	clr
	.check %N=1
	cpy%s 0,%1
.endm

.imacro	abs
	.check %N=1
	tst%s %1
	bge	%Labs
	neg%s %1
%Labs:
.endm

.imacro	lsl
	.check %N=2
	asl%s %1,%2
.endm

.imacro	tst
	.check %N=1
	cmp%s 0,%1
.endm

.imacro	inc
	.check %N=1
	add%s 1,%1
.endm

.imacro	d2i
	.check %N=1
 .eval %1{2,99}+1
	d2l	%1
	zap	r%e
.endm

.imacro	i2d
	.check %N=1
	i2l	%1
	l2d	%1
.endm

.imacro	dec
	.check %N=1
	sub%s 1,%1
.endm

.imacro	not
	.check %N=1
	xor%s -1,%1
.endm

.imacro	bpl
	.check %N=1
	bge	%1
.endm

.imacro	bmi
	.check %N=1
	blt	%1
.endm

.imacro	pshall
	psh	r0
	psh	r1
	psh	r2
	psh	r3
	psh	r4
	psh	r5
	psh	r6
	psh	r8
	psh	r9
	psh	r10
	psh	r11
	psh	r12
	psh	r13
	psh	r14
	psh	r15
.endm

.imacro	popall
	pop	r15
	pop	r14
	pop	r13
	pop	r12
	pop	r11
	pop	r10
	pop	r9
	pop	r8
	pop	r6
	pop	r5
	pop	r4
	pop	r3
	pop	r2
	pop	r1
	pop	r0
.endm

.imacro	pshm
	.rept %n
		psh	%1
		mshift
	.endr
.endm

.imacro	popm
	.rept %n
		pop	%1
		mshift
	.endr
.endm

.imacro	tao	;function
	;taos OS function call
 .check	%N=1
 .if ?def(kernel_r4)
	#tao %1
 .else
 .if ?def(TAO_%1)
	qcall TAO/%1,FIXUP
 .else
	#tao %1
 .endif
 .endif
.endm

** INCLUDE ends **

.endif
