.if ~?def(DEF_TAO00VP)
DEF_TAO00VP=TRUE

***************************
** TAO_MVP.INC for VP1.5 **
***************************

;stack macros

.imacro	pshr	;source
	;push register onto stack
	psh	%1
.endm

.imacro	popr	;dest
	;pop register from stack
	pop	%1
.endm

;effective address macros

.imacro	leai	;index,source,dest
	;copy effective address register indexed to register
 .check	%N=3
	lea	[%2+(%1)],%3
.endm

.imacro	lead	;{offset},index1,index2,dest
	;copy efective address double indexed to register
 .if %N=4
	lea	[%2+%3+(%1)],%4
 .else
 .check	%N=3
	lea	[%2+%1],%3
 .endif
.endm

.imacro	leac	;label,dest
	;load effective address pc relative
 .check	%N=2
	lea	%1,%2
.endm

;copy macros

.imacro	cpycr	;const,dest
	;copy const to register
 .check	%N=2
	cpy	%1,%2
.endm

.imacro	cpyci	;const,index,dest
	;copy const to register indexed
 .check	%N=3
	cpy	%1,[%3+(%2)]
.endm

.imacro	cpyrr	;source,dest
	;copy register to register
 .check	%N=2
 .if ~(%1=%2)
	cpy	%1,%2
 .endif
.endm

.imacro	cpyir	;index,source,dest
	;copy register indexed to register
 .check	%N=3
	cpy	[%2+(%1)],%3
.endm

.imacro	cpyri	;source,index,dest
	;copy register to register indexed
 .check	%N=3
	cpy	%1,[%3+(%2)]
.endm

.imacro	cpyrd	;source,index1,index2
	;copy register to double indexed
 .check	%N=3
	cpy	%1,[%3+%2]
.endm

.imacro	cpyrdb	;src,base,reg2
 .check	%N=3
	cpy.b	%1,[%3+%2]
.endm

.imacro	cpycd	;const,index1,index2
	;copy const to double indexed
 .check	%N=3
	cpy	%1,[%3+%2]
.endm

.imacro	cpycdb	;const,index1,index2
	;copy constant to double indexed
 .check	%N=3
	cpy.b	%1,[%3+%2]
.endm

.imacro	cpydr	;index1,index2,dest
	;copy double indexed to register
 .check	%N=3
	cpy	[%1+%2],%3
.endm

.imacro	cpydrb
	cpy.b [%2+(%1)],%3
.endm

.imacro	cpyirb	;n,base,dst
	cpy.b	[%2+(%1)],%3
.endm

.imacro	cpyrib	;src,n,base
	cpy.b	%1,[%3+(%2)]
.endm

.imacro	cpycib	;src,n,base
	cpy.b	%1,[%3+(%2)]
.endm

;clear macros

.imacro	clrr	;dest
	;clear register
	cpycr	0,%1	;copy zero to register
.endm

.imacro	clri	;index,dest
	;clear register indexed
	cpyci	0,%1,%2		;copy zero to register indexed
.endm

;add macros

.imacro	addrd	;reg,index1,index2
	;add register to double
 .check	%N=3
	add	%1,[%2+%3]
.endm

.imacro	addcr	;const,dest
	;add const to register
 .check	%N=2
	add	%1,%2
.endm

.imacro	addci	;const,index,dest
	;add const to register indexed
 .check	%N=3
	add	%1,[%3+(%2)]
.endm

.imacro	addrr	;source,dest
	;add register to register
 .check	%N=2
	add	%1,%2
.endm

.imacro	addir	;index,source,dest
	;add register indexed to register
 .check	%N=3
	add	[%2+(%1)],%3
.endm

.imacro	addri	;source,index,dest
	;add register to register indexed
 .check	%N=3
	add	%1,[%3+(%2)]
.endm

.imacro	addcd	;const,index1,index2
	;add const to double
 .check	%N=3
	add	%1,[%3+%2]
.endm

.imacro	adddr	;index1,index2,reg
	;add double to reg
 .check	%N=3
	add	[%1+%2],%3
.endm

;subtract macros

.imacro	subrd	;reg,index1,index2
	;sub register from double
 .check	%N=3
	sub	%1,[%2+%3]
.endm

.imacro	subcd	;const,index1,index2
	;sub const from double
 .check	%N=3
	sub	%1,[%3+%2]
.endm

.imacro	subcr	;const,dest
	;subtract %1 from register
 .check	%N=2
	sub	%1,%2
.endm

.imacro	subci	;const,index,dest
	;subtract %1 from register indexed
 .check	%N=3
	sub	%1,[%3+(%2)]
.endm

.imacro	subrr	;source,dest
	;subtract register from register
 .check	%N=2
 .if %1=%2
	cpycr	0,%2
 .else
	sub	%1,%2
 .endif
.endm

.imacro	subir	;index,source,dest
	;subtract register indexed from register
 .check	%N=3
	sub	[%2+(%1)],%3
.endm

.imacro	subri	;source,index,dest
	;subtract register from register indexed
 .check	%N=3
	sub	%1,[%3+(%2)]
.endm

;and macros

.imacro	andrd	;reg,index1,index2
	;and register to double
 .check	%N=3
	and	%1,[%2+%3]
.endm

.imacro	andcr	;const,dest
	;and const to register
 .check	%N=2
	and	%1,%2
.endm

.imacro	andci	;const,index,dest
	;and const to register indexed
 .check	%N=3
	and	%1,[%3+(%2)]
.endm

.imacro	andrr	;source,dest
	;and register to register
 .check	%N=2
	and	%1,%2
.endm

.imacro	andir	;index,source,dest
	;and register indexed to register
 .check	%N=3
	and	[%2+(%1)],%3
.endm

.imacro	andri	;source,index,dest
	;and register to register indexed
 .check	%N=3
	and	%1,[%3+(%2)]
.endm

.imacro	andcd	;const,index1,index2
	;and const to double
 .check	%N=3
	and	%1,[%3+%2]
.endm

;or macros

.imacro	orrd	;reg,index1,index2
	;or register to double
 .check	%N=3
	or	%1,[%3+%2]
.endm

.imacro	orcr	;const,dest
	;or const to register
 .check	%N=2
	or	%1,%2
.endm

.imacro	orci	;const,index,dest
	;or const to register indexed
 .check	%N=3
	or	%1,[%3+(%2)]
.endm

.imacro	orrr	;source,dest
	;or register to register
 .check	%N=2
	or	%1,%2
.endm

.imacro	orir	;index,source,dest
	;or register indexed to register
 .check	%N=3
	or	[%2+(%1)],%3
.endm

.imacro	orri	;source,index,dest
	;or register to register indexed
 .check	%N=3
	or	%1,[%3+(%2)]
.endm

.imacro	orcd	;const,index1,index2
	;or const to double
 .check	%N=3
	or	%1,[%3+%2]
.endm

;xor macros

.imacro	xorrd	;reg,index1,index2
	;xor register to double
 .check	%N=3
	xor	%1,[%3+%2]
.endm

.imacro	xorcr	;const,dest
	;xor const to register
 .check	%N=2
	xor	%1,%2
.endm

.imacro	xorci	;const,index,dest
	;xor const to register indexed
 .check	%N=3
	xor	%1,[%3+(%2)]
.endm

.imacro	xorrr	;source,dest
	;xor register to register
 .check	%N=2
	xor	%1,%2
.endm

.imacro	xorir	;index,source,dest
	;xor register indexed to register
 .check	%N=3
	xor	[%2+(%1)],%3
.endm

.imacro	xorri	;source,index,dest
	;xor register to register indexed
 .check	%N=3
	xor	%1,[%3+(%2)]
.endm

.imacro	xorcd	;const,index1,index2
	;xor const to double
 .check	%N=3
	xor	%1,[%3+%2]
.endm

;increment macros

.imacro	incr	;source
 .check	%N=1
	;increment register
	addcr	1,%1	;add 1 to register
.endm

.imacro	inci	;index,source
	;increment register indexed
 .check	%N=2
	addci	1,%1,%2	;add 1 to register indexed
.endm

;decrement macros

.imacro	decr	;source
 .check	%N=1
	;decrement register
	subcr	1,%1	;subtract 1 from register
.endm

.imacro	deci	;index,source
	;decrement register indexed
 .check	%N=2
	subci	1,%1,%2	;subtract 1 from register indexed
.endm

;negate macros

.imacro	negr	;reg
	;negate register
 .check	%N=1
	neg	%1
.endm

.imacro	negi	;index,dest
	;negate register indexed
 .check	%N=2
	neg	[%2+(%1)]
.endm

.imacro	notr ;reg
 .check	%N=1
	xor	-1,%1
.endm

.imacro	negrl	;reg
	;neg.l macro
 .check	%N=1
	xor.l	-1,%1
.endm

;exchange macros

.imacro	exgrr	;source,dest
	;exchange register with register
 .check	%N=2
	exg	%1,%2
.endm

.imacro	exgir	;index,source,dest
	;exchange indexed with register
 .check	%N=3
	exg	[%2+(%1)],%3
.endm

;shift macros

.imacro	lsrir	;index,source,dest
	;logical shift right indexed register
 .check	%N=3
	lsr	[%2+(%1)],%3
.endm

.imacro	lsrcr	;count,dest
	;logical shift right register
 .check	%N=2
	lsr	%1,%2
.endm

.imacro	aslrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	asl	%1,%2
.endm

.imacro	aslcr	;count,dest
	;arithmetic shift left register
 .check	%N=2
	asl	%1,%2
.endm

.imacro	aslci	;count,index,reg
	;arithmetic shift left indexed
 .check	%N=3
	asl	%1,[%3+(%2)]
.endm

.imacro	asrcr	;count,dest
	;arithmetic shift right register
 .check	%N=2
	asr	%1,%2
.endm

.imacro	lsrrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	lsr	%1,%2
.endm

;divide macros

.imacro	remcr	;const,dest
	;divide register by const
 .check	%N=2
	rem	%1,%2
.endm

.imacro	divcr	;const,dest
	;divide register by const
 .check	%N=2
	div	%1,%2
.endm

.imacro	divrr	;src,dest
	;divide register by reg
 .check	%N=2
	div	%1,%2
.endm

.imacro	divir	;index,reg,dest
	;divide register by indexed
	div	[%2+(%1)],%3
.endm

;multyply macros

.imacro	mulcr	;const,dest
	;multyply dest register by const
 .check	%N=2
	mul	%1,%2
.endm

.imacro	mulrr	;source,dest
	;multyply dest register by source
 .check	%N=2
	mul	%1,%2
.endm

.imacro	mulir	;index,source,dest
	;multyply dest register by indexed
 .check	%N=3
	mul	[%2+(%1)],%3
.endm

;compare macros

.imacro	cmpcr	;const,dest
	;compare const with register
 .check	%N=2
	cmp	%1,%2
.endm

.imacro	cmpci	;const,index,dest
	;compare const with register indexed
 .check	%N=3
	cmp	%1,[%3+(%2)]
.endm

.imacro	cmprr	;source,dest
	;compare register with register
 .check	%N=2
	cmp	%1,%2
.endm

.imacro	cmpir	;index,source,dest
	;compare register indexed with register
 .check	%N=3
	cmp	[%2+(%1)],%3
.endm

.imacro	cmpri	;source,index,dest
	;compare register with register indexed
 .check	%N=3
	cmp	%1,[%3+(%2)]
.endm

.imacro	cmpcd
	cmp %1,[%3+(%2)]
.endm

;test macros

.imacro	tstd	;index1,index2
	;compare double indexed with 0
	cmpcd	0,%1,%2
.endm

.imacro	tstr	;dest
	;compare register with 0
 .check	%N=1
	cmpcr	0,%1	;compare with zero
.endm

.imacro	tsti	;index,dest
	;compare register indexed with 0
 .check	%N=2
	cmpci	0,%1,%2	;compare with zero
.endm

;bit set macros

.imacro	bstci	;constant,index,register
	;set bit 0-31 in indexed
	bst	%1,[%3+(%2)]
.endm

;bit macros

.imacro	bitcr	;const,register
	;test bit 0-31 in register
 .check	%N=2
	bit	%1,%2
.endm

.imacro	bitci	;const,index,register
	;test bit 0-31 in indexed
 .check	%N=3
	bit	%1,[%3+(%2)]
.endm

.imacro	bitrr	;source,dest
	;test bit register in register
 .check	%N=2
	bit	%1,%2
.endm

.imacro	bitrd	;register,idx1,idx2
	;test bit register in double indexed
 .check	%N=3
	bit	%1,[%3+%2]
.endm

;bit clear macros

.imacro	bclci	;constant,index,register
	;clear bit 0-31 in indexed
 .check	%N=3
	bcr	%1,[%3+(%2)]
.endm

.imacro	gotc	;%1
	;branch direct
 .check	%N=1
	got	%1
.endm

.imacro	gotr	;reg
	;branch indirect
 .check	%N=1
	got	%1
.endm

.imacro	goti	;index,reg
	;branch indirect indexed
 .check	%N=2
	got	[%2+(%1)]
.endm

.imacro	gosc	;address
	;call direct
 .check	%N=1
	gos	%1
.endm

.imacro	gosi	;index,source
	;call indexed
 .check	%N=2
	gos	[%2+(%1)]
.endm

.imacro	gosr	;dest
	;call indirect
 .check	%N=1
	gos	%1
.endm

.imacro	return
	;return from subroutine
 .check	%N=0
	ret
.endm

.endif
