.if ~?def(DEF_TAO01SYS)
DEF_TAO01SYS=TRUE

;debug macros

.imacro	TRACEF		;fmt,arg1 ... argn
	pshm	r0,r3,r15
__bytes_pushed:=0
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	leac	__string_%e,r0
	cpyrr	r7,r3
	vcall	LIB/TRACEF,VIRTUAL+FIXUP
	.if __bytes_pushed<>0
		addcr __bytes_pushed,r7    	;remove params from stack
	.endif
	popm	r15,r3,r0
.endm

.imacro	PRINTF		;fmt,arg1 ... argn
__bytes_pushed:=0
	pshr	r3
	psh_param	(%N)-1,%2,%3,%4,%5,%6,%7,%8,%9
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	leac	__string_%e,r0
	cpyrr	r7,r3
	vcall	LIB/PRINTF
	.if __bytes_pushed<>0
		addcr __bytes_pushed,r7    	;remove params from stack
	.endif
	popr	r3
.endm

.imacro	psh_param ;N,...	; push on backwards
 .if (%1) > 1
	psh_param	(%1)-1,%3,%4,%5,%6,%7,%8,%9
 .endif
 .if (%1) > 0
	pshr	%2		;push it integer
__bytes_pushed:=__bytes_pushed+4
 .endif
.endm

;priority macros

.imacro	runhi	;execute folowing code in HI (until return)
	ldpri	;get priority
	cj	%L1	;was already in hi priority
	ldc	%L2-%L3
	ldpi
%L3:	ldl	r7
	adc	-4
	dup
	stl	r7
	stnl	0	;push stopp address onto stack
	ldc	%L1-%L4
	ldpi
%L4:	stl	-1	;pc for hi thread
	ldlp	r0	;wdesc for hi
	runp		;execute in hi priority
	return
%L2:	stopp		;stop hi priority process
%L1:
.endm

.imacro	switchhi	;switch to hi if not in hi
	ldpri	;get priority
	cj	%L1	;was already in hi priority
	ldc	0
	stl	-1	;clear low pc space
	ldlp	r0
	ldl	r7
	stnl	-1	;save low wdec
	ldc	%L2-%L3
	ldpi
%L3:	ldl	r7
	stnl	-3
	ldl	r7
	ldnlp	-2
	runp		;execute in hi priority
	stopp		;stop low priority process
%L2:	ldtimer
	ldc	10
	sum
	tin		;deshedule hi priority
	ldl	1
	ldnl	-1
	cj	%L2	;wait till low has stoped
	ldl	1
	gajw
%L1:
.endm

.imacro	switchlo	;switch to low if not in low
	ldpri	;get priority
	eqc	0
	cj	%L1	;was already in low priority
	ldlp	r0
	ldl	r7
	stnl	-1	;save high wdec
	ldc	%L2-%L3
	ldpi
%L3:	ldl	r7
	stnl	-2
	ldl	r7
	ldnlp	-1
	adc	1	;wdesc for low
	runp		;execute in low priority
	stopp		;stop high priority process
%L2:	ldl	0
	gajw
%L1:
.endm

;list macros

.imacro	initlist	;header
	;list header initialisation
	;inputs
	;header
 .check	%N=1
	cpyri	%1,0,%1		;list head points to list head
	cpyri	%1,LH_TAILPRED,%1	;list tailpred points to list head
	addci	LH_TAIL,0,%1		;list head points to list tail
	clri	LH_TAIL,%1		;clear list header tail
.endm

.imacro	succ	;node,next
	;get succesor
 .check	%N=2
	cpyir	LN_SUCC,%1,%2	;points to next node
.endm

.imacro	pred	;node,last
	;get predesesor
 .check	%N=2
	cpyir	LN_PRED,%1,%2	;points to last node
.endm

.imacro	succnode	;lookahead,node,label
	;succnode
 .check	%N=3
	ldl	%1
	stl	%2	;get lookahead pointer
	ldl	%1
	ldnl	LN_SUCC/4	;points to next node
	dup
	stl	%1
	cj	%3	;branch if on tail
.endm

.imacro	prednode	;lookahead,node,label
	;prednode
 .check	%N=3
	ldl	%1
	stl	%2	;get lookahead pointer
	ldl	%1
	ldnl	LN_PRED/4	;points to last node
	dup
	stl	%1
	cj	%3	;branch if on head
.endm

.imacro	addnode	;node,nnode,temp
	;add new node at node
 .check	%N=3
	cpyir	LN_SUCC,%1,%3	;save pointer to next node
	cpyri	%3,LN_SUCC,%2	;new node points forward to next
	cpyri	%2,LN_SUCC,%1	;node points forward to new node
	cpyri	%1,LN_PRED,%2	;new node points back to node
	cpyri	%2,LN_PRED,%3	;next node points to new node
.endm

.imacro	addhead	;head,node,temp
	;add node to head
 .check	%N=3
	cpyir	LH_HEAD,%1,%3	;save pointer to old first node
	cpyri	%2,LH_HEAD,%1	;list head points forward to new first node
	cpyri	%3,LN_SUCC,%2	;new first node points forward to old first node
	cpyri	%1,LN_PRED,%2	;new first node points back to list head
	cpyri	%2,LN_PRED,%3	;old first node points back to new first node
.endm

.imacro	addtail	;head,node,temp
	;add node to tail
 .check	%N=3
	cpyir	LH_TAILPRED,%1,%3	;save pointer to old last node
	cpyri	%2,LH_TAILPRED,%1	;list header points back to new last node
	cpyri	%1,LN_SUCC,%2
	addci	LH_TAIL,LN_SUCC,%2	;new last node points forward to list tail
	cpyri	%3,LN_PRED,%2	;new last node points back to old last node
	cpyri	%2,LN_SUCC,%3	;old last node points forward to new last node
.endm

.imacro	remhead	;head,temp1,temp2,label
	;remove head node
 .check	%N=4
	cpyir	LH_HEAD,%1,%2	;get pointer to first node
	tsti	LN_SUCC,%2
	beq	%4	;branch if empty
	succ	%2,%3	;get forward pointer to next node
	cpyri	%3,LH_HEAD,%1	;set head to point to new first node
	cpyri	%1,LN_PRED,%3	;set new first node to point to head
.endm

.imacro	remove	;node
	;remove node
 .check	%N=1
	ldl	%1
	ldnl	LN_SUCC/4	;get forward pointer to next node
	pred	%1,%1	;get back pointer to last node
	dup
	ldl	%1
	stnl	LN_SUCC/4	;set last node to point forward to next node
	ldl	%1
	rev
	stnl	LN_PRED/4	;set next node to point back to last node
.endm

;language macros

.imacro	killobject	;object
	;kill object pointed to
	;inputs
	;object pointer
 .check	%N=1
	cpyci	-1,ND_NUMBER,%1
.endm

.imacro	allocstruct	;size,reg
	;allocate structure on stack
	;inputs
	;size (in bytes)
	;register
	;outputs
	;register=structure pointer
 .check	%N=2
 .if ?reg	(%1)
	subrr	%1,r7
 .else
	ldl	r7
	ldnlp	-(%1)/4
	stl	r7
 .endif
	cpyrr	r7,%2
.endm

.imacro	freestruct	;size
	;free struct on stack
	;inputs
	;size (in bytes)
	;outputs
	;r7=r7 before allocstruct
 .check	%N=1
 .if ?reg	(%1)
	addrr	%1,r7
 .else
	ldl	r7
	ldnlp	(%1)/4
	stl	r7
 .endif
.endm

.imacro	allocmbox	;register,filter
	;allocate temp mailbox structure on stack
	;inputs
	;structure register
	;filter word
 .check	%N=2
	allocstruct	MB_SIZE,r7	;temporary mailbox
	initlist	r7		;initilize maillist
	clri	MB_STATE,r7		;clear state
 .if ?reg	(%2)
	cpyri	%2,MB_FILTER,r7	;set filter
 .else
	cpyci	%2,MB_FILTER,r7	;set filter
 .endif
	cpyci	12345678,MB_MAGIC,r7	;validate it
	cpyrr	r7,%1
.endm

.imacro	freembox
	;free temp mailbox on stack
	;inputs
	;r7=r7 before allocmbox
	clri	MB_MAGIC,r7	;clear magic
	leai	MB_SIZE,r7,r7
.endm

;Tao call Macros

.imacro	vaddr	;object,item
	;inputs
	;containing object
	;embeded object number
	;outputs
	;r0=NULL if error
	;r0=pointer to embeded object
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r15
 .else
	cpycr	%2,r15
 .endif
	tao	VADDR
.endm

.imacro	freemem	;start,size
	;free memory block
	;inputs
	;start of block (word aligned)
	;size of block (in bytes,word aligned)
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	FREEMEM
.endm

.imacro	freenode	;start
	;free node
	;inputs
	;start of node (word aligned)
 .check	%N=1
	cpyrr	%1,r0
	cpyir	MN_BYTES,r0,r8
	tao	FREEMEM
.endm

.imacro	allocmem	;size
	;allocate memory block
	;inputs
	;size of block (in bytes,word aligned)
	;outputs
	;r8=0 if error
	;r0=start of block
	;r8=size of block given (in bytes)
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r8
 .else
	cpycr	%1,r8
 .endif
	tao	ALLOCMEM
.endm

.imacro	copynode	;node
	;copy node
	;inputs
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	COPYNODE
.endm

.imacro	copyhead	;list,node
	;copy node onto head of list
	;inputs
	;list pointer
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r1
 .else
	cpycr	%2,r1
 .endif
	tao	COPYHEAD
.endm

.imacro	copytail	;list,node
	;copy node onto tail of list
	;inputs
	;list pointer
	;node pointer
	;outputs
	;r8=0 if error
	;r0=new node pointer
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r1
 .else
	cpycr	%2,r1
 .endif
	tao	COPYTAIL
.endm

.imacro	removenode	;node
	;copy node
	;inputs
	;node pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	REMOVENODE
.endm

.imacro	objproc	;object
	;process an object
	;inputs
	;object pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	OBJPROC
.endm

.imacro	listproc	;list
	;process an object list
	;inputs
	;list pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	LISTPROC
.endm

.imacro	dumplist	;list
	;free a node list
	;inputs
	;list pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	DUMPLIST
.endm

.imacro	striplist	;list,type/s
	;strip a node list
	;inputs
	;list pointer
	;type mask
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	STRIPLIST
.endm

.imacro	freelist	;list
	;free an object list
	;inputs
	;list pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	FREELIST
.endm

.imacro	prunelist	;list,type/s
	;prune a object list
	;inputs
	;list pointer
	;type mask
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	PRUNELIST
.endm

.imacro	listtest	;list,types
	;test list
	;inputs
	;list pointer
	;type/s mask
	;outputs
	;r8=0 if no messages of your type
	;r8=message type
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	LISTTEST
.endm

.imacro	sendmail	;message
	;send message
	;inputs
	;message pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	SENDMAIL
.endm

.imacro	sendhead	;message
	;send message header
	;inputs
	;message pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	cpyir	MG_OFFSET,r0,r8
	tao	SENDPART
.endm

.imacro	sendpart	;message
	;send front part of a message
	;inputs
	;message pointer
	;message section size
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	SENDPART
.endm

.imacro	copymail	;message
	;copy message and send
	;inputs
	;message pointer
	;outputs
	;r8=0 if error
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	COPYMAIL
.endm

.imacro	readmail	;mailbox,types
	;readmail from mailbox
	;inputs
	;mailbox pointer
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	READMAIL
.endm

.imacro	readmymail	;types
	;readmail from my mailbox
	;inputs
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
	.check %N=1
	leai	CT_MAILBOX,r6,r0
 .if ?reg	(%1)
	cpyrr	%1,r8
 .else
	cpycr	%1,r8
 .endif
	tao	READMAIL
.endm

.imacro	readtype	;mailbox,types
	;readtype from mailbox
	;inputs
	;mailbox pointer
	;type/s mask
	;outputs
	;r8=0 if messages but not yours
	;r8=message type
	;r0=message pointer
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	READTYPE
.endm

.imacro	declare	;name,mailidl,mailidh
	;declare a 64 bit variable
	;inputs
	;r6=control object pointer
	;name string
	;mailbox id low
	;mailbox id high
	;outputs
	;r8=0 if error
 .check	%N=3
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
 .if ?reg	(%3)
	cpyrr	%3,r9
 .else
	cpycr	%3,r9
 .endif
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	leac	__string_%e,r1
	cpycr	DINT64,r10
	tao	DECLARE
.endm

.imacro	undeclare	;name
	;undeclare a 64 bit variable
	;inputs
	;r6=control object pointer
	;name string
	;outputs
	;r8=0 if error
 .check	%N=1
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	leac	__string_%e,r1
	tao	UNDECLARE
.endm

.imacro	enquire	;name,level
	;find a 64 bit variable value
	;inputs
	;r6=control object pointer
	;name string
	;enquire level
	;outputs
	;r8=0 if error
	;r9+r10+r11=96 bit value
 .check	%N=2
	.eval __tool_num+SAVETEXTQ __string_q,0,{%1}
	leac	__string_%e,r1
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
	tao	ENQUIRE
.endm

.imacro	GETSERVER	;parent,filename
	;split an access route
	;inputs
	;parent object pointer
	;filename pointer
	;outputs
	;server ID low
	;server ID high
	;filename pointer
 .check	%N=2
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r1
 .else
	cpycr	%2,r1
 .endif
	tao	GETSERVER
.endm

.imacro	opentool	;filename,idlow,idhigh
	;open a tool
	;inputs
	;filename pointer
	;server ID low
	;server ID high
	;outputs
	;r8=0 if error
	;r0=installed tool pointer
	;r1=tool code pointer
 .check	%N=3
 .if ?reg	(%1)
	cpyrr	%1,r1
 .else
	cpycr	%1,r1
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r9
 .else
	cpycr	%2,r9
 .endif
 .if ?reg	(%3)
	cpyrr	%3,r10
 .else
	cpycr	%3,r10
 .endif
	tao	OPENTOOL
.endm

.imacro	closetool	;tool
	;close a tool
	;inputs
	;tool object pointer
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	tao	CLOSETOOL
.endm

.imacro	flushtools
	;flush tools on tools list
	tao	FLUSHTOOLS
.endm

.imacro	gettime
	;get local time (in 64 us units)
	;outputs
	;r8=time
	tao	GETTIME
.endm

.imacro	delay	;time
	;deshedule process for time (in 64 uS units)
 .check	%N=1
 .if ?reg	(%1)
	cpyrr	%1,r8
 .else
	cpycr	%1,r8
 .endif
	tao	DELAY
.endm

.imacro	deschedule
	;deshedule process for one control cycle
	tao	DESCHEDULE
.endm

.imacro	startcontrol	;control,mailidl,mailidh
	;start a control object
	;inputs
	;control object pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r0=control object pointer
 .check	%N=3
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
 .if ?reg	(%2)
	cpyrr	%2,r8
 .else
	cpycr	%2,r8
 .endif
 .if ?reg	(%3)
	cpyrr	%3,r9
 .else
	cpycr	%3,r9
 .endif
	tao	STARTCONTROL
.endm

.imacro	opencontrol	;control,mailidl,mailidh
	;create a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r0=new control object pointer
 .check	%N=3
 .if ?reg	(%1)
	cpyrr	%1,r0
 .else
	cpycr	%1,r0
 .endif
	cpyrr	%2,r8
	cpyrr	%3,r9
	tao	OPENCONTROL
.endm

.imacro	openchild	;control,mailidl,mailidh
	;distribute and open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=3
	cpyrr	%1,r0
	cpyrr	%2,r8
	cpyrr	%3,r9
	tao	OPENCHILD
.endm

.imacro	openremote	;control,mailidl,mailidh,procnum
	;remote open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;target proc number
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=4
	cpyrr	%1,r0
	cpyrr	%2,r8
	cpyrr	%3,r9
	cpyrr	%4,r10
	tao	OPENREMOTE
.endm

.imacro	opendevice	;control,mailidl,mailidh,procnum
	;target and open a control object
	;inputs
	;control template pointer
	;parent mailbox id low int32
	;parent mailbox id high int32
	;target proc number
	;outputs
	;r8=0 if error
	;r8,r9=64 bit mailbox ID of child
 .check	%N=4
	cpyrr	%1,r0
	cpyrr	%2,r8
	cpyrr	%3,r9
	cpyrr	%4,r10
	tao	OPENDEVICE
.endm

.imacro	openarray	;array1,array2,mailidl,mailidh,entries
	;open an array of child control objects
	;inputs
	;offset array pointer (32 bit)
	;target array pointer (64 bit)
	;parent mailbox id low int32
	;parent mailbox id high int32
	;entries
	;outputs
	;r8=0 if any child failed (0 in target array)
 .check	%N=5
	cpyrr	%1,r0
	cpyrr	%2,r1
	cpyrr	%3,r8
	cpyrr	%4,r9
	cpyrr	%5,r10
	tao	OPENARRAY
.endm

.imacro	openfarm	;temp,array2,mailidl,mailidh,entries
	;open a farm of child control objects
	;inputs
	;child control object pointer
	;target array pointer (64 bit)
	;parent mailbox id low int32
	;parent mailbox id high int32
	;entries
	;outputs
	;r8=0 if any child failed (0 in target array)
 .check	%N=5
	cpyrr	%1,r0
	cpyrr	%2,r1
	cpyrr	%3,r8
	cpyrr	%4,r9
	cpyrr	%5,r10
	tao	OPENFARM
.endm

.imacro	findtype	;memory,startnum,type
	;find a target chip number
	;inputs
	;memory required (in bytes)
	;start proc number
	;type (0=VP)
	;outputs
	;r8=0 if error
	;r8=memory present
	;r9=proc number
	;r10=type found
 .check	%N=3
	cpyrr	%1,r8
	cpyrr	%2,r9
	cpyrr	%3,r10
	tao	FINDTYPE
.endm

.imacro	getmyid	;control
	;get a 64 bit mailbox ID
	;inputs
	;control object pointer
	;outputs
	;r8+r9=64 bit value
 .check	%N=1
 .if %1=r6
	tao	GETMYID
 .else
	pshr	r6
	cpyrr	%1,r6
	tao	GETMYID
	popr	r6
 .endif
.endm

.imacro	getparent	;control
	;get a 64 bit mailbox ID
	;inputs
	;control object pointer
	;outputs
	;r8+r9=64 bit value of parent
 .check	%N=1
	cpyir	CT_PARENT,%1,r8
	cpyir	CT_PARENT+4,%1,r9
.endm

;vcall macros

.imacro	vcall	;unquoted-string or handle [,flags]
	.if %N=1
	__tmp:=SAVETEXTQ __qcall_q,0,%1{1,99U}
	.else
 .check	%N=2	;vcall: 1 or 2 parameters req'd
	__tmp:=SAVETEXTQ __qcall_q,(%2)&3,%1{1,99U}
	.endif
	cpycr	__tmp,r15
	tao	VCALL
.endm

.endif
