.if ~?def(DEF_TAO04VP)
DEF_TAO04VP=TRUE

**************************
** TAO_MVP.INC for I386 **
**************************

;arh 8oct94 : fixed GOSR/GOSI to use CALLI (not CALL which doesn't work)

	structure
	struct	VP_LINK,MN_SIZE	; must be MN_SIZE so we can free it!!
	int32	VP_PRI
	int32	VP_TIME
	int32	VP_PC

	int32	VP_R0
	int32	VP_R1
	int32	VP_R2
	int32	VP_R3
	int32	VP_R4
	int32	VP_R5
	int32	VP_R6
	int32	VP_R7
	int32	VP_R8
	int32	VP_R9
	int32	VP_R10
	int32	VP_R11
	int32	VP_R12
	int32	VP_R13
	int32	VP_R14
	int32	VP_R15

	int32	VP__tmp1
	int32	VP__tmp2
	int32	VP__tmp3
	int32	VP__tmp4
	int32	VP_TAO
	size	VP_SIZE

r0=0*4
r1=1*4
r2=2*4
r3=3*4
r4=4*4
r5=5*4
r6=6*4
r7=7*4
r8=8*4
r9=9*4
r10=10*4
r11=11*4
r12=12*4
r13=13*4
r14=14*4
r15=15*4

*stack macros

.imacro	pshr	;source
	;push register onto stack
	push	[ebp+%1]
.endm

.imacro	popr	;dest
	;pop register from stack
	pop	[ebp+%1]
.endm

.imacro	pshm
	recursav	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
.endm

.imacro	recursav
 .ifnb	%1
	pshr	%1
	recursav	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	popm
	recursld	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
.endm

.imacro	recursld
 .ifnb	%1
	popr	%1
	recursld	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	pshall
	pshm	r0,r1,r2,r3,r4,r5,r6,r8,r9,r10,r11,r12,r13,r14,r15
.endm

.imacro	popall
	popm	r15,r14,r13,r12,r11,r10,r9,r8,r6,r5,r4,r3,r2,r1,r0
.endm

;effective address macros

.imacro	leai	;index,source,dest
	;copy effective address register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,%1
	mov	[ebp+%3],eax
.endm

.imacro	lead	;index1,index2,dest
	;copy efective address double indexed to register
 .check	%N=3
	mov	eax,[ebp+%1]
	add	eax,[ebp+%2]
	mov	[ebp+%3],eax
.endm

.imacro	leac	;label,dest
	;load effective address pc relative
 .check	%N=2
	call	%L1
%L1:	pop	eax
	add	eax,%1-%L1
	mov	[ebp+%2],eax
.endm

;copy macros

.imacro	cpycr	;const,dest
	;copy const to register
 .check	%N=2
	mov	[ebp+%2],%1
.endm

.imacro	cpyci	;const,index,dest
	;copy const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	mov	[eax+%2],%1
.endm

.imacro	cpyrr	;source,dest
	;copy register to register
 .check	%N=2
 .if ~(%1=%2)
	mov	eax,[ebp+%1]
	mov	[ebp+%2],eax
 .endif
.endm

.imacro	cpyrm	;source,dest
	;copy register to memory
 .check	%N=2
	mov	eax,[ebp+%1]
	mov	%2,eax
.endm

.imacro	cpymr	;source,dest
	;copy memory to register
 .check	%N=2
	mov	eax,%1
	mov	[ebp+%2],eax
.endm

.imacro	cpymi	;address,index,dest
	;copy memory to indexed
 .check	%N=3
	mov	eax,%1
	mov	ebx,[ebp+%3]
	mov	[ebx+%2],eax
.endm

.imacro	cpycm	;const,dest
	;copy const to memory
 .check	%N=2
	mov	%2,%1
.endm

.imacro	cpyir	;index,source,dest
	;copy register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[eax+%1]
	mov	[ebp+%3],ebx
.endm

.imacro	cpyri	;source,index,dest
	;copy register to register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	mov	[ebx+%2],eax
.endm

.imacro	cpyrd	;source,index1,index2
	;copy register to double indexed
 .check	%N=3
	mov	ecx,[ebp+%1]
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	mov	[eax+ebx],ecx
.endm

.imacro	cpyrdb	;src,base,reg2
 .check	%N=3
	mov.b	al,[ebp+%1]
	mov	ebx,[ebp+%2]
	mov	ecx,[ebp+%3]
	mov.b	[ebx+ecx],al
.endm

.imacro	cpycd	;const,index1,index2
	;copy const to double indexed
 .check	%N=3
	mov	ebx,[ebp+%2]
	add	ebx,[ebp+%3]
	mov	[ebx],%1
.endm

.imacro	cpycdb	;const,index1,index2
	;copy constant to double indexed
 .check	%N=3
	mov	ebx,[ebp+%2]
	add	ebx,[ebp+%3]
	mov.b	[ebx],%1
.endm

.imacro	cpydr	;index1,index2,dest
	;copy double indexed to register
 .check	%N=3
	mov	ebx,[ebp+%1]
	add	ebx,[ebp+%2]
	mov	eax,[ebx]
	mov	[ebp+%3],eax
.endm

.imacro	cpyirb	;n,base,dst
	mov	eax,[ebp+%2]
	movzx	eax,[eax+%1]
	mov	[ebp+%3],eax
.endm

.imacro	cpyrib	;src,n,base
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	mov.b	[ebx+%2],al
.endm

.imacro	cpycib	;src,n,base
	mov	eax,[ebp+%3]
	mov.b	[eax+%2],%1
.endm

.imacro	cpyblk	;source,dest,length
	;copy a block of memory
	;inputs
	;source address
	;destination address
	;length of block (in bytes)
 .check	%N=3
	mov	esi,[ebp+%1]
	mov	edi,[ebp+%2]
	mov	ecx,[ebp+%3]
	rep movs.b
.endm

.imacro	cpystr	;src,dst
	;src and dst point to nul after using.
	mov	esi,[ebp+%1]
	mov	edi,[ebp+%2]
%La:
	lods.b
	stos.b
	or.b	al,al
	jnz	%La

	mov	[ebp+%1],esi
	mov	[ebp+%2],edi
.endm

;clear macros

.imacro	clrr	;dest
	;clear register
	cpycr	0,%1	;copy zero to register
.endm

.imacro	clri	;index,dest
	;clear register indexed
	cpyci	0,%1,%2		;copy zero to register indexed
.endm

.imacro	clrm	;address
	;clear memory
	cpycm	0,%1
.endm

;add macros

.imacro	addrd	;reg,index1,index2
	;add register to double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ebx,[ebp+%1]
	add	[eax],ebx
.endm

.imacro	addrm	;source,dest
	;add from register to memory
 .check	%N=2
	mov	eax,[ebp+%1]
	add	%2,eax
.endm

.imacro	addcm	;const,dest
	;add const to memory
 .check	%N=2
	add	%2,%1
.endm

.imacro	addmr	;source,dest
	;add from memory to register
 .check	%N=2
	mov	eax,%1
	add	[ebp+%2],eax
.endm

.imacro	addcr	;const,dest
	;add const to register
 .check	%N=2
	add	[ebp+%2],%1
.endm

.imacro	addci	;const,index,dest
	;add const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	add	[eax+%2],%1
.endm

.imacro	addrr	;source,dest
	;add register to register
 .check	%N=2
	mov	eax,[ebp+%1]
	add	[ebp+%2],eax
.endm

.imacro	addir	;index,source,dest
	;add register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	add	[ebp+%3],eax
.endm

.imacro	addri	;source,index,dest
	;add register to register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	add	[ebx+%2],eax
.endm

.imacro	addcd	;const,index1,index2
	;add const to double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	add	[eax+ebx],%1
.endm

.imacro	adddr	;index1,index2,reg
	;add double to reg
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%2]
	mov	eax,[eax+ebx]
	add	[ebp+%3],eax
.endm

;subtract macros

.imacro	subrd	;reg,index1,index2
	;sub register from double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ebx,[ebp+%1]
	sub	[eax],ebx
.endm

.imacro	subrm	;source,dest
	;sub register from memory
 .check	%N=2
	mov	eax,[ebp+%1]
	sub	%2,eax
.endm

.imacro	subcm	;const,dest
	;sub const from memory
 .check	%N=2
	sub	%2,%1
.endm

.imacro	submr	;source,dest
	;sub memory from register
 .check	%N=2
	mov	eax,%1
	sub	[ebp+%2],eax
.endm

.imacro	subcr	;const,dest
	;sub const from register
 .check	%N=2
	sub	[ebp+%2],%1
.endm

.imacro	subci	;const,index,dest
	;sub const from register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	sub	[eax+%2],%1
.endm

.imacro	subrr	;source,dest
	;sub register from register
 .check	%N=2
	mov	eax,[ebp+%1]
	sub	[ebp+%2],eax
.endm

.imacro	subir	;index,source,dest
	;sub register indexed from register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	sub	[ebp+%3],eax
.endm

.imacro	subri	;source,index,dest
	;sub register from register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	sub	[ebx+%2],eax
.endm

.imacro	subcd	;const,index1,index2
	;sub const from double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	sub	[eax+ebx],%1
.endm

.imacro	subdr	;index1,index2,reg
	;sub double from reg
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%2]
	mov	eax,[eax+ebx]
	sub	[ebp+%3],eax
.endm

;and macros

.imacro	andrd	;reg,index1,index2
	;and register to double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ebx,[ebp+%1]
	and	[eax],ebx
.endm

.imacro	andcr	;const,dest
	;and const to register
 .check	%N=2
	and	[ebp+%2],%1
.endm

.imacro	andci	;const,index,dest
	;and const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	and	[eax+%2],%1
.endm

.imacro	andrr	;source,dest
	;and register to register
 .check	%N=2
	mov	eax,[ebp+%1]
	and	[ebp+%2],eax
.endm

.imacro	andir	;index,source,dest
	;and register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	and	[ebp+%3],eax
.endm

.imacro	andri	;source,index,dest
	;and register to register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	and	[ebx+%2],eax
.endm

.imacro	andcd	;const,index1,index2
	;and const to double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	and	[eax+ebx],%1
.endm

;or macros

.imacro	orrd	;reg,index1,index2
	;or register to double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ebx,[ebp+%1]
	or	[eax],ebx
.endm

.imacro	orcr	;const,dest
	;or const to register
 .check	%N=2
	or	[ebp+%2],%1
.endm

.imacro	orci	;const,index,dest
	;or const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	or	[eax+%2],%1
.endm

.imacro	orrr	;source,dest
	;or register to register
 .check	%N=2
	mov	eax,[ebp+%1]
	or	[ebp+%2],eax
.endm

.imacro	orir	;index,source,dest
	;or register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	or	[ebp+%3],eax
.endm

.imacro	orri	;source,index,dest
	;or register to register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	or	[ebx+%2],eax
.endm

.imacro	orcd	;const,index1,index2
	;or const to double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	or	[eax+ebx],%1
.endm

;xor macros

.imacro	xorrd	;reg,index1,index2
	;xor register to double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ebx,[ebp+%1]
	xor	[eax],ebx
.endm

.imacro	xorcr	;const,dest
	;xor const to register
 .check	%N=2
	xor	[ebp+%2],%1
.endm

.imacro	xorci	;const,index,dest
	;xor const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	xor	[eax+%2],%1
.endm

.imacro	xorrr	;source,dest
	;xor register to register
 .check	%N=2
	mov	eax,[ebp+%1]
	xor	[ebp+%2],eax
.endm

.imacro	xorir	;index,source,dest
	;xor register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	xor	[ebp+%3],eax
.endm

.imacro	xorri	;source,index,dest
	;xor register to register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	xor	[ebx+%2],eax
.endm

.imacro	xorcd	;const,index1,index2
	;xor const to double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	xor	[eax+ebx],%1
.endm

;increment macros

.imacro	incr	;source
 .check	%N=1
	;increment register
	addcr	1,%1	;add 1 to register
.endm

.imacro	inci	;index,source
	;increment register indexed
 .check	%N=2
	addci	1,%1,%2	;add 1 to register indexed
.endm

.imacro	incm	;address
	;increment memory
 .check	%N=1
	addcm	1,%1
.endm

;decrement macros

.imacro	decr	;source
 .check	%N=1
	;decrement register
	subcr	1,%1	;subtract 1 from register
.endm

.imacro	deci	;index,source
	;decrement register indexed
 .check	%N=2
	subci	1,%1,%2	;subtract 1 from register indexed
.endm

.imacro	decm	;address
	;decrement memory
 .check	%N=1
	subcm	1,%1
.endm

;negate macros

.imacro	negr	;reg
	;negate register
 .check	%N=1
	neg	[ebp+%1]
.endm

.imacro	negi	;index,dest
	;negate register indexed
 .check	%N=2
	mov	eax,[ebp+%2]
	neg	[eax+%1]
.endm

.imacro	notr ;reg
 .check	%N=1
	not	[ebp+%1]
.endm

.imacro	negrl	;reg
	;neg.l macro
 .check	%N=1
	not	[ebp+%1]
	not	[ebp+(%1+4)]
	add	[ebp+%1],1
	adc	[ebp+(%1+4)],0
.endm

;exchange macros

.imacro	exgrr	;source,dest
	;exchange register with register
 .check	%N=2
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%2]
	mov	[ebp+%1],ebx
	mov	[ebp+%2],eax
.endm

.imacro	exgrm	;source,dest
	;exchange register with memory
 .check	%N=2
	mov	eax,[ebp+%1]
	mov	ebx,%2
	mov	[ebp+%1],ebx
	mov	%2,eax
.endm

.imacro	exgir	;index,source,dest
	;exchange indexed with register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	xchg	ebx,[eax+%1]
	mov	[ebp+%3],ebx
.endm

;shift macros

.imacro	lsrrd	;reg,index1,index2
	;lsr register to double
 .check	%N=3
	mov	eax,[ebp+%2]
	add	eax,[ebp+%3]
	mov	ecx,[ebp+%1]
	shr	[eax],cl
.endm

.imacro	lsrcr	;const,dest
	;lsr const to register
 .check	%N=2
	shr	[ebp+%2],%1
.endm

.imacro	lsrci	;const,index,dest
	;lsr const to register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	shr	[eax+%2],%1
.endm

.imacro	lsrrr	;source,dest
	;lsr register to register
 .check	%N=2
	mov	ecx,[ebp+%1]
	shr	[ebp+%2],cl
.endm

.imacro	lsrir	;index,source,dest
	;lsr register indexed to register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	shr	[ebp+%3],eax
.endm

.imacro	lsrri	;source,index,dest
	;lsr register to register indexed
 .check	%N=3
	mov	ecx,[ebp+%1]
	mov	ebx,[ebp+%3]
	shr	[ebx+%2],cl
.endm

.imacro	lsrcd	;const,index1,index2
	;lsr const to double
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	shr	[eax+ebx],%1
.endm

.imacro	aslrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	mov	ecx,[ebp+%1]
	shl	[ebp+%2],cl
.endm

.imacro	aslcr	;count,dest
	;arithmetic shift left register
 .check	%N=2
	shl	[ebp+%2],%1
.endm

.imacro	aslci	;count,index,reg
	;arithmetic shift left indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	shl	[eax+%2],%1
.endm

.imacro	asrcr	;count,dest
	;arithmetic shift right register
 .check	%N=2
	sar	[ebp+%2],%1
.endm

;divide macros

.imacro	b2i	;reg
	movsx	eax,[ebp+%1]
	mov	[ebp+%1],eax
.endm

.imacro	remcr	;const,dest
	;divide register by const
 .check	%N=2
	mov	ebx,%1
	mov	eax,[ebp+%2]
	cdq
	idiv	ebx
	mov	[ebp+%2],edx
.endm

.imacro	remrr	;source,dest
	;divide register by register
 .check	%N=2
	mov	ebx,[ebp+%1]
	mov	eax,[ebp+%2]
	cdq
	idiv	ebx
	mov	[ebp+%2],edx
.endm

.imacro	divcr	;const,dest
	;divide register by const
 .check	%N=2
	mov	ebx,%1
	mov	eax,[ebp+%2]
	cdq
	idiv	ebx
	mov	[ebp+%2],eax
.endm

.imacro	divrr	;src,dest
	;divide register by const
 .check	%N=2
	mov	ebx,[ebp+%1]
	mov	eax,[ebp+%2]
	cdq
	idiv	ebx
	mov	[ebp+%2],eax
.endm

.imacro	divir	;index,reg,dest
	;divide register by indexed
	mov	ebx,[ebp+%2]
	mov	ebx,[ebx+%1]
	mov	eax,[ebp+%3]
	cdq
	idiv	ebx
	mov	[ebp+%3],eax
.endm

;multyply macros

.imacro	mulcr	;const,dest
	;multyply dest register by const
 .check	%N=2
	imul	eax,[ebp+%2],%1
	mov	[ebp+%2],eax
.endm

.imacro	mulrr	;source,dest
	;multyply dest register by source
 .check	%N=2
	mov	eax,[ebp+%1]
	imul	[ebp+%2]
	mov	[ebp+%2],eax
.endm

.imacro	mulir	;index,source,dest
	;multyply dest register by indexed
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	imul	[ebp+%3]
	mov	[ebp+%3],eax
.endm

;compare macros

.imacro	cmpcib	;constant,n,base
	mov	eax,[ebp+%3]
	mov.b	al,[eax+%2]
	cmp.b	al,%1
.endm

.imacro	cmpcr	;const,dest
	;compare const with register
 .check	%N=2
	cmp	[ebp+%2],%1
.endm

.imacro	cmpcm	;const,memory
	;compare const with memory
 .check	%N=2
	mov	eax,%1
	cmp	%2,eax
.endm

.imacro	cmpmr	;memory,register
	;compare memory with register
 .check	%N=2
	mov	eax,%1
	cmp	[ebp+%2],eax
.endm

.imacro	cmprm	;register,memory
	;compare register with memory
 .check	%N=2
	mov	eax,[ebp+%1]
	cmp	%2,eax
.endm

.imacro	cmpci	;const,index,dest
	;compare const with register indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	cmp	[eax+%2],%1
.endm

.imacro	cmprr	;source,dest
	;compare register with register
 .check	%N=2
	mov	eax,[ebp+%1]
	cmp	[ebp+%2],eax
.endm

.imacro	cmpcd	;const,index1,index2
	;compare constant with double
 .check	%N=2
	mov	eax,[ebp+%2]
	mov	ebx,[ebp+%3]
	cmp	[eax+ebx],%1
.endm

.imacro	cmpir	;index,source,dest
	;compare register indexed with register
 .check	%N=3
	mov	eax,[ebp+%2]
	mov	eax,[eax+%1]
	cmp	[ebp+%3],eax
.endm

.imacro	cmpri	;source,index,dest
	;compare register with register indexed
 .check	%N=3
	mov	eax,[ebp+%1]
	mov	ebx,[ebp+%3]
	cmp	[ebx+%2],eax
.endm

;test macros

.imacro	tstd	;index1,index2
	;compare double indexed with 0
	cmpcd	0,%1,%2
.endm

.imacro	tstr	;dest
	;compare register with 0
 .check	%N=1
	cmpcr	0,%1	;compare with zero
.endm

.imacro	tstm	;address
	;compare memory with 0
 .check	%N=1
	cmpcm	0,%1	;compare with zero
.endm

.imacro	tsti	;index,dest
	;compare register indexed with 0
 .check	%N=2
	cmpci	0,%1,%2	;compare with zero
.endm

;bit set macros

.imacro	bstci	;constant,index,register
	;set bit 0-31 in indexed
	mov	eax,[ebp+%3]
	or	[eax+%2],1<<(%1)
.endm

;bit macros

.imacro	bitcr	;const,register
	;test bit 0-31 in register
 .check	%N=2
	test	[ebp+%2],1<<(%1)
.endm

.imacro	bitci	;const,index,register
	;test bit 0-31 in indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	test	[eax+%2],1<<(%1)
.endm

.imacro	bitrr	;source,dest
	;test bit register in register
 .check	%N=2
	mov	ecx,[ebp+%1]
	mov	eax,1
	shl	eax,cl
	test	[ebp+%2],eax
.endm

.imacro	bitrd	;register,idx1,idx2
	;test bit register in double indexed
 .check	%N=3
	mov	ecx,[ebp+%1]
	mov	eax,1
	shl	eax,cl
	mov	ebx,[ebp+%2]
	mov	ecx,[ebp+%3]
	test	[ebx+ecx],eax
.endm

;bit clear macros

.imacro	bclci	;constant,index,register
	;clear bit 0-31 in indexed
 .check	%N=3
	mov	eax,[ebp+%3]
	and	[eax+%2],~(1<<(%1))
.endm

;branch macros

.imacro	beq
	;if a=b then branch to %1
 .check	%N=1
	jz	%1
.endm

.imacro	bne
	;if a<>b then branch to %1
 .check	%N=1
	jnz	%1
.endm

.imacro	ble	;%1
	;if b<=a then branch to %1
 .check	%N=1
	jle	%1
.endm

.imacro	bgt	;%1
	;if b>a then branch to %1
 .check	%N=1
	jg	%1
.endm

.imacro	blt	;%1
	;if b<a then branch to %1
 .check	%N=1
	jl	%1
.endm

.imacro	bge	;%1
	;if b>=a then branch to %1
 .check	%N=1
	jge	%1
.endm

.imacro	bmi	;%1
	;if b<a then branch to %1
 .check	%N=1
	js	%1
.endm

.imacro	bpl	;%1
	;if b>=a then branch to %1
 .check	%N=1
	jns	%1
.endm

.imacro	gotc	;%1
	;branch direct
 .check	%N=1
	jmp	%1
.endm

.imacro	gotr	;reg
	;branch indirect
 .check	%N=1
	mov	eax,[ebp+%1]
	jmp	eax
.endm

.imacro	goti	;index,reg
	;branch indirect indexed
 .check	%N=2
	mov	eax,[ebp+%2]
	jmp	[eax+%1]
.endm

.imacro	gosc	;address
	;call direct
 .check	%N=1
	call	%1
.endm

.imacro	gosi	;index,source
	;call indexed
 .check	%N=2
	mov	eax,[ebp+%2]
	calli	[eax+%1]
.endm

.imacro	gosr	;dest
	;call indirect
 .check	%N=1
	calli	[ebp+%1]
.endm

.imacro	return
	;return from subroutine
 .check	%N=0
	ret
.endm

.imacro	tao	;function
	;taos OS function call
 .check	%N=1
 .if ?def(kernel_r4)
	mov	eax,[ebp+(VP_TAO-VP_R0)]
	calli	[eax+(%1*4)]
 .else
 .if ?def(TAO_%1)
	pshr	r15
	vcall	TAO/%1
	popr	r15
 .else
	mov	eax,[ebp+(VP_TAO-VP_R0)]
	calli	[eax+(%1*4)]
 .endif
 .endif
.endm

.include 'qcall'

.endif
