.if ~?def(DEF_TAO07VP)
DEF_TAO07VP=TRUE

***************************
** TAO_MVP.INC for TIC40 **
** (C) C.A.HINSLEY 1992  **
***************************

*notes on macros
*ir1 set to 1 for use in generateing bit test constants

;stack macros

.imacro	pshr	;source
	;push register onto stack
	subi	4,r7
	lsh3	-2,r7,ar4
	sti	%1,*ar4

.endm

.imacro	popr	;dest
	;pop register from stack
	lsh3	-2,r7,ar4
	ldx	*ar4,%1
	addi	4,r7
.endm

.imacro	pshm
	subi	4*%N,r7
	lsh3	-2,r7,ar4
__pushaddr:=%N-1
	recursav	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
.endm

.imacro	recursav
 .ifnb	%1
	sti	%1,*+ar4(__pushaddr)
__pushaddr:=__pushaddr-1
	recursav	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	popm
	lsh3	-2,r7,ar4
__popaddr:=0
	recursld	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
	addi	4*%N,r7
.endm

.imacro	recursld
 .ifnb	%1
	ldx	*+ar4(__popaddr),%1
__popaddr:=__popaddr+1
	recursld	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	pshall
	pshm	r0,r1,r2,r3,r4,r5,r6,r8,r9,r10,r11,r12,r13,r14,r15
.endm

.imacro	popall
	popm	r15,r14,r13,r12,r11,r10,r9,r8,r6,r5,r4,r3,r2,r1,r0
.endm

;effective address macros

.imacro	leai	;index,source,dest
	;copy effective address register indexed to register
 .check	%N=3
	addi3	%1,%2,%3
.endm

.imacro	lead	;index1,index2,dest
	;copy efective address double indexed to register
 .check	%N=3
	addi3	%1,%2,%3
.endm

.imacro	leac	;label,dest
	;load effective address pc relative
 .check	%N=2
	laj	%La
	nop
	lsh3	2,er11,%2
	addi	(%1)-%La,%2
%La:
.endm

;copy macros

.imacro	cpycr	;const,dest
	;copy const to register
 .check	%N=2
	ldx	%1,%2
.endm

.imacro	cpyci	;const,index,dest
	;copy const to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=15)&((%1)>=-16)
 .if (%2)<0
	stik	%1,*-ar4(-(%2)/4)
 .else
	stik	%1,*+ar4((%2)/4)
 .endif
 .else
	ldx	%1,er0
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
 .endif
.endm

.imacro	cpycm	;const,memory
	;copy const to memory
 .check	%N=2
	cpycr	(%2)/4,ar4
 .if ((%1)<=15)&((%1)>=-16)
	stik	%1,*ar4
 .else
	ldx	%1,er0
	sti	er0,*ar4
 .endif
.endm

.imacro	cpyrm	;reg,memory
	;copy register to memory
 .check	%N=2
	cpycr	(%2)/4,ar4
	sti	%1,*ar4
.endm

.imacro	cpymr	;memory,reg
	;copy memory to register
 .check	%N=2
	cpycr	(%1)/4,ar4
	ldx	*ar4,%2
.endm

.imacro	cpymi	;memory,index,dest
	;copy memory to register indexed
 .check	%N=3
	cpymr	%1,er0
	lsh3	-2,%3,ar4
 .if ((%2)>=0)&((%2)<128)
	sti	er0,*+ar4((%2)/4)
 .else
 .if (%2)<0
	ldx	-(%2)/4,ir0
	sti	er0,*-ar4(ir0)
 .else
	ldx	(%2)/4,ir0
	sti	er0,*+ar4(ir0)
 .endif
 .endif
.endm

.imacro	cpyrr	;source,dest
	;copy register to register
 .check	%N=2
 .if ~(%1=%2)
	ldx	%1,%2
 .endif
.endm

.imacro	cpyir	;index,source,dest
	;copy register indexed to register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
 .if (%1)<=-1024
	ldx	-(%1)/4,ir0
	ldx	*-ar4(ir0),%3
 .else
	ldx	*-ar4(-(%1)/4),%3
 .endif
 .else
 .if (%1)>=1024
	ldx	(%1)/4,ir0
	ldx	*+ar4(ir0),%3
 .else
	ldx	*+ar4((%1)/4),%3
 .endif
 .endif
.endm

.imacro	cpyirb	;index,source,dest
	;copy register indexed to register byte
 .check	%N=3
 .if (%1)=0
	and3	3,%2,er10
	lsh3	-2,%2,ar4
 .else
	addi3	%1,%2,er0
	and3	3,er0,er10
	lsh3	-2,er0,ar4
 .endif
	lsh	3,er10
	ldx	*ar4,er0
	#negi	er10,er10
	lsh	er10,er0
	lbu0	er0,%3
.endm

.imacro	cpydrb	;index1,index2,dest
	;copy double indexed to register byte
 .check	%N=3
	addi3	%1,%2,er0
	and3	3,er0,er10
	lsh3	-2,er0,ar4
	lsh	3,er10
	ldx	*ar4,er0
	#negi	er10,er10
	lsh	er10,er0
	lbu0	er0,%3
.endm

.imacro	cpyri	;source,index,dest
	;copy register to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if (%2)<0
 .if (%2)<=-1024
	ldx	-(%2)/4,ir0
	sti	%1,*-ar4(ir0)
 .else
	sti	%1,*-ar4(-(%2)/4)
 .endif
 .else
 .if (%2)>=1024
	ldx	(%2)/4,ir0
	sti	%1,*+ar4(ir0)
 .else
	sti	%1,*+ar4((%2)/4)
 .endif
 .endif
.endm

.imacro	cpyrib	;source,index,dest
	;copy register to register indexed byte
 .check	%N=3
 .if (%2)=0
	and3	3,%3,er10
	lsh3	-2,%3,ar4
 .else
	addi3	%2,%3,er0
	and3	3,er0,er10
	lsh3	-2,er0,ar4
 .endif
	lsh	3,er10
	ldx	255,er11
	lsh3	er10,%1,er0
	lsh	er10,er11
	ldx	*ar4,er10
	and	er11,er0
	andn	er11,er10
	or	er0,er10
	sti	er10,*ar4
.endm

.imacro	cpycib	;const,index,dest
	;copy const to register indexed byte
 .check	%N=3
	cpycr	%1,ir0
 .if (%2)=0
	and3	3,%3,er10
	lsh3	-2,%3,ar4
 .else
	addi3	%2,%3,er0
	and3	3,er0,er10
	lsh3	-2,er0,ar4
 .endif
	lsh	3,er10
	ldx	255,er11
	lsh3	er10,ir0,er0
	lsh	er10,er11
	ldx	*ar4,er10
	and	er11,er0
	andn	er11,er10
	or	er0,er10
	sti	er10,*ar4
.endm

.imacro	cpycdb	;const,index1,index2
	;copy const to double indexed byte
 .check	%N=3
	cpycr	%1,ir0
	addi3	%2,%3,er0
	and3	3,er0,er10
	lsh3	-2,er0,ar4
	lsh	3,er10
	ldx	255,er11
	lsh3	er10,ir0,er0
	lsh	er10,er11
	ldx	*ar4,er10
	and	er11,er0
	andn	er11,er10
	or	er0,er10
	sti	er10,*ar4
.endm

.imacro	cpyrd	;source,index1,index2
	;copy register to double indexed
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	sti	%1,*ar4
.endm

.imacro	cpycd	;const,index1,index2
	;copy const to double indexed
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=15)&((%1)>=-16)
	stik	%1,*ar4
 .else
	ldx	%1,er0
	sti	er0,*ar4
 .endif
.endm

.imacro	cpydr	;index1,index2,dest
	;copy double indexed to register
 .check	%N=3
	addi3	%1,%2,ar4
	lsh	-2,ar4
	ldx	*ar4,%3
.endm

.imacro	cpyblk	;src,dest,length
	;copy block of memory
 .check	%N=3	;num of args
 .if (%1=r0)&(%2=r1)&(%3=r8)
	cpycr	($300000+64)-1,ar4
	ldi	*ar4,er0
	laju	er0
	nop
	nop
	nop	;delayed call happens next
 .else
	pshm	r0,r1,r8,%1,%2,%3
	cpycr	($300000+64)-1,ar4
	ldi	*ar4,er0
	lsh3	-2,r7,ar4
	laju	er0
	ldi	*ar4,r8
	lda	*+ar4(1),r1
	lda	*+ar4(2),r0	;delayed call happens next
	freestruct	12
	popm	r8,r1,r0
 .endif
.endm

;clear macros

.imacro	clrr	;dest
	;clear register
	cpycr	0,%1	;copy zero to register
.endm

.imacro	clri	;index,dest
	;clear register indexed
	cpyci	0,%1,%2		;copy zero to register indexed
.endm

;add macros

.imacro	addrm	;reg,memory
	;add reg to memory
 .check	%N=2
	cpycr	(%2)/4,ar4
	addi3	%1,*ar4,er0
	sti	er0,*ar4
.endm

.imacro	addcm	;const,memory
	;add const to memory
 .check	%N=2
	cpycr	(%2)/4,ar4
 .if ((%1)<=127)&((%1)>=-128)
	addi3	%1,*ar4,er0
 .else
	ldx	%1,er0
	addi	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

.imacro	addmr	;memory,reg
	;add memory to register
 .check	%N=2
	cpycr	(%1)/4,ar4
	addi	*ar4,%2
.endm

.imacro	addrd	;reg,index1,index2
	;add register to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	addi3	*ar4,%1,er0
	sti	er0,*ar4
.endm

.imacro	addcr	;const,dest
	;add const to register
 .check	%N=2
 .if ((%1)<=32767)&((%1)>=-32768)
	addi	%1,%2
 .else
	ldx	%1,er0
	addi	er0,%2
 .endif
.endm

.imacro	addci	;const,index,dest
	;add const to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=127)&((%1)>=-128)
	addi3	%1,*+ar4((%2)/4),er0
 .else
	ldx	%1,er0
 .if (%2)<0
	addi	*-ar4(-(%2)/4),er0
 .else
	addi	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

.imacro	addrr	;source,dest
	;add register to register
 .check	%N=2
	addi	%1,%2
.endm

.imacro	addir	;index,source,dest
	;add register indexed to register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	addi	*-ar4(-(%1)/4),%3
 .else
	addi	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	addri	;source,index,dest
	;add register to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	addi3	*+ar4((%2)/4),%1,er0
	sti	er0,*+ar4((%2)/4)
.endm

.imacro	addcd	;const,index1,index2
	;add const to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	addi3	%1,*ar4,er0
 .else
	ldx	%1,er0
	addi	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

.imacro	adddr	;index1,index2,reg
	;add double to reg
 .check	%N=3
	addi3	%2,%1,ar4
	lsh	-2,ar4
	addi	*ar4,%3
.endm

;subtract macros

.imacro	subcm	;const,memory
	;sub const from memory
 .check	%N=2
	cpycr	(%2)/4,ar4
 .if ((%1)<=127)&((%1)>=-128)
	subi3	%1,*ar4,er0
 .else
	ldx	%1,er0
	#subri	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

.imacro	subrm	;reg,memory
	;sub reg from memory
 .check	%N=2
	cpycr	(%2)/4,ar4
	subi3	%1,*ar4,er0
	sti	er0,*ar4
.endm

.imacro	submr	;memory,reg
	;sub memory from register
 .check	%N=2
	cpycr	(%1)/4,ar4
	subi	*ar4,%2
.endm

.imacro	subrd	;reg,index1,index2
	;sub register from double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	subi3	%1,*ar4,er0
	sti	er0,*ar4
.endm

.imacro	subcd	;const,index1,index2
	;sub const from double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	subi3	%1,*ar4,er0
 .else
	ldx	%1,er0
	#subri	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

.imacro	subcr	;const,dest
	;subtract const from register
 .check	%N=2
 .if ((%1)<=32767)&((%1)>=-32768)
	subi	%1,%2
 .else
	ldx	%1,er0
	subi	er0,%2
 .endif
.endm

.imacro	subci	;const,index,dest
	;subtract const from register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=127)&((%1)>=-128)
 .if (%2)<0
	ldx	-(%2)/4,ir0
	subi3	%1,*-ar4(ir0),er0
 .else
	subi3	%1,*+ar4((%2)/4),er0
 .endif
 .else
	ldx	%1,er0
 .if (%2)<0
	#subri	*-ar4(-(%2)/4),er0
 .else
	#subri	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

.imacro	subrr	;source,dest
	;subtract register from register
 .check	%N=2
 .if %1=%2
	ldx	0,%2
 .else
	subi	%1,%2
 .endif
.endm

.imacro	subir	;index,source,dest
	;subtract register indexed from register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	subi	*-ar4(-(%1)/4),%3
 .else
	subi	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	subri	;source,index,dest
	;subtract register from register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if (%2)<0
	ldx	*-ar4(-(%2)/4),er0
 .else
	ldx	*+ar4((%2)/4),er0
 .endif
	subi	%1,er0
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

;and macros

.imacro	andrd	;reg,index1,index2
	;and register to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	and3	*ar4,%1,er0
	sti	er0,*ar4
.endm

.imacro	andcr	;const,dest
	;and const to register
 .check	%N=2
 .if ((%1)<=127)&((%1)>=-128)
	and3	%1,%2,%2
 .else
 .if ~(((%1)>>16)&$FFFF)
	and	%1,%2
 .else
	ldhi	(%1)>>16,er0
 .if (%1)&$FFFF
	or	(%1)&$FFFF,er0
 .endif
	and	er0,%2
 .endif
 .endif
.endm

.imacro	andci	;const,index,dest
	;and const to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=127)&((%1)>=-128)
	and3	%1,*+ar4((%2)/4),er0
 .else
	ldx	%1,er0
 .if (%2)<0
	and	*-ar4(-(%2)/4),er0
 .else
	and	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

.imacro	andrr	;source,dest
	;and register to register
 .check	%N=2
	and	%1,%2
.endm

.imacro	andir	;index,source,dest
	;and register indexed to register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	and	*-ar4(-(%1)/4),%3
 .else
	and	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	andri	;source,index,dest
	;and register to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	and3	*+ar4((%2)/4),%1,er0
	sti	er0,*+ar4((%2)/4)
.endm

.imacro	andcd	;const,index1,index2
	;and const to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	and3	%1,*ar4,er0
 .else
	ldx	%1,er0
	and	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

;or macros

.imacro	orrd	;reg,index1,index2
	;or register to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	or3	*ar4,%1,er0
	sti	er0,*ar4
.endm

.imacro	orcr	;const,dest
	;or const to register
 .check	%N=2
 .if ((%1)<=127)&((%1)>=-128)
	or3	%1,%2,%2
 .else
 .if ~(((%1)>>16)&$FFFF)
	or	%1,%2
 .else
	ldhi	(%1)>>16,er0
 .if (%1)&$FFFF
	or	(%1)&$FFFF,er0
 .endif
	or	er0,%2
 .endif
 .endif
.endm

.imacro	orci	;const,index,dest
	;or const to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=127)&((%1)>=-128)
	or3	%1,*+ar4((%2)/4),er0
 .else
	ldx	%1,er0
 .if (%2)<0
	or	*-ar4(-(%2)/4),er0
 .else
	or	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

.imacro	orrr	;source,dest
	;or register to register
 .check	%N=2
	or	%1,%2
.endm

.imacro	orir	;index,source,dest
	;or register indexed to register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	or	*-ar4(-(%1)/4),%3
 .else
	or	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	orri	;source,index,dest
	;or register to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	or3	*+ar4((%2)/4),%1,er0
	sti	er0,*+ar4((%2)/4)
.endm

.imacro	orcd	;const,index1,index2
	;or const to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	or3	%1,*ar4,er0
 .else
	ldx	%1,er0
	or	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

;xor macros

.imacro	xorrd	;reg,index1,index2
	;xor register to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	xor3	*ar4,%1,er0
	sti	er0,*ar4
.endm

.imacro	xorcr	;const,dest
	;xor const to register
 .check	%N=2
 .if ((%1)<=127)&((%1)>=-128)
	xor3	%1,%2,%2
 .else
 .if ~(((%1)>>16)&$FFFF)
	xor	%1,%2
 .else
	ldhi	(%1)>>16,er0
 .if (%1)&$FFFF
	or	(%1)&$FFFF,er0
 .endif
	xor	er0,%2
 .endif
 .endif
.endm

.imacro	xorci	;const,index,dest
	;xor const to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if ((%1)<=127)&((%1)>=-128)
	xor3	%1,*+ar4((%2)/4),er0
 .else
	ldx	%1,er0
 .if (%2)<0
	xor	*-ar4(-(%2)/4),er0
 .else
	xor	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

.imacro	xorrr	;source,dest
	;xor register to register
 .check	%N=2
	xor	%1,%2
.endm

.imacro	xorir	;index,source,dest
	;xor register indexed to register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	xor	*-ar4(-(%1)/4),%3
 .else
	xor	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	xorri	;source,index,dest
	;xor register to register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	xor3	*+ar4((%2)/4),%1,er0
	sti	er0,*+ar4((%2)/4)
.endm

.imacro	xorcd	;const,index1,index2
	;xor const to double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	xor3	%1,*ar4,er0
 .else
	ldx	%1,er0
	xor	*ar4,er0
 .endif
	sti	er0,*ar4
.endm

;increment macros

.imacro	incr	;source
 .check	%N=1
	;increment register
	addcr	1,%1	;add 1 to register
.endm

.imacro	inci	;index,source
	;increment register indexed
 .check	%N=2
	addci	1,%1,%2	;add 1 to register indexed
.endm

.imacro	incm	;memory
	;increment memory
 .check	%N=1
	addcm	1,%1	;add 1 to memory
.endm

;decrement macros

.imacro	decr	;source
 .check	%N=1
	;decrement register
	subcr	1,%1	;subtract 1 from register
.endm

.imacro	deci	;index,source
	;decrement register indexed
 .check	%N=2
	subci	1,%1,%2	;subtract 1 from register indexed
.endm

.imacro	decm	;memory
	;decrement memory
 .check	%N=1
	subcm	1,%1	;add 1 to memory
.endm

;negate macros

.imacro	negr	;reg
	;negate register
 .check	%N=1
	#negi	%1,%1
.endm

.imacro	negi	;index,dest
	;negate register indexed
 .check	%N=2
	lsh3	-2,%2,ar4
 .if (%1)<0
	#negi	*-ar4(-(%1)/4),er0
	sti	er0,*-ar4(-(%1)/4)
 .else
	#negi	*+ar4((%1)/4),er0
	sti	er0,*+ar4((%1)/4)
 .endif
.endm

.imacro	notr	;reg
 .check	%N=1
	not	%1,%1
.endm

;exchange macros

.imacro	exgrr	;source,dest
	;exchange register with register
 .check	%N=2
 .if ~(%1=%2)
	lda	%1,ar4
	ldx	%2,%1
	ldx	ar4,%2
 .endif
.endm

.imacro	exgir	;index,source,dest
	;exchange indexed with register
 .check	%N=3
	lsh3	-2,%2,ar4
	ldx	%3,er0
 .if (%1)<0
	ldx	*-ar4(-(%1)/4),%3
	sti	er0,*-ar4(-(%1)/4)
 .else
	ldx	*+ar4((%1)/4),%3
	sti	er0,*+ar4((%1)/4)
 .endif
.endm

;shift macros

.imacro	lsrir	;index,source,dest
	;logical shift right indexed register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	#negi	*-ar4(-(%1)/4),er0
 .else
	#negi	*+ar4((%1)/4),er0
 .endif
	lsh	er0,%3
.endm

.imacro	lsrcr	;count,dest
	;logical shift right register
 .check	%N=2
	lsh	-%1,%2
.endm

.imacro	aslrr	;countreg,dest
	;arithmetic shift left register
 .check	%N=2
	ash	%1,%2
.endm

.imacro	aslcr	;count,dest
	;arithmetic shift left register
 .check	%N=2
	ash	%1,%2
.endm

.imacro	aslci	;count,index,reg
	;arithmetic shift left indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	ash3	%1,*+ar4((%2)/4),er0
	sti	er0,*+ar4((%2)/4)
.endm

.imacro	asrcr	;count,dest
	;arithmetic shift right register
 .check	%N=2
	ash	-%1,%2
.endm

.imacro	lsrrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	#negi	%1,er0
	lsh	er0,%2
.endm

;type conversion macros

.imacro	b2i	;reg
	lb0	%1,%1
.endm

;divide macros

.imacro	remcr	;const,dest
	;divide register by const
 .check	%N=2
.endm

.imacro	divcr	;const,dest
	;divide register by const
 .check	%N=2
.endm

.imacro	divrr	;src,dest
	;divide register by const
 .check	%N=2
.endm

.imacro	divir	;index,reg,dest
	;divide register by indexed
.endm

;multiply macros

.imacro	mulcr	;const,dest
	;multiply dest register by const
 .check	%N=2
 .if ((%1)<=32767)&((%1)>=-32768)
	mpyi	%1,%2
 .else
	ldx	%1,er0
	mpyi	er0,%2
 .endif
.endm

.imacro	mulrr	;source,dest
	;multiply dest register by source
 .check	%N=2
	mpyi	%1,%2
.endm

.imacro	mulir	;index,source,dest
	;multiply dest register by indexed
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	mpyi	*-ar4(-(%1)/4),%3
 .else
	mpyi	*+ar4((%1)/4),%3
 .endif
.endm

;compare macros

.imacro	cmpmr	;memory,reg
	;compare memory to register
 .check	%N=2
	cpycr	(%1)/4,ar4
	cmpi	*ar4,%2
.endm

.imacro	cmpcm	;const,memory
	;compare const with memory
 .check	%N=2
	cpycr	(%2)/4,ar4
 .if ((%1)<=127)&((%1)>=-128)
	cmpi3	%1,*ar4
 .else
	ldx	%1,er0
	#subri	*ar4,er0
 .endif
.endm

.imacro	cmpcd	;const,index1,index2
	;compare const from double
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
 .if ((%1)<=127)&((%1)>=-128)
	cmpi3	%1,*ar4
 .else
	ldx	%1,er0
	#subri	*ar4,er0
 .endif
.endm

.imacro	cmpcr	;const,dest
	;compare const with register
 .check	%N=2
 .if ((%1)<=32767)&((%1)>=-32768)
	cmpi	%1,%2
 .else
	ldx	%1,er0
	cmpi	er0,%2
 .endif
.endm

.imacro	cmpci	;const,index,dest
	;compare const with register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if (%2)<128
 .if ((%1)<=127)&((%1)>=-128)
	cmpi3	%1,*+ar4((%2)/4)
 .else
	ldx	%1,er0
	#subri	*+ar4((%2)/4),er0
 .endif
 .else
	ldx	(%2)/4,ir0
 .if ((%1)<=127)&((%1)>=-128)
	cmpi3	%1,*+ar4(ir0)
 .else
	ldx	%1,er0
	#subri	*+ar4(ir0),er0
 .endif
 .endif
.endm

.imacro	cmprr	;source,dest
	;compare register with register
 .check	%N=2
	cmpi	%1,%2
.endm

.imacro	cmpir	;index,source,dest	;compare register indexed with register
 .check	%N=3
	lsh3	-2,%2,ar4
 .if (%1)<0
	cmpi	*-ar4(-(%1)/4),%3
 .else
	cmpi	*+ar4((%1)/4),%3
 .endif
.endm

.imacro	cmpri	;source,index,dest
	;compare register with register indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if (%2)<0
	ldx	*-ar4(-(%2)/4),er0
 .else
	ldx	*+ar4((%2)/4),er0
 .endif
	cmpi	%1,er0
.endm

;test macros

.imacro	tstd	;index1,index2
	;compare double indexed with 0
	cmpcd	0,%1,%2
.endm

.imacro	tstr	;dest
	;compare register with 0
 .check	%N=1
	cmpcr	0,%1	;compare with zero
.endm

.imacro	tsti	;index,dest
	;compare register indexed with 0
 .check	%N=2
	cmpci	0,%1,%2	;compare with zero
.endm

.imacro	tstm	;memory
	;compare memory with 0
 .check	%N=1
	cmpcm	0,%1	;compare with zero
.endm

;bit macros

.imacro	bitcr	;const,register
	;test bit 0-31 in register
 .check	%N=2
 .if (%1)<=15
	tstb	1<<(%1),%2		;ready for branch
 .else
	ldhi	1<<((%1)-16),er0
	tstb	er0,%2	;ready for branch
 .endif
.endm

.imacro	bitci	;const,index,register
	;test bit 0-31 in indexed
 .check	%N=3
	lsh3	-2,%3,ar4
 .if (%1)<=6
	tstb3	1<<(%1),*+ar4((%2)/4)
 .else
	lsh3	%1,ir1,er0
 .if (%2)<0
	tstb	*-ar4(-(%2)/4),er0
 .else
	tstb	*+ar4((%2)/4),er0
 .endif
 .endif
.endm

.imacro	bitrr	;source,dest
	;test bit register in register
 .check	%N=2
	lsh3	%1,ir1,er0
	tstb	er0,%2	;ready for branch
.endm

.imacro	bitrd	;register,idx1,idx2
	;test bit register in double indexed
 .check	%N=3
	addi3	%2,%3,ar4
	lsh	-2,ar4
	ldx	*ar4,er0	;get interger from memory
	lsh3	%1,ir1,ar4
	tstb	ar4,er0	;ready for branch
.endm

;bit set macros

.imacro	bstci	;constant,index,register
	;set bit 0-31 in indexed
	lsh3	-2,%3,ar4
 .if (%1)<=6
	or3	1<<(%1),*+ar4((%2)/4),er0
 .else
	lsh3	%1,ir1,er0
 .if (%2)<0
	or	*-ar4(-(%2)/4),er0
 .else
	or	*+ar4((%2)/4),er0
 .endif
 .endif
 .if (%2)<0
	sti	er0,*-ar4(-(%2)/4)
 .else
	sti	er0,*+ar4((%2)/4)
 .endif
.endm

;bit clear macros

.imacro	bclci	;constant,index,register
	;clear bit 0-31 in indexed
 .check	%N=3
	lsh3	-2,%3,ar4
	lsh3	%1,ir1,er0
	not	er0,er0
	and	*+ar4((%2)/4),er0
	sti	er0,*+ar4((%2)/4)
.endm

;goto macros

.imacro	bpl	;label
	;branch if plus
 .check	%N=1
	bp	%1
.endm

.imacro	bmi	;label
	;branch if minus
 .check	%N=1
	bn	%1
.endm

.imacro	gotc	;label
	;branch direct
 .check	%N=1
	br	%1	;branch (24bit immediate)
.endm

.imacro	gotr	;reg
	;branch indirect
 .check	%N=1
	lsh3	-2,%1,ar4
	bu	ar4	;branch unconditionally
.endm

.imacro	goti	;index,reg
	;branch indirect indexed
 .check	%N=2
	lsh3	-2,%2,ar4
	lsh3	-2,*+ar4((%1)/4),er0
	bu	er0
.endm

.imacro	gosc	;address
	;call direct
 .check	%N=1
	laj	%1
	lsh3	-2,r7,ar4
	subi	4,r7
	sti	er11,*-ar4(1)	;JUMPS HERE
.endm

.imacro	gosi	;index,source
	;call indexed
 .check	%N=2
	lsh3	-2,%2,ar4
	lsh3	-2,*+ar4((%1)/4),er0
	laju	er0
	lsh3	-2,r7,ar4
	subi	4,r7
	sti	er11,*-ar4(1)	;JUMPS HERE
.endm

.imacro	gosr	;dest
	;call indirect
 .check	%N=1
	lsh3	-2,%1,ar4
	laju	ar4
	lsh3	-2,r7,ar4
	subi	4,r7
	sti	er11,*-ar4(1)	;JUMPS HERE
.endm

.imacro	return
	;return from subroutine
 .check	%N=0
	lsh3	-2,r7,ar4
	lsh3	-2,*ar4,er0
	bud	er0
	addi	4,r7     
	nop
	nop		;JUMPS HERE
.endm

.imacro	tao	;function
	;taos OS function call
 .check	%N=1
	cpycr	$300000+64,ar4	;lookup table for TAO funcs
	ldi	*+ar4(%1),er0
	laju	er0
	lsh3	-2,r7,ar4
	subi	4,r7
	sti	er11,*-ar4(1)	;JUMPS HERE
.endm

.include 'qcall'

.endif
