.if ~?def(DEF_TAO10VP)
DEF_TAO10VP=TRUE

***************************
** TAO_MVP.INC for T9000 **
***************************

;stack macros

 .if ~?def(kernel_r4)
.imacro	pshp
	;copy priority to stack (0=high 1=low)
	ldpri
	ldl	r7	;register r7 is stack pointer
	ldnlp	-1	;push stack down
	stl	r7	;save new stack location
	ldl	r7	;register r7 is stack pointer
	stnl	0	;register on stack
.endm
 .endif

.imacro	pshr	;source
	;push register onto stack
	ldl	%1	;get register
	ldl	r7	;register r7 is stack pointer
	ldnlp	-1	;push stack down
	stl	r7	;save new stack location
	ldl	r7	;register r7 is stack pointer
	stnl	0	;register on stack
.endm

.imacro	popr	;dest
	;pop register from stack
	ldl	r7	;register r7 is stack pointer
	ldnl	0
	ldl	r7	;register r7 is stack pointer
	ldnlp	1
	stl	r7	;save new stack pointer
	stl	%1	;put register
.endm

 .if ~?def(kernel_r4)
.imacro	pshm
	ldl	r7
	adc	-4*%N
	stl	r7
__pushaddr:=%N-1
	recursav	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
.endm

.imacro	recursav
 .ifnb	%1
	ldl	%1
	ldl	r7
	stnl	__pushaddr
__pushaddr:=__pushaddr-1
	recursav	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	popm
__popaddr:=0
	recursld	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
	ldl	r7
	adc	4*%N
	stl	r7
.endm

.imacro	recursld
 .ifnb	%1
	ldl	r7
	ldnl	__popaddr
	stl	%1
__popaddr:=__popaddr+1
	recursld	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	pshall
	pshm	r0,r1,r2,r3,r4,r5,r6,r8,r9,r10,r11,r12,r13,r14,r15
.endm

.imacro	popall
	popm	r15,r14,r13,r12,r11,r10,r9,r8,r6,r5,r4,r3,r2,r1,r0
.endm
 .endif

;effective address macros

.imacro	leai	;index,source,dest
	;copy effective address register indexed to register
 .check	%N=3
	ldl	%2
	adc	%1
	stl	%3
.endm

.imacro	lead	;index1,index2,dest
	;copy efective address double indexed to register
 .check	%N=3
	ldl	%1
	ldl	%2
	add
	stl	%3
.endm

.imacro	leac	;label,dest
	;load effective address pc relative
 .check	%N=2
	ldc	%1-2,ldpi
	stl	%2
.endm

;copy macros

.imacro	cpycr	;const,dest
	;copy const to register
 .check	%N=2
	ldc	%1	;get %1
	stl	%2	;put to register
.endm

.imacro	cpyci	;const,index,dest
	;copy const to register indexed
 .check	%N=3
	ldc	%1	;get %1
	ldl	%3
	stnl	(%2)/4	;put to register indexed
.endm

.imacro	cpyrr	;source,dest
	;copy register to register
 .check	%N=2
 .if ~(%1=%2)
	ldl	%1	;get source register
	stl	%2	;put dest register
 .endif
.endm

.imacro	cpypr	;dest
	;copy priority to register (0=high 1=low)
	ldpri
	stl	%1	;put dest register
.endm

.imacro	cpyrm	;source,dest
	;copy register to memory
 .check	%N=2
	ldl	%1	;get register
	mint	;index from bottom of memory
	stnl	((%2)-mint)/4
.endm

.imacro	cpymr	;source,dest
	;copy memory to register
 .check	%N=2
	mint
	ldnl	((%1)-mint)/4
	stl	%2
.endm

.imacro	cpymi	;address,index,dest
	;copy memory to indexed
 .check	%N=3
	mint
	ldnl	((%1)-mint)/4
	ldl	%3
	stnl	(%2)/4	;put register indexed
.endm

.imacro	cpymm	;source,dest
	;copy memory to memory
 .check	%N=2
	mint
	ldnl	((%1)-mint)/4
	mint
	stnl	((%2)-mint)/4
.endm

.imacro	cpycm	;const,dest
	;copy const to memory
 .check	%N=2
	ldc	%1	;get %1
	mint	;index from bottom of memory
	stnl	((%2)-mint)/4
.endm

.imacro	cpyir	;index,source,dest
	;copy register indexed to register
 .check	%N=3
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	stl	%3	;put dest register
.endm

.imacro	cpyri	;source,index,dest
	;copy register to register indexed
 .check	%N=3
	ldl	%1	;get register
	ldl	%3
	stnl	(%2)/4	;put register indexed
.endm

.imacro	cpyrd	;source,index1,index2
	;copy register to double indexed
 .check	%N=3
	ldl	%1	;get register
	ldl	%2
	ldl	%3
	add
	stnl	0	;put double indexed
.endm

.imacro	cpyrdb	;src,base,reg2
 .check	%N=3
	ldl	%1
	ldl	%3
	ldl	%2
	add
	sb
.endm

.imacro	cpycd	;const,index1,index2
	;copy const to double indexed
 .check	%N=3
	ldc	%1
	ldl	%2
	ldl	%3
	add
	stnl	0	;put double indexed
.endm

.imacro	cpycdb	;const,index1,index2
	;copy constant to double indexed
 .check	%N=3
	ldc	%1
	ldl	%2
	ldl	%3
	add
	sb
.endm

.imacro	cpydr	;index1,index2,dest
	;copy double indexed to register
 .check	%N=3
	ldl	%1
	ldl	%2
	add
	ldnl	0	;get double indexed
	stl	%3	;put to register
.endm

.imacro	cpyii	;sindex,source,dindex,dest
	;copy register indexed to register indexed
 .check	%N=4
	ldl	%2
	ldnl	(%1)/4	;get register indexed
	ldl	%4
	stnl	(%3)/4	;put register indexed
.endm

.imacro	cpyirb	;n,base,dst
	ldl	%2
	adc	%1
	lb
	stl	%3
.endm

.imacro	cpyrib	;src,n,base
	ldl	%1
	ldl	%3
	adc	%2
	sb
.endm

.imacro	cpycib	;src,n,base
	ldc	%1
	ldl	%3
	adc	%2
	sb
.endm

.imacro	cpyblk	;source,dest,length
	;copy a block of memory
	;inputs
	;source address
	;destination address
	;length of block (in bytes)
 .check	%N=3
	ldl	%1	;get source register
	ldl	%2	;get dest register
	ldl	%3	;get length register
	move		;copy block
.endm

.imacro	cpystr	;src,dst
	;src and dst point to nul after using.
%La:	ldl %1,lb,dup,
	  ldl %2,sb
	  cj %Lb
	addcr	1,%1
	addcr	1,%2
	gotc	%La
%Lb:
.endm

.imacro	cpybu	;src,dst,sz
	;copy block up
	;addrr	%3,%1
	;addrr	%3,%2
	ldl %3,cj %Lb
%La:	decr	%1
	decr	%2
	ldl %1,lb,ldl %2,sb
	decr	%3
	ldl %3,eqc 0,cj %La
%Lb:
.endm

.imacro	cpybd	;src,dst,sz
	;copy block down
	ldl %3,cj %Lb
%La:	ldl %1,lb,ldl %2,sb
	incr	%1
	incr	%2
	decr	%3
	ldl %3,eqc 0,cj %La
%Lb:
.endm

;clear macros

.imacro	clrr	;dest
	;clear register
	cpycr	0,%1	;copy zero to register
.endm

.imacro	clri	;index,dest
	;clear register indexed
	cpyci	0,%1,%2		;copy zero to register indexed
.endm

.imacro	clrm	;address
	;clear memory
	cpycm	0,%1
.endm

;add macros

.imacro	addrd	;reg,index1,index2
	;add register to double
 .check	%N=3
	ldl	%2
	ldl	%3
	add
	dup
	ldnl	0
	ldl	%1
	add
	rev
	stnl	0
.endm

.imacro	addrm	;source,dest
	;add from register to memory
 .check	%N=2
	ldl	%1	;get register
	mint
	ldnl	(%2-mint)/4
	add
	mint	;index from bottom of memory
	stnl	(%2-mint)/4
.endm

.imacro	addcm	;const,dest
	;add const to memory
 .check	%N=2
	mint
	ldnl	(%2-mint)/4
	adc	%1
	mint	;index from bottom of memory
	stnl	(%2-mint)/4
.endm

.imacro	addmr	;source,dest
	;add from memory to register
 .check	%N=2
	mint
	ldnl	((%1)-mint)/4
	ldl	%2
	add
	stl	%2
.endm

.imacro	addcr	;const,dest
	;add const to register
 .check	%N=2
	ldl	%2	;get register
	adc	%1	;add %1
	stl	%2	;put register
.endm

.imacro	addci	;const,index,dest
	;add const to register indexed
 .check	%N=3
	ldl	%3	;get register
	ldnl	(%2)/4	;get register indexed
	adc	%1	;add %1
	ldl	%3	;get register
	stnl	(%2)/4	;put register indexed
.endm

.imacro	addrr	;source,dest
	;add register to register
 .check	%N=2
	ldl	%1	;get source register
	ldl	%2	;get dest register
	add	;add up
	stl	%2	;put dest register
.endm

.imacro	addir	;index,source,dest
	;add register indexed to register
 .check	%N=3
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	ldl	%3	;get dest register
	add	;add up
	stl	%3	;put dest register
.endm

.imacro	addri	;source,index,dest
	;add register to register indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldnl	(%2)/4	;get register indexed
	ldl	%1	;get source register
	add	;add up
	ldl	%3	;get dest register
	stnl	(%2)/4	;put dest register indexed
.endm

.imacro	addcd	;const,index1,index2
	;add const to double
 .check	%N=3
	ldl	%2
	ldl	%3
	add
	dup
	ldnl	0
	adc	%1
	rev
	stnl	0
.endm

.imacro	adddr	;index1,index2,reg
	;add double to reg
 .check	%N=3
	ldl	%1
	ldl	%2
	add
	ldnl	0
	ldl	%3
	add
	stl	%3
.endm

;subtract macros

.imacro	subrd	;reg,index1,index2
	;sub register from double
 .check	%N=3
	ldl	%2
	ldl	%3
	add
	dup
	ldnl	0
	ldl	%1
	diff
	rev
	stnl	0
.endm

.imacro	submr	;source,dest
	;subtract memory from register
 .check	%N=2
	ldl	%2
	mint
	ldnl	((%1)-mint)/4
	diff
	stl	%2
.endm

.imacro	subcd	;const,index1,index2
	;sub const from double
 .check	%N=3
	ldl	%2
	ldl	%3
	add
	dup
	ldnl	0
	adc	-(%1)
	rev
	stnl	0
.endm

.imacro	subcr	;const,dest
	;subtract %1 from register
 .check	%N=2
	ldl	%2	;get register
	adc	-(%1)	;subtract %1
	stl	%2	;put register
.endm

.imacro	subcm	;const,dest
	;subtract %1 from memory
 .check	%N=2
	mint
	ldnl	(%2-mint)/4
	adc	-(%1)
	mint	;index from bottom of memory
	stnl	(%2-mint)/4
.endm

.imacro	subrm	;reg,dest
	;subtract %1 from memory
 .check	%N=2
	mint
	ldnl	(%2-mint)/4
	ldl	%1
	diff
	mint	;index from bottom of memory
	stnl	(%2-mint)/4
.endm

.imacro	subci	;const,index,dest
	;subtract %1 from register indexed
 .check	%N=3
	ldl	%3	;get register
	ldnl	(%2)/4	;get register indexed
	adc	-%1	;subtract %1
	ldl	%3	;get register
	stnl	(%2)/4	;put dest register indexed
.endm

.imacro	subrr	;source,dest
	;subtract register from register
 .check	%N=2
 .if %1=%2
	ldc	0
	stl	%2
 .else
	ldl	%2	;get dest register
	ldl	%1	;get source register
	diff	;subtract
	stl	%2	;put dest register
 .endif
.endm

.imacro	subir	;index,source,dest
	;subtract register indexed from register
 .check	%N=3
	ldl	%3	;get dest register
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	diff	;subtract
	stl	%3	;put dest register
.endm

.imacro	subri	;source,index,dest
	;subtract register from register indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldnl	(%2)/4	;get dest register indexed
	ldl	%1	;get source register
	diff	;subtract
	ldl	%3	;get dest register
	stnl	(%2)/4	;put dest register indexed
.endm

;and macros

.imacro	andrd	;reg,index1,index2
	;and register to double
 .check	%N=3
	ldl	%2
	ldl	%3
	add
	dup
	ldnl	0
	ldl	%1
	and
	rev
	stnl	0
.endm

.imacro	andcr	;const,dest
	;and const to register
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;and %1
	and
	stl	%2	;put register
.endm

.imacro	andci	;const,index,dest
	;and const to register indexed
 .check	%N=3
	ldl	%3	;get register
	ldnl	(%2)/4	;get register indexed
	ldc	%1
	and
	ldl	%3	;get register
	stnl	(%2)/4	;put register indexed
.endm

.imacro	andrr	;source,dest
	;and register to register
 .check	%N=2
	ldl	%1	;get source register
	ldl	%2	;get dest register
	and	;and up
	stl	%2	;put dest register
.endm

.imacro	andir	;index,source,dest
	;and register indexed to register
 .check	%N=3
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	ldl	%3	;get dest register
	and	;and up
	stl	%3	;put dest register
.endm

.imacro	andri	;source,index,dest
	;and register to register indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldnl	(%2)/4	;get register indexed
	ldl	%1	;get source register
	and	;and up
	ldl	%3	;get dest register
	stnl	(%2)/4	;put dest register indexed
.endm

.imacro	andcd	;const,index1,index2
	;and const to double
 .check	%N=3
	ldl	%2
	ldl	%3
	and
	dup
	ldnl	0
	ldc	%1
	and
	rev
	stnl	0
.endm

;or macros

.imacro	orrd	;reg,index1,index2
	;or register to double
 .check	%N=3
	ldl	%2
	ldl	%3
	or
	dup
	ldnl	0
	ldl	%1
	add
	rev
	stnl	0
.endm

.imacro	orcr	;const,dest
	;or const to register
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;or %1
	or
	stl	%2	;put register
.endm

.imacro	orci	;const,index,dest
	;or const to register indexed
 .check	%N=3
	ldl	%3	;get register
	ldnl	(%2)/4	;get register indexed
	ldc	%1
	or
	ldl	%3	;get register
	stnl	(%2)/4	;put register indexed
.endm

.imacro	orrr	;source,dest
	;or register to register
 .check	%N=2
	ldl	%1	;get source register
	ldl	%2	;get dest register
	or	;or up
	stl	%2	;put dest register
.endm

.imacro	orir	;index,source,dest
	;or register indexed to register
 .check	%N=3
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	ldl	%3	;get dest register
	or	;or up
	stl	%3	;put dest register
.endm

.imacro	orri	;source,index,dest
	;or register to register indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldnl	(%2)/4	;get register indexed
	ldl	%1	;get source register
	or	;or up
	ldl	%3	;get dest register
	stnl	(%2)/4	;put dest register indexed
.endm

.imacro	orcd	;const,index1,index2
	;or const to double
 .check	%N=3
	ldl	%2
	ldl	%3
	or
	dup
	ldnl	0
	ldc	%1
	or
	rev
	stnl	0
.endm

;xor macros

.imacro	xorrd	;reg,index1,index2
	;xor register to double
 .check	%N=3
	ldl	%2
	ldl	%3
	xor
	dup
	ldnl	0
	ldl	%1
	add
	rev
	stnl	0
.endm

.imacro	xorcr	;const,dest
	;xor const to register
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;xor %1
	xor
	stl	%2	;put register
.endm

.imacro	xorci	;const,index,dest
	;xor const to register indexed
 .check	%N=3
	ldl	%3	;get register
	ldnl	(%2)/4	;get register indexed
	ldc	%1
	xor
	ldl	%3	;get register
	stnl	(%2)/4	;put register indexed
.endm

.imacro	xorrr	;source,dest
	;xor register to register
 .check	%N=2
	ldl	%1	;get source register
	ldl	%2	;get dest register
	xor	;xor up
	stl	%2	;put dest register
.endm

.imacro	xorir	;index,source,dest
	;xor register indexed to register
 .check	%N=3
	ldl	%2
	ldnl	(%1)/4	;get source register indexed
	ldl	%3	;get dest register
	xor	;xor up
	stl	%3	;put dest register
.endm

.imacro	xorri	;source,index,dest
	;xor register to register indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldnl	(%2)/4	;get register indexed
	ldl	%1	;get source register
	xor	;xor up
	ldl	%3	;get dest register
	stnl	(%2)/4	;put dest register indexed
.endm

.imacro	xorcd	;const,index1,index2
	;xor const to double
 .check	%N=3
	ldl	%2
	ldl	%3
	xor
	dup
	ldnl	0
	ldc	%1
	xor
	rev
	stnl	0
.endm

;increment macros

.imacro	incr	;source
 .check	%N=1
	;increment register
	addcr	1,%1	;add 1 to register
.endm

.imacro	inci	;index,source
	;increment register indexed
 .check	%N=2
	addci	1,%1,%2	;add 1 to register indexed
.endm

.imacro	incm	;address
	;increment memory
 .check	%N=1
	addcm	1,%1
.endm

;decrement macros

.imacro	decr	;source
 .check	%N=1
	;decrement register
	subcr	1,%1	;subtract 1 from register
.endm

.imacro	deci	;index,source
	;decrement register indexed
 .check	%N=2
	subci	1,%1,%2	;subtract 1 from register indexed
.endm

.imacro	decm	;address
	;decrement memory
 .check	%N=1
	subcm	1,%1
.endm

;negate macros

.imacro	negr	;reg
	;negate register
 .check	%N=1
	ldl	%1	;get register
	not
	adc	1	;neg
	stl	%1	;put register
.endm

.imacro	negi	;index,dest
	;negate register indexed
 .check	%N=2
	ldl	%2	;get register
	ldnl	(%1)/4	;get register indexed
	not
	adc	1	;neg
	ldl	%2	;get register
	stnl	(%1)/4	;put register indexed
.endm

.imacro	notr ;reg
 .check	%N=1
	ldl	%1
	not
	stl	%1
.endm

.imacro	negrl	;reg
	;neg.l macro
 .check	%N=1
	ldc	0
	ldc	0
	ldl	%1
	ldiff
	stl	%1
	ldc	0
	ldl	%1+1
	ldiff
	stl	%1+1
.endm

;exchange macros

.imacro	exgrr	;source,dest
	;exchange register with register
 .check	%N=2
	ldl	%1	;get source register
	ldl	%2	;get dest register
	stl	%1	;put source register
	stl	%2	;put dest register
.endm

.imacro	exgrm	;source,dest
	;exchange register with register
 .check	%N=2
	ldl	%1	;get register
	mint	;index from bottom of memory
	ldnl	((%2)-mint)/4
	stl	%1	;put source register
	mint	;index from bottom of memory
	stnl	((%2)-mint)/4
.endm

.imacro	exgir	;index,source,dest
	;exchange indexed with register
 .check	%N=3
	ldl	%2	;get source register
	ldnl	%1/4
	ldl	%3	;get dest register
	ldl	%2	;get source register
	stnl	%1/4
	stl	%3	;put dest register
.endm

;shift macros

.imacro	lsrir	;index,source,dest
	;logical shift right indexed register
 .check	%N=3
	ldl	%3
	ldl	%2
	ldnl	(%1/4)
	shr
	stl	%3
.endm

.imacro	lsrcr	;count,dest
	;logical shift right register
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;get shift count
	shr	;shift right
	stl	%2	;put register
.endm

.imacro	aslrr	;countreg,dest
	;arithmetic shift left register
 .check	%N=2
	ldl	%2	;get register
	ldl	%1	;get shift count
	shl	;shift
	stl	%2	;put register
.endm

.imacro	aslcr	;count,dest
	;arithmetic shift left register
 .check	%N=2
 .if %1=1
	ldl	%2
	dup
	add
	stl	%2
 .else
	ldl	%2	;get register
	ldc	%1	;get shift count
	shl	;shift left
	stl	%2	;put register
 .endif
.endm

.imacro	aslci	;count,index,reg
	;arithmetic shift left indexed
 .check	%N=3
 .if %1=1
	ldl	%3
	ldnl	(%2)/4
	dup
	add
	ldl	%3
	stnl	(%2)/4
 .else
	ldl	%3	;get register
	ldnl	(%2)/4
	ldc	%1	;get shift count
	shl	;shift left
	ldl	%3
	stnl	(%2)/4	;put indexed
 .endif
.endm

.imacro	asrcr	;count,dest
	;arithmetic shift right register
 .check	%N=2
	ldl	%2	;get register
	xdble
	ldc	%1	;get shift count
	lshr	;shift right
	stl	%2	;put register
.endm

.imacro	lsrcrl	;count,dest,dest+1 (LONGINT)
	;logical shift right register & next register
 .check	%N=3
	ldl	%3	;(MS Int)
	ldl	%2	;get register (LS Int)
	ldc	%1	;get shift count
	lshr	;shift right LONGINT
	stl	%2	;put register (LS int)
	stl	%3	;(MS Int)
.endm

.imacro	lsrrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	ldl	%2	;get register
	ldl	%1	;get shift count
	shr	;shift right
	stl	%2	;put register
.endm

;type conversion macros

.imacro	b2ir	;reg
	ldl	%1
	ldc	$80
	xword
	stl	%1
.endm

;divide macros

.imacro	remcr	;const,dest
	;divide register by const
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;get divider
	rem	;signed remainder
	stl	%2	;put register
.endm

.imacro	divcr	;const,dest
	;divide register by const
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;get divider
	div	;signed divide
	stl	%2	;put register
.endm

.imacro	divrr	;src,dest
	;divide register by const
 .check	%N=2
	ldl	%2	;get register
	ldl	%1	;get divider
	div	;signed divide
	stl	%2	;put register
.endm

.imacro	divir	;index,reg,dest
	;divide register by indexed
	ldl	%3	;get register
	ldl	%2
	ldnl	(%1)/4	;get divider
	div	;signed divide
	stl	%3	;put register
.endm

;multyply macros

.imacro	mulcr	;const,dest
	;multyply dest register by const
 .check	%N=2
	ldl	%2	;get dest register
	ldc	%1	;get const
	#nop
	prod
	stl	%2	;put register
.endm

.imacro	mulrr	;source,dest
	;multyply dest register by source
 .check	%N=2
	ldl	%2	;get dest register
	ldl	%1	;get source register
	#nop
	prod
	stl	%2	;put register
.endm

.imacro	mulir	;index,source,dest
	;multyply dest register by indexed
 .check	%N=3
	ldl	%3	;get dest register
	ldl	%2	;get source register
	ldnl	(%1)/4
	#nop
	prod
	stl	%3	;put register
.endm

;compare macros

.imacro	cmpcib	;constant,n,base
	ldl	%3
	adc	%2
	lb
	ldc	%1
.endm

.imacro	cmpcr	;const,dest
	;compare const with register
 .check	%N=2
	ldl	%2	;get register
	ldc	%1	;get const
.endm

.imacro	cmpcm	;const,memory
	;compare const with memory
 .check	%N=2
	mint	;index from bottom of memory
	ldnl	((%2)-mint)/4
	ldc	%1	;get const
.endm

.imacro	cmpmr	;memory,register
	;compare memory with register
 .check	%N=2
	ldl	%2
	mint	;index from bottom of memory
	ldnl	((%1)-mint)/4
.endm

.imacro	cmprm	;register,memory
	;compare register with memory
 .check	%N=2
	mint	;index from bottom of memory
	ldnl	((%2)-mint)/4
	ldl	%1
.endm

.imacro	cmpci	;const,index,dest
	;compare const with register indexed
 .check	%N=3
	ldl	%3
	ldnl	(%2)/4	;get register indexed
	ldc	%1	;get const
.endm

.imacro	cmprr	;source,dest
	;compare register with register
 .check	%N=2
	ldl	%2	;get dest register
	ldl	%1	;get source register
.endm

.imacro	cmpir	;index,source,dest
	;compare register indexed with register
 .check	%N=3
	ldl	%3	;get dest register
	ldl	%2
	ldnl	(%1)/4	;get sorce register indexed
.endm

.imacro	cmpri	;source,index,dest
	;compare register with register indexed
 .check	%N=3
	ldl	%3
	ldnl	(%2)/4	;get dest register indexed
	ldl	%1	;get source register
.endm

;test macros

.imacro	tstd	;index1,index2
	;compare double indexed with 0
	ldl	%1
	ldl	%2
	add
	ldnl	0	;get double indexed
	ldc	0
.endm

.imacro	tstr	;dest
	;compare register with 0
 .check	%N=1
	cmpcr	0,%1	;compare with zero
.endm

.imacro	tstm	;address
	;compare memory with 0
 .check	%N=1
	cmpcm	0,%1	;compare with zero
.endm

.imacro	tsti	;index,dest
	;compare register indexed with 0
 .check	%N=2
	cmpci	0,%1,%2	;compare with zero
.endm

;branch macros

.imacro	_beq
	;if a=b then branch to %1
 .check	%N=1
	diff
	cj	%1
.endm

.imacro	_bne
	;if a<>b then branch to %1
 .check	%N=1
	diff
	eqc	0
	cj	%1
.endm

.imacro	_ble	;%1
	;if b<=a then branch to %1
 .check	%N=1
	gt
	cj	%1
.endm

.imacro	_bgt	;%1
	;if b>a then branch to %1
 .check	%N=1
	gt
	eqc	0
	cj	%1
.endm

.imacro	_blt	;%1
	;if b<a then branch to %1
 .check	%N=1
	rev
	bgt	%1
.endm

.imacro	_bge	;%1
	;if b>=a then branch to %1
 .check	%N=1
	rev
	ble	%1
.endm

.imacro	_bmi	;%1
	;if b<a then branch to %1
 .check	%N=1
	blt	%1
.endm

.imacro	_bpl	;%1
	;if b>=a then branch to %1
 .check	%N=1
	bge	%1
.endm

.imacro	_bra	;%1
	;branch direct
 .check	%N=1
	ldc	0
	cj	%1
.endm

 .if ~?def(kernel_r4)
.imacro	beq
	;if a=b then branch to %1
 .check	%N=1
	diff
	cj	%1
.endm

.imacro	bne
	;if a<>b then branch to %1
 .check	%N=1
	diff
	eqc	0
	cj	%1
.endm

.imacro	ble	;%1
	;if b<=a then branch to %1
 .check	%N=1
	gt
	cj	%1
.endm

.imacro	bgt	;%1
	;if b>a then branch to %1
 .check	%N=1
	gt
	eqc	0
	cj	%1
.endm

.imacro	blt	;%1
	;if b<a then branch to %1
 .check	%N=1
	rev
	bgt	%1
.endm

.imacro	bge	;%1
	;if b>=a then branch to %1
 .check	%N=1
	rev
	ble	%1
.endm

.imacro	bmi	;%1
	;if b<a then branch to %1
 .check	%N=1
	blt	%1
.endm

.imacro	bpl	;%1
	;if b>=a then branch to %1
 .check	%N=1
	bge	%1
.endm

.imacro	gotc	;%1
	;branch direct
 .check	%N=1
	j	%1
.endm

.imacro	bra	;%1
	;branch direct
 .check	%N=1
	ldc	0
	cj	%1
.endm
 .endif

.imacro	gotr	;reg
	;branch indirect
 .check	%N=1
	ldl	%1	;get register
	gcall	;jump to dest
.endm

.imacro	goti	;index,reg
	;branch indirect indexed
 .check	%N=2
	ldl	%2	;get register
	ldnl	(%1)/4
	gcall	;jump to dest
.endm

.imacro	gosc	;address
	;call direct
 .check	%N=1
	ldl	r7	;register r7 is stack pointer
	ldnlp	-1	;push stack down
	stl	r7	;save new stack location
	ldc	%L2-%L1
	ldpi
%L1:
	ldl	r7	;register r7 is stack pointer
	stnl	0	;register on stack
	ldc 0, cj %1
%L2:
.endm

.imacro	gosi	;index,source
	;call indexed
 .check	%N=2
	ldl	%2
	ldnl	(%1)/4
	ldl	r7
	ldnlp	-1
	stl	r7
	ldc	%L2-%L1
	ldpi	;get return address
%L1:
	ldl	r7	;register r7 is stack pointer
	stnl	0	;return address on stack
	gcall	;jump to register
%L2:
.endm

.imacro	gosr	;dest
	;call indirect
 .check	%N=1
	ldl	(%1)
	ldl	r7
	ldnlp	-1
	stl	r7
	ldc	%L2-%L1
	ldpi	;get return address
%L1:
	ldl	r7	;register r7 is stack pointer
	stnl	0	;return address on stack
	gcall	;jump to register
%L2:
.endm

.imacro	return
	;return from subroutine
 .check	%N=0
	ldl	r7	;register r7 is stack
	ldl	r7
	ldnlp	1	;pop return address from stack
	stl	r7	;save new stack location
	ldnl	0	;get return address
	gcall	;jump to return address
.endm

 .if ~?def(kernel_r4)
.imacro	tao	;function
	;taos OS function call
 .check	%N=1
 .if ?def(kernel_r4)
	ldl	16
	ldnl	%1
	ldl	r7	;register r7 is stack pointer
	ldnlp	-1	;push stack down
	stl	r7	;save new stack location
	ldc	%L2-%L1
	ldpi
%L1:	ldl	r7	;register r7 is stack pointer
	stnl	0	;register on stack
	gcall
%L2:
 .else
 .if ?def(TAO_%1)
	pshr	r15
	vcall	TAO/%1
	popr	r15
 .else
	ldl	16
	ldnl	%1
	ldl	r7	;register r7 is stack pointer
	ldnlp	-1	;push stack down
	stl	r7	;save new stack location
	ldc	%L2-%L1
	ldpi
%L1:	ldl	r7	;register r7 is stack pointer
	stnl	0	;register on stack
	gcall
%L2:
 .endif
 .endif
.endm
 .endif

.include 'qcall'

.endif
