.if ~?def(DEF_TAO12VP)
DEF_TAO12VP=TRUE

*******************************
**  TAO12VP.INC for R3000F   **
*******************************

;arh 8oct94 : fixed LEAC to work

;Basic VP macros for R3000F,including gosc (call),return,tao and
;leac (all of which are horrible to encode),and most of the cpyxx 
;types (but beware offsets are all constrained to be small <32k).

;many VP macros are missing; especially CMP/BXX which are difficult to
;efficiently encode in macros.  It is anticipated that these will be
;used for interfacing with VP and most code written using these will
;be coded using the native instructions.

;"nop" and "return_g31" are additions.  Use RETURN_G31 to return from
;a routine where g31 is still set from entry.

;Nop macro

.imacro	nop
	sll	g0,g0,0
.endm

;stack macros

.imacro	pshr	;source
	;push register onto stack
	addiu	r7,r7,-4
	sw	%1,0(r7)
.endm

.imacro	popr	;dest
	;pop register from stack
	lw	%1,0(r7)
	addiu	r7,r7,4
.endm

.imacro	pshm
	addiu	r7,r7,-4*%N
__pushaddr:=%N-1
	recursav	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
.endm

.imacro	recursav
 .ifnb	%1
	sw	%1,__pushaddr*4(r7)
__pushaddr:=__pushaddr-1
	recursav	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	popm
__popaddr:=0
	recursld	%1,%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
	addiu	r7,r7,4*%N
.endm

.imacro	recursld
 .ifnb	%1
	lw	%1,__popaddr*4(r7)
__popaddr:=__popaddr+1
	recursld	%2,%3,%4,%5,%6,%7,%8,%9,%10,%11,%12,%13,%14,%15
 .endif
.endm

.imacro	pshall
	pshm	r0,r1,r2,r3,r4,r5,r6,r8,r9,r10,r11,r12,r13,r14,r15
.endm

.imacro	popall
	popm	r15,r14,r13,r12,r11,r10,r9,r8,r6,r5,r4,r3,r2,r1,r0
.endm

;effective address macros

.imacro	leai	;index,source,dest
	;copy effective address register indexed to register
	;works for small offsets only
 .check	%N=3
	addiu	%3,%2,%1
.endm

.imacro	lead	;index1,index2,dest
	;copy efective address double indexed to register
 .check	%N=3
	addu	%3,%1,%2
.endm

.imacro	leac	;label,dest
	;load effective address pc relative
 .check	%N=2
	bltzal	g0,%La	;dest is dummy,never branches
	;now g31=address of %La
	addiu	%2,g31,(%1)-%La
%La:
.endm

;copy macros

.imacro	cpycr	;const,dest
	;copy const to register
 .check	%N=2
	li	%2,%1
.endm

.imacro	cpyci	;const,index,dest
	;copy const to register indexed
 .check	%N=3
	li	g18,%1
	sw	g18,%2(%3)
.endm

.imacro	cpyrr	;source,dest
	;copy register to register
 .check	%N=2
 .if ~(%1=%2)
	addu	%2,g0,%1
 .endif
.endm

.imacro	cpyir	;index,source,dest
	;copy register indexed to register
 .check	%N=3
	lw	%3,%1(%2)
	nop
.endm

.imacro	cpyri	;source,index,dest
	;copy register to register indexed
 .check	%N=3
	sw	%1,%2(%3)
.endm

.imacro	cpyrd	;source,index1,index2
	;copy register to double indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpyrdb	;src,base,reg2
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpycd	;const,index1,index2
	;copy const to double indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpycdb	;const,index1,index2
	;copy constant to double indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpydr	;index1,index2,dest
	;copy double indexed to register
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpyirb	;n,base,dst
	lbu	%3,%1(%2)
	nop
.endm

.imacro	cpyrib	;src,n,base
	sb	%1,%2(%3)
.endm

.imacro	cpycib	;src,n,base
	.error;unwritten
.endm

.imacro	cpyblk	;source,dest,length
	;copy a block of memory
	;inputs
	;source address
	;destination address
	;length of block (in bytes)
 .check	%N=3
	.error;unwritten
.endm

.imacro	cpystr	;src,dst
	;src and dst point to nul after using.
	.error;unwritten
.endm

;clear macros

.imacro	clrr	;dest
	;clear register
	cpycr	0,%1	;copy zero to register
.endm

.imacro	clri	;index,dest
	;clear register indexed
	cpyci	0,%1,%2		;copy zero to register indexed
.endm

;add macros

.imacro	addrd	;reg,index1,index2
	;add register to double
 .check	%N=3
	.error;unwritten
.endm

.imacro	addcr	;const,dest
	;add const to register
 .check	%N=2
	addiu	%2,%2,%1
.endm

.imacro	addci	;const,index,dest
	;add const to register indexed
 .check	%N=3
	lw	g18,%2(%3)
	nop
	addiu	g18,g18,%1
	sw	g18,%2,(%3)
.endm

.imacro	addrr	;source,dest
	;add register to register
 .check	%N=2
	addu	%2,%1,%2
.endm

.imacro	addir	;index,source,dest
	;add register indexed to register
 .check	%N=3
	.error;unwritten
.endm

.imacro	addri	;source,index,dest
	;add register to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	addcd	;const,index1,index2
	;add const to double
 .check	%N=3
	.error;unwritten
.endm

.imacro	adddr	;index1,index2,reg
	;add double to reg
 .check	%N=3
	.error;unwritten
.endm

;subtract macros

.imacro	subrd	;reg,index1,index2
	;sub register from double
 .check	%N=3
	.error;unwritten
.endm

.imacro	subcd	;const,index1,index2
	;sub const from double
 .check	%N=3
.endm

.imacro	subcr	;const,dest
	;subtract %1 from register
 .check	%N=2
	addiu	%2,%2,-(%1)
.endm

.imacro	subci	;const,index,dest
	;subtract %1 from register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	subrr	;source,dest
	;subtract register from register
 .check	%N=2
	subu	%2,%2,%1
.endm

.imacro	subir	;index,source,dest
	;subtract register indexed from register
 .check	%N=3
	.error;unwritten
.endm

.imacro	subri	;source,index,dest
	;subtract register from register indexed
 .check	%N=3
	.error;unwritten
.endm

;and macros

.imacro	andrd	;reg,index1,index2
	;and register to double
 .check	%N=3
	.error;unwritten
.endm

.imacro	andcr	;const,dest
	;and const to register
 .check	%N=2
	.error;unwritten
.endm

.imacro	andci	;const,index,dest
	;and const to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	andrr	;source,dest
	;and register to register
 .check	%N=2
	.error;unwritten
	#and	%2,%2,%1
.endm

.imacro	andir	;index,source,dest
	;and register indexed to register
 .check	%N=3
	.error;unwritten
.endm

.imacro	andri	;source,index,dest
	;and register to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	andcd	;const,index1,index2
	;and const to double
 .check	%N=3
	.error;unwritten
.endm

;or macros

.imacro	orrd	;reg,index1,index2
	;or register to double
 .check	%N=3
	.error;unwritten
.endm

.imacro	orcr	;const,dest
	;or const to register
 .check	%N=2
	.error;unwritten
.endm

.imacro	orci	;const,index,dest
	;or const to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	orrr	;source,dest
	;or register to register
 .check	%N=2
	#or	%2,%2,%1
.endm

.imacro	orir	;index,source,dest
	;or register indexed to register
 .check	%N=3
	.error;unwritten
.endm

.imacro	orri	;source,index,dest
	;or register to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	orcd	;const,index1,index2
	;or const to double
 .check	%N=3
	.error;unwritten
.endm

;xor macros

.imacro	xorrd	;reg,index1,index2
	;xor register to double
 .check	%N=3
	.error;unwritten
.endm

.imacro	xorcr	;const,dest
	;xor const to register
 .check	%N=2
	.error;unwritten
.endm

.imacro	xorci	;const,index,dest
	;xor const to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	xorrr	;source,dest
	;xor register to register
 .check	%N=2
	#xor	%2,%2,%1
.endm

.imacro	xorir	;index,source,dest
	;xor register indexed to register
 .check	%N=3
	.error;unwritten
.endm

.imacro	xorri	;source,index,dest
	;xor register to register indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	xorcd	;const,index1,index2
	;xor const to double
 .check	%N=3
	.error;unwritten
.endm

;increment macros

.imacro	incr	;source
 .check	%N=1
	;increment register
	addcr	1,%1	;add 1 to register
.endm

.imacro	inci	;index,source
	;increment register indexed
 .check	%N=2
	addci	1,%1,%2	;add 1 to register indexed
.endm

;decrement macros

.imacro	decr	;source
 .check	%N=1
	;decrement register
	subcr	1,%1	;subtract 1 from register
.endm

.imacro	deci	;index,source
	;decrement register indexed
 .check	%N=2
	subci	1,%1,%2	;subtract 1 from register indexed
.endm

;negate macros

.imacro	negr	;reg
	;negate register
 .check	%N=1
	.error;unwritten
.endm

.imacro	negi	;index,dest
	;negate register indexed
 .check	%N=2
	.error;unwritten
.endm

.imacro	notr ;reg
 .check	%N=1
	.error;unwritten
.endm

;exchange macros

.imacro	exgrr	;source,dest
	;exchange register with register
 .check	%N=2
	.error;unwritten
.endm

.imacro	exgir	;index,source,dest
	;exchange indexed with register
 .check	%N=3
	.error;unwritten
.endm

;shift macros

.imacro	lsrir	;index,source,dest
	;logical shift right indexed register
 .check	%N=3
	.error;unwritten
.endm

.imacro	lsrcr	;count,dest
	;logical shift right register
 .check	%N=2
	.error;unwritten
.endm

.imacro	aslrr	;countreg,dest
	;arithmetic shift left register
 .check	%N=2
	.error;unwritten
.endm

.imacro	aslcr	;count,dest
	;arithmetic shift left register
 .check	%N=2
	.error;unwritten
.endm

.imacro	aslci	;count,index,reg
	;arithmetic shift left indexed
 .check	%N=3
	.error;unwritten
.endm

.imacro	asrcr	;count,dest
	;arithmetic shift right register
 .check	%N=2
	.error;unwritten
.endm

.imacro	lsrrr	;countreg,dest
	;logical shift right register
 .check	%N=2
	.error;unwritten
.endm

;type conversion macros

.imacro	b2i	;reg
	.error;unwritten
.endm

;divide macros
;deleted

;compare macros
;deleted

;branches

.imacro	gotc	;%1
	;branch direct
 .check	%N=1
	beq	g0,g0,%1
.endm

.imacro	gotr	;reg
	;branch indirect
 .check	%N=1
	jr	%1
.endm

.imacro	gosc	;address
	;call direct
 .check	%N=1
	addiu	r7,r7,-4
	bgezal	g0,%1
	sw	g31,0(r7)
.endm

.imacro	gosr	;dest
	;call indirect
 .check	%N=1
	addiu	r7,r7,-4
	jalr	%1
	sw	g31,0(r7)
.endm

.imacro	call
 .check	%n=1
	gosc %1
.endm

.imacro	return
	;return from subroutine
 .check	%N=0
	lw	g31,0(r7)
	nop
	jr	g31
	addiu	r7,r7,4
.endm

.imacro	return_g31
	;return from subroutine when g31=link from entry
 .check	%N=0
	jr	g31
	addiu	r7,r7,4
.endm

.imacro	tao	;function
	;taos OS function call
 .check	%N=1
 .if ?def(kernel_r4)
	lw	g1,%1*4(g22)
	addiu	r7,r7,-4
	jalr	g1
	sw	g31,0(r7)
 .else
 .if ?def(TAO_%1)
	pshr	r15
	vcall	TAO/%1
	popr	r15
 .else
	lw	g1,%1*4(g22)
	addiu	r7,r7,-4
	jalr	g1
	sw	g31,0(r7)
 .endif
 .endif
.endm

.include 'qcall'

.endif
